/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.ParameterSet;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.Block;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.value.SequenceType;

public class AttributeSet
extends Instruction {
    private AttributeSet[] useAttributeSets;
    private Block body;
    private boolean needsStackFrame;

    public void initialize(AttributeSet[] attributeSetArray, Block block, boolean bl) {
        this.useAttributeSets = attributeSetArray;
        this.body = block;
        this.needsStackFrame = bl;
    }

    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("attribute-set");
    }

    public SequenceType getResultType() {
        return new SequenceType(NodeKindTest.ATTRIBUTE, 1792);
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        if (this.useAttributeSets != null) {
            AttributeSet.expand(this.useAttributeSets, xPathContext);
        }
        if (this.needsStackFrame) {
            Bindery bindery = xPathContext.getController().getBindery();
            bindery.openStackFrame(ParameterSet.EMPTY_PARAMETER_SET, null);
            this.body.processLeavingTail(xPathContext);
            bindery.closeStackFrame();
        } else {
            this.body.processLeavingTail(xPathContext);
        }
        return null;
    }

    protected static void expand(AttributeSet[] attributeSetArray, XPathContext xPathContext) throws TransformerException {
        int n = 0;
        while (n < attributeSetArray.length) {
            attributeSetArray[n].processLeavingTail(xPathContext);
            ++n;
        }
    }
}

