#!/bin/bash

# check for pending changes
PENDING=$(git status --porcelain)

if [ "x$PENDING" != "x" ]; then
    echo The tree is not clean, cannot release.
    echo $PENDING
    exit 1
fi

LAST_TAG=$(git tag --sort=v:refname | tail -n 1 | cut -d'-' -f2)
NEW_VER=$(($LAST_TAG + 1))

echo Last release was $LAST_TAG - the new release will be $NEW_VER

echo Press ENTER to continue, or ^C to cancel

read ___

echo Changing release number in luxio.c
sed -e"s/^\#define LUXIO_RELEASE $LAST_TAG/#define LUXIO_RELEASE $NEW_VER/" -i luxio.c

echo commiting change and tagging
git commit -m "Update release number to $NEW_VER" luxio.c
git tag luxio-$NEW_VER

echo creating release tarball...

git archive --format=tar -o ../luxio-${NEW_VER}.tar --prefix=luxio-${NEW_VER}/ HEAD

xz -z -e -v ../luxio-${NEW_VER}.tar

echo finished.  Do not forget to push if you want to keep the tag.
echo to revert if you are not happy, do:
echo "git update-ref -d refs/tags/luxio-$NEW_VER"
echo "git reset --hard 'HEAD^'"
echo "rm ../luxio-${NEW_VER}.tar.xz"
