/*****************************************************************************
 * Copyright (C) 2002 Shie Erlich <erlich@users.sourceforge.net>             *
 * Copyright (C) 2002 Rafi Yanai <yanai@users.sourceforge.net>               *
 * Copyright (C) 2004-2018 Krusader Krew [https://krusader.org]              *
 *                                                                           *
 * This file is part of Krusader [https://krusader.org].                     *
 *                                                                           *
 * Krusader is free software: you can redistribute it and/or modify          *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation, either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * Krusader is distributed in the hope that it will be useful,               *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with Krusader.  If not, see [http://www.gnu.org/licenses/].         *
 *****************************************************************************/

#ifndef KRBOOKMARKBUTTON_H
#define KRBOOKMARKBUTTON_H

// QtWidgets
#include <QToolButton>

#include <KWidgetsAddons/KActionMenu>

class KrBookmarkButton: public QToolButton
{
    Q_OBJECT
public:
    explicit KrBookmarkButton(QWidget *parent);
    void showMenu();

signals:
    void openUrl(const QUrl &url);
    void aboutToShow();

protected slots:
    void populate();

private:
    KActionMenu *acmBookmarks;
};

#endif // KRBOOKMARK_BUTTON_H
