#!/bin/sh
set -e

# creates an upstream snapshot tarball
# run from within the upstream git repository

commit=${1:-HEAD}
describe=$(git describe --long --tags ${commit})
ver=${describe%%-*}
gitsuffix=${describe#*-}

base=OpenCL-CLHPP-${ver#v}+git${gitsuffix}
tarball=${base}.tar.xz

git archive --prefix ${base}/ ${commit} | xz > ${tarball}
touch -d "@$(git log -1 --format=format:%ct ${commit})" ${tarball}

echo "Generated snapshot of ${commit} in ${tarball}"
