/*
 * This file is part of the Nepomuk KDE project.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

/*
 * This file has been generated by the Nepomuk Resource class generator.
 * DO NOT EDIT THIS FILE.
 * ANY CHANGES WILL BE LOST.
 */

#include "resource.h"

#include <nepomuk/resourcemanager.h>
#include <soprano/literalvalue.h>
#include <soprano/model.h>
#include <soprano/nao.h>
#include <soprano/rdf.h>
#include <soprano/rdfs.h>

using namespace NepomukFast;

Resource::Resource( const QUrl& uri, const QUrl& graphUri, const QUrl& type )
    : m_uri( uri ), m_graphUri( graphUri ), m_type( type )
{
    if ( m_uri.isEmpty() )
        m_uri = Nepomuk::ResourceManager::instance()->generateUniqueUri( QString() );

    if ( m_graphUri.isEmpty() )
        m_graphUri = Nepomuk::ResourceManager::instance()->generateUniqueUri( QString() );

    if ( m_type.isEmpty() )
        m_type = Soprano::Vocabulary::RDFS::Resource();
    else // add the type right away
        Nepomuk::ResourceManager::instance()->mainModel()->addStatement( m_uri, Soprano::Vocabulary::RDF::type(), m_type, m_graphUri );
}

QUrl Resource::uri() const
{
    return m_uri;
}

QUrl Resource::graphUri() const
{
    return m_graphUri;
}

QUrl Resource::type() const
{
    return m_type;
}

void Resource::addProperty( const QUrl &uri, const Soprano::Node &node )
{
    Nepomuk::ResourceManager::instance()->mainModel()->addStatement( m_uri, uri, node, m_graphUri );
}

void Resource::setLabel( const QString &label )
{
    addProperty( Soprano::Vocabulary::NAO::prefLabel(), Soprano::LiteralValue( label ) );
}
