/* Array of codepoints allowed as operator suffixes in Julia:
   primes and Latin/Greek/math super/subscripts.

   produced by:

   for c in sort(unique(collect("₀₁₂₃₄₅₆₇₈₉₊₋₌₍₎²³¹ʰʲʳʷʸˡˢˣᴬᴮᴰᴱᴳᴴᴵᴶᴷᴸᴹᴺᴼᴾᴿᵀᵁᵂᵃᵇᵈᵉᵍᵏᵐᵒᵖᵗᵘᵛᵝᵞᵟᵠᵡᵢᵣᵤᵥᵦᵧᵨᵩᵪᶜᶠᶥᶦᶫᶰᶸᶻᶿ ⁰ⁱ⁴⁵⁶⁷⁸⁹⁺⁻⁼⁽⁾ⁿₐₑₒₓₕₖₗₘₙₚₛₜⱼⱽ" * "′″‴‵‶‷⁗")))
       println("   ", repr(UInt32(c)), ", // ", c)
   end
*/

static const uint32_t opsuffs[] = {
   0x000000b2, // ²
   0x000000b3, // ³
   0x000000b9, // ¹
   0x000002b0, // ʰ
   0x000002b2, // ʲ
   0x000002b3, // ʳ
   0x000002b7, // ʷ
   0x000002b8, // ʸ
   0x000002e1, // ˡ
   0x000002e2, // ˢ
   0x000002e3, // ˣ
   0x00001d2c, // ᴬ
   0x00001d2e, // ᴮ
   0x00001d30, // ᴰ
   0x00001d31, // ᴱ
   0x00001d33, // ᴳ
   0x00001d34, // ᴴ
   0x00001d35, // ᴵ
   0x00001d36, // ᴶ
   0x00001d37, // ᴷ
   0x00001d38, // ᴸ
   0x00001d39, // ᴹ
   0x00001d3a, // ᴺ
   0x00001d3c, // ᴼ
   0x00001d3e, // ᴾ
   0x00001d3f, // ᴿ
   0x00001d40, // ᵀ
   0x00001d41, // ᵁ
   0x00001d42, // ᵂ
   0x00001d43, // ᵃ
   0x00001d47, // ᵇ
   0x00001d48, // ᵈ
   0x00001d49, // ᵉ
   0x00001d4d, // ᵍ
   0x00001d4f, // ᵏ
   0x00001d50, // ᵐ
   0x00001d52, // ᵒ
   0x00001d56, // ᵖ
   0x00001d57, // ᵗ
   0x00001d58, // ᵘ
   0x00001d5b, // ᵛ
   0x00001d5d, // ᵝ
   0x00001d5e, // ᵞ
   0x00001d5f, // ᵟ
   0x00001d60, // ᵠ
   0x00001d61, // ᵡ
   0x00001d62, // ᵢ
   0x00001d63, // ᵣ
   0x00001d64, // ᵤ
   0x00001d65, // ᵥ
   0x00001d66, // ᵦ
   0x00001d67, // ᵧ
   0x00001d68, // ᵨ
   0x00001d69, // ᵩ
   0x00001d6a, // ᵪ
   0x00001d9c, // ᶜ
   0x00001da0, // ᶠ
   0x00001da5, // ᶥ
   0x00001da6, // ᶦ
   0x00001dab, // ᶫ
   0x00001db0, // ᶰ
   0x00001db8, // ᶸ
   0x00001dbb, // ᶻ
   0x00001dbf, // ᶿ
   0x00002009, //  
   0x00002032, // ′
   0x00002033, // ″
   0x00002034, // ‴
   0x00002035, // ‵
   0x00002036, // ‶
   0x00002037, // ‷
   0x00002057, // ⁗
   0x00002070, // ⁰
   0x00002071, // ⁱ
   0x00002074, // ⁴
   0x00002075, // ⁵
   0x00002076, // ⁶
   0x00002077, // ⁷
   0x00002078, // ⁸
   0x00002079, // ⁹
   0x0000207a, // ⁺
   0x0000207b, // ⁻
   0x0000207c, // ⁼
   0x0000207d, // ⁽
   0x0000207e, // ⁾
   0x0000207f, // ⁿ
   0x00002080, // ₀
   0x00002081, // ₁
   0x00002082, // ₂
   0x00002083, // ₃
   0x00002084, // ₄
   0x00002085, // ₅
   0x00002086, // ₆
   0x00002087, // ₇
   0x00002088, // ₈
   0x00002089, // ₉
   0x0000208a, // ₊
   0x0000208b, // ₋
   0x0000208c, // ₌
   0x0000208d, // ₍
   0x0000208e, // ₎
   0x00002090, // ₐ
   0x00002091, // ₑ
   0x00002092, // ₒ
   0x00002093, // ₓ
   0x00002095, // ₕ
   0x00002096, // ₖ
   0x00002097, // ₗ
   0x00002098, // ₘ
   0x00002099, // ₙ
   0x0000209a, // ₚ
   0x0000209b, // ₛ
   0x0000209c, // ₜ
   0x00002c7c, // ⱼ
   0x00002c7d  // ⱽ
};
