// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/videointelligence/v1/video_intelligence.proto

package videointelligence // import "google.golang.org/genproto/googleapis/cloud/videointelligence/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import status "google.golang.org/genproto/googleapis/rpc/status"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Video annotation feature.
type Feature int32

const (
	// Unspecified.
	Feature_FEATURE_UNSPECIFIED Feature = 0
	// Label detection. Detect objects, such as dog or flower.
	Feature_LABEL_DETECTION Feature = 1
	// Shot change detection.
	Feature_SHOT_CHANGE_DETECTION Feature = 2
	// Explicit content detection.
	Feature_EXPLICIT_CONTENT_DETECTION Feature = 3
	// Human face detection and tracking.
	Feature_FACE_DETECTION Feature = 4
	// Speech transcription.
	Feature_SPEECH_TRANSCRIPTION Feature = 6
)

var Feature_name = map[int32]string{
	0: "FEATURE_UNSPECIFIED",
	1: "LABEL_DETECTION",
	2: "SHOT_CHANGE_DETECTION",
	3: "EXPLICIT_CONTENT_DETECTION",
	4: "FACE_DETECTION",
	6: "SPEECH_TRANSCRIPTION",
}
var Feature_value = map[string]int32{
	"FEATURE_UNSPECIFIED":        0,
	"LABEL_DETECTION":            1,
	"SHOT_CHANGE_DETECTION":      2,
	"EXPLICIT_CONTENT_DETECTION": 3,
	"FACE_DETECTION":             4,
	"SPEECH_TRANSCRIPTION":       6,
}

func (x Feature) String() string {
	return proto.EnumName(Feature_name, int32(x))
}
func (Feature) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{0}
}

// Label detection mode.
type LabelDetectionMode int32

const (
	// Unspecified.
	LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED LabelDetectionMode = 0
	// Detect shot-level labels.
	LabelDetectionMode_SHOT_MODE LabelDetectionMode = 1
	// Detect frame-level labels.
	LabelDetectionMode_FRAME_MODE LabelDetectionMode = 2
	// Detect both shot-level and frame-level labels.
	LabelDetectionMode_SHOT_AND_FRAME_MODE LabelDetectionMode = 3
)

var LabelDetectionMode_name = map[int32]string{
	0: "LABEL_DETECTION_MODE_UNSPECIFIED",
	1: "SHOT_MODE",
	2: "FRAME_MODE",
	3: "SHOT_AND_FRAME_MODE",
}
var LabelDetectionMode_value = map[string]int32{
	"LABEL_DETECTION_MODE_UNSPECIFIED": 0,
	"SHOT_MODE":                        1,
	"FRAME_MODE":                       2,
	"SHOT_AND_FRAME_MODE":              3,
}

func (x LabelDetectionMode) String() string {
	return proto.EnumName(LabelDetectionMode_name, int32(x))
}
func (LabelDetectionMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{1}
}

// Bucketized representation of likelihood.
type Likelihood int32

const (
	// Unspecified likelihood.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Very unlikely.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	// Unlikely.
	Likelihood_UNLIKELY Likelihood = 2
	// Possible.
	Likelihood_POSSIBLE Likelihood = 3
	// Likely.
	Likelihood_LIKELY Likelihood = 4
	// Very likely.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{2}
}

// Video annotation request.
type AnnotateVideoRequest struct {
	// Input video location. Currently, only
	// [Google Cloud Storage](https://cloud.google.com/storage/) URIs are
	// supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	// A video URI may include wildcards in `object-id`, and thus identify
	// multiple videos. Supported wildcards: '*' to match 0 or more characters;
	// '?' to match 1 character. If unset, the input video should be embedded
	// in the request as `input_content`. If set, `input_content` should be unset.
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// The video data bytes.
	// If unset, the input video(s) should be specified via `input_uri`.
	// If set, `input_uri` should be unset.
	InputContent []byte `protobuf:"bytes,6,opt,name=input_content,json=inputContent,proto3" json:"input_content,omitempty"`
	// Requested video annotation features.
	Features []Feature `protobuf:"varint,2,rep,packed,name=features,proto3,enum=google.cloud.videointelligence.v1.Feature" json:"features,omitempty"`
	// Additional video context and/or feature-specific parameters.
	VideoContext *VideoContext `protobuf:"bytes,3,opt,name=video_context,json=videoContext,proto3" json:"video_context,omitempty"`
	// Optional location where the output (in JSON format) should be stored.
	// Currently, only [Google Cloud Storage](https://cloud.google.com/storage/)
	// URIs are supported, which must be specified in the following format:
	// `gs://bucket-id/object-id` (other URI formats return
	// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]). For more information, see
	// [Request URIs](/storage/docs/reference-uris).
	OutputUri string `protobuf:"bytes,4,opt,name=output_uri,json=outputUri,proto3" json:"output_uri,omitempty"`
	// Optional cloud region where annotation should take place. Supported cloud
	// regions: `us-east1`, `us-west1`, `europe-west1`, `asia-east1`. If no region
	// is specified, a region will be determined based on video file location.
	LocationId           string   `protobuf:"bytes,5,opt,name=location_id,json=locationId,proto3" json:"location_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AnnotateVideoRequest) Reset()         { *m = AnnotateVideoRequest{} }
func (m *AnnotateVideoRequest) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoRequest) ProtoMessage()    {}
func (*AnnotateVideoRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{0}
}
func (m *AnnotateVideoRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoRequest.Unmarshal(m, b)
}
func (m *AnnotateVideoRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoRequest.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoRequest.Merge(dst, src)
}
func (m *AnnotateVideoRequest) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoRequest.Size(m)
}
func (m *AnnotateVideoRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoRequest proto.InternalMessageInfo

func (m *AnnotateVideoRequest) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetInputContent() []byte {
	if m != nil {
		return m.InputContent
	}
	return nil
}

func (m *AnnotateVideoRequest) GetFeatures() []Feature {
	if m != nil {
		return m.Features
	}
	return nil
}

func (m *AnnotateVideoRequest) GetVideoContext() *VideoContext {
	if m != nil {
		return m.VideoContext
	}
	return nil
}

func (m *AnnotateVideoRequest) GetOutputUri() string {
	if m != nil {
		return m.OutputUri
	}
	return ""
}

func (m *AnnotateVideoRequest) GetLocationId() string {
	if m != nil {
		return m.LocationId
	}
	return ""
}

// Video context and/or feature-specific parameters.
type VideoContext struct {
	// Video segments to annotate. The segments may overlap and are not required
	// to be contiguous or span the whole video. If unspecified, each video is
	// treated as a single segment.
	Segments []*VideoSegment `protobuf:"bytes,1,rep,name=segments,proto3" json:"segments,omitempty"`
	// Config for LABEL_DETECTION.
	LabelDetectionConfig *LabelDetectionConfig `protobuf:"bytes,2,opt,name=label_detection_config,json=labelDetectionConfig,proto3" json:"label_detection_config,omitempty"`
	// Config for SHOT_CHANGE_DETECTION.
	ShotChangeDetectionConfig *ShotChangeDetectionConfig `protobuf:"bytes,3,opt,name=shot_change_detection_config,json=shotChangeDetectionConfig,proto3" json:"shot_change_detection_config,omitempty"`
	// Config for EXPLICIT_CONTENT_DETECTION.
	ExplicitContentDetectionConfig *ExplicitContentDetectionConfig `protobuf:"bytes,4,opt,name=explicit_content_detection_config,json=explicitContentDetectionConfig,proto3" json:"explicit_content_detection_config,omitempty"`
	// Config for FACE_DETECTION.
	FaceDetectionConfig *FaceDetectionConfig `protobuf:"bytes,5,opt,name=face_detection_config,json=faceDetectionConfig,proto3" json:"face_detection_config,omitempty"`
	// Config for SPEECH_TRANSCRIPTION.
	SpeechTranscriptionConfig *SpeechTranscriptionConfig `protobuf:"bytes,6,opt,name=speech_transcription_config,json=speechTranscriptionConfig,proto3" json:"speech_transcription_config,omitempty"`
	XXX_NoUnkeyedLiteral      struct{}                   `json:"-"`
	XXX_unrecognized          []byte                     `json:"-"`
	XXX_sizecache             int32                      `json:"-"`
}

func (m *VideoContext) Reset()         { *m = VideoContext{} }
func (m *VideoContext) String() string { return proto.CompactTextString(m) }
func (*VideoContext) ProtoMessage()    {}
func (*VideoContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{1}
}
func (m *VideoContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoContext.Unmarshal(m, b)
}
func (m *VideoContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoContext.Marshal(b, m, deterministic)
}
func (dst *VideoContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoContext.Merge(dst, src)
}
func (m *VideoContext) XXX_Size() int {
	return xxx_messageInfo_VideoContext.Size(m)
}
func (m *VideoContext) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoContext.DiscardUnknown(m)
}

var xxx_messageInfo_VideoContext proto.InternalMessageInfo

func (m *VideoContext) GetSegments() []*VideoSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *VideoContext) GetLabelDetectionConfig() *LabelDetectionConfig {
	if m != nil {
		return m.LabelDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetShotChangeDetectionConfig() *ShotChangeDetectionConfig {
	if m != nil {
		return m.ShotChangeDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetExplicitContentDetectionConfig() *ExplicitContentDetectionConfig {
	if m != nil {
		return m.ExplicitContentDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetFaceDetectionConfig() *FaceDetectionConfig {
	if m != nil {
		return m.FaceDetectionConfig
	}
	return nil
}

func (m *VideoContext) GetSpeechTranscriptionConfig() *SpeechTranscriptionConfig {
	if m != nil {
		return m.SpeechTranscriptionConfig
	}
	return nil
}

// Config for LABEL_DETECTION.
type LabelDetectionConfig struct {
	// What labels should be detected with LABEL_DETECTION, in addition to
	// video-level labels or segment-level labels.
	// If unspecified, defaults to `SHOT_MODE`.
	LabelDetectionMode LabelDetectionMode `protobuf:"varint,1,opt,name=label_detection_mode,json=labelDetectionMode,proto3,enum=google.cloud.videointelligence.v1.LabelDetectionMode" json:"label_detection_mode,omitempty"`
	// Whether the video has been shot from a stationary (i.e. non-moving) camera.
	// When set to true, might improve detection accuracy for moving objects.
	// Should be used with `SHOT_AND_FRAME_MODE` enabled.
	StationaryCamera bool `protobuf:"varint,2,opt,name=stationary_camera,json=stationaryCamera,proto3" json:"stationary_camera,omitempty"`
	// Model to use for label detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,3,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelDetectionConfig) Reset()         { *m = LabelDetectionConfig{} }
func (m *LabelDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*LabelDetectionConfig) ProtoMessage()    {}
func (*LabelDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{2}
}
func (m *LabelDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelDetectionConfig.Unmarshal(m, b)
}
func (m *LabelDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *LabelDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelDetectionConfig.Merge(dst, src)
}
func (m *LabelDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_LabelDetectionConfig.Size(m)
}
func (m *LabelDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_LabelDetectionConfig proto.InternalMessageInfo

func (m *LabelDetectionConfig) GetLabelDetectionMode() LabelDetectionMode {
	if m != nil {
		return m.LabelDetectionMode
	}
	return LabelDetectionMode_LABEL_DETECTION_MODE_UNSPECIFIED
}

func (m *LabelDetectionConfig) GetStationaryCamera() bool {
	if m != nil {
		return m.StationaryCamera
	}
	return false
}

func (m *LabelDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for SHOT_CHANGE_DETECTION.
type ShotChangeDetectionConfig struct {
	// Model to use for shot change detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ShotChangeDetectionConfig) Reset()         { *m = ShotChangeDetectionConfig{} }
func (m *ShotChangeDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ShotChangeDetectionConfig) ProtoMessage()    {}
func (*ShotChangeDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{3}
}
func (m *ShotChangeDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ShotChangeDetectionConfig.Unmarshal(m, b)
}
func (m *ShotChangeDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ShotChangeDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ShotChangeDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ShotChangeDetectionConfig.Merge(dst, src)
}
func (m *ShotChangeDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ShotChangeDetectionConfig.Size(m)
}
func (m *ShotChangeDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ShotChangeDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ShotChangeDetectionConfig proto.InternalMessageInfo

func (m *ShotChangeDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for EXPLICIT_CONTENT_DETECTION.
type ExplicitContentDetectionConfig struct {
	// Model to use for explicit content detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model                string   `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExplicitContentDetectionConfig) Reset()         { *m = ExplicitContentDetectionConfig{} }
func (m *ExplicitContentDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentDetectionConfig) ProtoMessage()    {}
func (*ExplicitContentDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{4}
}
func (m *ExplicitContentDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Unmarshal(m, b)
}
func (m *ExplicitContentDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentDetectionConfig.Merge(dst, src)
}
func (m *ExplicitContentDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentDetectionConfig.Size(m)
}
func (m *ExplicitContentDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentDetectionConfig proto.InternalMessageInfo

func (m *ExplicitContentDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

// Config for FACE_DETECTION.
type FaceDetectionConfig struct {
	// Model to use for face detection.
	// Supported values: "builtin/stable" (the default if unset) and
	// "builtin/latest".
	Model string `protobuf:"bytes,1,opt,name=model,proto3" json:"model,omitempty"`
	// Whether bounding boxes be included in the face annotation output.
	IncludeBoundingBoxes bool     `protobuf:"varint,2,opt,name=include_bounding_boxes,json=includeBoundingBoxes,proto3" json:"include_bounding_boxes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FaceDetectionConfig) Reset()         { *m = FaceDetectionConfig{} }
func (m *FaceDetectionConfig) String() string { return proto.CompactTextString(m) }
func (*FaceDetectionConfig) ProtoMessage()    {}
func (*FaceDetectionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{5}
}
func (m *FaceDetectionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceDetectionConfig.Unmarshal(m, b)
}
func (m *FaceDetectionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceDetectionConfig.Marshal(b, m, deterministic)
}
func (dst *FaceDetectionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceDetectionConfig.Merge(dst, src)
}
func (m *FaceDetectionConfig) XXX_Size() int {
	return xxx_messageInfo_FaceDetectionConfig.Size(m)
}
func (m *FaceDetectionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceDetectionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_FaceDetectionConfig proto.InternalMessageInfo

func (m *FaceDetectionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *FaceDetectionConfig) GetIncludeBoundingBoxes() bool {
	if m != nil {
		return m.IncludeBoundingBoxes
	}
	return false
}

// Video segment.
type VideoSegment struct {
	// Time-offset, relative to the beginning of the video,
	// corresponding to the start of the segment (inclusive).
	StartTimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=start_time_offset,json=startTimeOffset,proto3" json:"start_time_offset,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the end of the segment (inclusive).
	EndTimeOffset        *duration.Duration `protobuf:"bytes,2,opt,name=end_time_offset,json=endTimeOffset,proto3" json:"end_time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *VideoSegment) Reset()         { *m = VideoSegment{} }
func (m *VideoSegment) String() string { return proto.CompactTextString(m) }
func (*VideoSegment) ProtoMessage()    {}
func (*VideoSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{6}
}
func (m *VideoSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoSegment.Unmarshal(m, b)
}
func (m *VideoSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoSegment.Marshal(b, m, deterministic)
}
func (dst *VideoSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoSegment.Merge(dst, src)
}
func (m *VideoSegment) XXX_Size() int {
	return xxx_messageInfo_VideoSegment.Size(m)
}
func (m *VideoSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoSegment.DiscardUnknown(m)
}

var xxx_messageInfo_VideoSegment proto.InternalMessageInfo

func (m *VideoSegment) GetStartTimeOffset() *duration.Duration {
	if m != nil {
		return m.StartTimeOffset
	}
	return nil
}

func (m *VideoSegment) GetEndTimeOffset() *duration.Duration {
	if m != nil {
		return m.EndTimeOffset
	}
	return nil
}

// Video segment level annotation results for label detection.
type LabelSegment struct {
	// Video segment where a label was detected.
	Segment *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelSegment) Reset()         { *m = LabelSegment{} }
func (m *LabelSegment) String() string { return proto.CompactTextString(m) }
func (*LabelSegment) ProtoMessage()    {}
func (*LabelSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{7}
}
func (m *LabelSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelSegment.Unmarshal(m, b)
}
func (m *LabelSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelSegment.Marshal(b, m, deterministic)
}
func (dst *LabelSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelSegment.Merge(dst, src)
}
func (m *LabelSegment) XXX_Size() int {
	return xxx_messageInfo_LabelSegment.Size(m)
}
func (m *LabelSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelSegment.DiscardUnknown(m)
}

var xxx_messageInfo_LabelSegment proto.InternalMessageInfo

func (m *LabelSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

func (m *LabelSegment) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Video frame level annotation results for label detection.
type LabelFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Confidence that the label is accurate. Range: [0, 1].
	Confidence           float32  `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LabelFrame) Reset()         { *m = LabelFrame{} }
func (m *LabelFrame) String() string { return proto.CompactTextString(m) }
func (*LabelFrame) ProtoMessage()    {}
func (*LabelFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{8}
}
func (m *LabelFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelFrame.Unmarshal(m, b)
}
func (m *LabelFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelFrame.Marshal(b, m, deterministic)
}
func (dst *LabelFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelFrame.Merge(dst, src)
}
func (m *LabelFrame) XXX_Size() int {
	return xxx_messageInfo_LabelFrame.Size(m)
}
func (m *LabelFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelFrame.DiscardUnknown(m)
}

var xxx_messageInfo_LabelFrame proto.InternalMessageInfo

func (m *LabelFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *LabelFrame) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

// Detected entity from video analysis.
type Entity struct {
	// Opaque entity ID. Some IDs may be available in
	// [Google Knowledge Graph Search
	// API](https://developers.google.com/knowledge-graph/).
	EntityId string `protobuf:"bytes,1,opt,name=entity_id,json=entityId,proto3" json:"entity_id,omitempty"`
	// Textual description, e.g. `Fixed-gear bicycle`.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Language code for `description` in BCP-47 format.
	LanguageCode         string   `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Entity) Reset()         { *m = Entity{} }
func (m *Entity) String() string { return proto.CompactTextString(m) }
func (*Entity) ProtoMessage()    {}
func (*Entity) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{9}
}
func (m *Entity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Entity.Unmarshal(m, b)
}
func (m *Entity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Entity.Marshal(b, m, deterministic)
}
func (dst *Entity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Entity.Merge(dst, src)
}
func (m *Entity) XXX_Size() int {
	return xxx_messageInfo_Entity.Size(m)
}
func (m *Entity) XXX_DiscardUnknown() {
	xxx_messageInfo_Entity.DiscardUnknown(m)
}

var xxx_messageInfo_Entity proto.InternalMessageInfo

func (m *Entity) GetEntityId() string {
	if m != nil {
		return m.EntityId
	}
	return ""
}

func (m *Entity) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Entity) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Label annotation.
type LabelAnnotation struct {
	// Detected entity.
	Entity *Entity `protobuf:"bytes,1,opt,name=entity,proto3" json:"entity,omitempty"`
	// Common categories for the detected entity.
	// E.g. when the label is `Terrier` the category is likely `dog`. And in some
	// cases there might be more than one categories e.g. `Terrier` could also be
	// a `pet`.
	CategoryEntities []*Entity `protobuf:"bytes,2,rep,name=category_entities,json=categoryEntities,proto3" json:"category_entities,omitempty"`
	// All video segments where a label was detected.
	Segments []*LabelSegment `protobuf:"bytes,3,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a label was detected.
	Frames               []*LabelFrame `protobuf:"bytes,4,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *LabelAnnotation) Reset()         { *m = LabelAnnotation{} }
func (m *LabelAnnotation) String() string { return proto.CompactTextString(m) }
func (*LabelAnnotation) ProtoMessage()    {}
func (*LabelAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{10}
}
func (m *LabelAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LabelAnnotation.Unmarshal(m, b)
}
func (m *LabelAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LabelAnnotation.Marshal(b, m, deterministic)
}
func (dst *LabelAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LabelAnnotation.Merge(dst, src)
}
func (m *LabelAnnotation) XXX_Size() int {
	return xxx_messageInfo_LabelAnnotation.Size(m)
}
func (m *LabelAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_LabelAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_LabelAnnotation proto.InternalMessageInfo

func (m *LabelAnnotation) GetEntity() *Entity {
	if m != nil {
		return m.Entity
	}
	return nil
}

func (m *LabelAnnotation) GetCategoryEntities() []*Entity {
	if m != nil {
		return m.CategoryEntities
	}
	return nil
}

func (m *LabelAnnotation) GetSegments() []*LabelSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *LabelAnnotation) GetFrames() []*LabelFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Video frame level annotation results for explicit content.
type ExplicitContentFrame struct {
	// Time-offset, relative to the beginning of the video, corresponding to the
	// video frame for this location.
	TimeOffset *duration.Duration `protobuf:"bytes,1,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	// Likelihood of the pornography content..
	PornographyLikelihood Likelihood `protobuf:"varint,2,opt,name=pornography_likelihood,json=pornographyLikelihood,proto3,enum=google.cloud.videointelligence.v1.Likelihood" json:"pornography_likelihood,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}   `json:"-"`
	XXX_unrecognized      []byte     `json:"-"`
	XXX_sizecache         int32      `json:"-"`
}

func (m *ExplicitContentFrame) Reset()         { *m = ExplicitContentFrame{} }
func (m *ExplicitContentFrame) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentFrame) ProtoMessage()    {}
func (*ExplicitContentFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{11}
}
func (m *ExplicitContentFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentFrame.Unmarshal(m, b)
}
func (m *ExplicitContentFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentFrame.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentFrame.Merge(dst, src)
}
func (m *ExplicitContentFrame) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentFrame.Size(m)
}
func (m *ExplicitContentFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentFrame.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentFrame proto.InternalMessageInfo

func (m *ExplicitContentFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

func (m *ExplicitContentFrame) GetPornographyLikelihood() Likelihood {
	if m != nil {
		return m.PornographyLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

// Explicit content annotation (based on per-frame visual signals only).
// If no explicit content has been detected in a frame, no annotations are
// present for that frame.
type ExplicitContentAnnotation struct {
	// All video frames where explicit content was detected.
	Frames               []*ExplicitContentFrame `protobuf:"bytes,1,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *ExplicitContentAnnotation) Reset()         { *m = ExplicitContentAnnotation{} }
func (m *ExplicitContentAnnotation) String() string { return proto.CompactTextString(m) }
func (*ExplicitContentAnnotation) ProtoMessage()    {}
func (*ExplicitContentAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{12}
}
func (m *ExplicitContentAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExplicitContentAnnotation.Unmarshal(m, b)
}
func (m *ExplicitContentAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExplicitContentAnnotation.Marshal(b, m, deterministic)
}
func (dst *ExplicitContentAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExplicitContentAnnotation.Merge(dst, src)
}
func (m *ExplicitContentAnnotation) XXX_Size() int {
	return xxx_messageInfo_ExplicitContentAnnotation.Size(m)
}
func (m *ExplicitContentAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_ExplicitContentAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_ExplicitContentAnnotation proto.InternalMessageInfo

func (m *ExplicitContentAnnotation) GetFrames() []*ExplicitContentFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Normalized bounding box.
// The normalized vertex coordinates are relative to the original image.
// Range: [0, 1].
type NormalizedBoundingBox struct {
	// Left X coordinate.
	Left float32 `protobuf:"fixed32,1,opt,name=left,proto3" json:"left,omitempty"`
	// Top Y coordinate.
	Top float32 `protobuf:"fixed32,2,opt,name=top,proto3" json:"top,omitempty"`
	// Right X coordinate.
	Right float32 `protobuf:"fixed32,3,opt,name=right,proto3" json:"right,omitempty"`
	// Bottom Y coordinate.
	Bottom               float32  `protobuf:"fixed32,4,opt,name=bottom,proto3" json:"bottom,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *NormalizedBoundingBox) Reset()         { *m = NormalizedBoundingBox{} }
func (m *NormalizedBoundingBox) String() string { return proto.CompactTextString(m) }
func (*NormalizedBoundingBox) ProtoMessage()    {}
func (*NormalizedBoundingBox) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{13}
}
func (m *NormalizedBoundingBox) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NormalizedBoundingBox.Unmarshal(m, b)
}
func (m *NormalizedBoundingBox) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NormalizedBoundingBox.Marshal(b, m, deterministic)
}
func (dst *NormalizedBoundingBox) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NormalizedBoundingBox.Merge(dst, src)
}
func (m *NormalizedBoundingBox) XXX_Size() int {
	return xxx_messageInfo_NormalizedBoundingBox.Size(m)
}
func (m *NormalizedBoundingBox) XXX_DiscardUnknown() {
	xxx_messageInfo_NormalizedBoundingBox.DiscardUnknown(m)
}

var xxx_messageInfo_NormalizedBoundingBox proto.InternalMessageInfo

func (m *NormalizedBoundingBox) GetLeft() float32 {
	if m != nil {
		return m.Left
	}
	return 0
}

func (m *NormalizedBoundingBox) GetTop() float32 {
	if m != nil {
		return m.Top
	}
	return 0
}

func (m *NormalizedBoundingBox) GetRight() float32 {
	if m != nil {
		return m.Right
	}
	return 0
}

func (m *NormalizedBoundingBox) GetBottom() float32 {
	if m != nil {
		return m.Bottom
	}
	return 0
}

// Video segment level annotation results for face detection.
type FaceSegment struct {
	// Video segment where a face was detected.
	Segment              *VideoSegment `protobuf:"bytes,1,opt,name=segment,proto3" json:"segment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *FaceSegment) Reset()         { *m = FaceSegment{} }
func (m *FaceSegment) String() string { return proto.CompactTextString(m) }
func (*FaceSegment) ProtoMessage()    {}
func (*FaceSegment) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{14}
}
func (m *FaceSegment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceSegment.Unmarshal(m, b)
}
func (m *FaceSegment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceSegment.Marshal(b, m, deterministic)
}
func (dst *FaceSegment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceSegment.Merge(dst, src)
}
func (m *FaceSegment) XXX_Size() int {
	return xxx_messageInfo_FaceSegment.Size(m)
}
func (m *FaceSegment) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceSegment.DiscardUnknown(m)
}

var xxx_messageInfo_FaceSegment proto.InternalMessageInfo

func (m *FaceSegment) GetSegment() *VideoSegment {
	if m != nil {
		return m.Segment
	}
	return nil
}

// Video frame level annotation results for face detection.
type FaceFrame struct {
	// Normalized Bounding boxes in a frame.
	// There can be more than one boxes if the same face is detected in multiple
	// locations within the current frame.
	NormalizedBoundingBoxes []*NormalizedBoundingBox `protobuf:"bytes,1,rep,name=normalized_bounding_boxes,json=normalizedBoundingBoxes,proto3" json:"normalized_bounding_boxes,omitempty"`
	// Time-offset, relative to the beginning of the video,
	// corresponding to the video frame for this location.
	TimeOffset           *duration.Duration `protobuf:"bytes,2,opt,name=time_offset,json=timeOffset,proto3" json:"time_offset,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *FaceFrame) Reset()         { *m = FaceFrame{} }
func (m *FaceFrame) String() string { return proto.CompactTextString(m) }
func (*FaceFrame) ProtoMessage()    {}
func (*FaceFrame) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{15}
}
func (m *FaceFrame) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceFrame.Unmarshal(m, b)
}
func (m *FaceFrame) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceFrame.Marshal(b, m, deterministic)
}
func (dst *FaceFrame) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceFrame.Merge(dst, src)
}
func (m *FaceFrame) XXX_Size() int {
	return xxx_messageInfo_FaceFrame.Size(m)
}
func (m *FaceFrame) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceFrame.DiscardUnknown(m)
}

var xxx_messageInfo_FaceFrame proto.InternalMessageInfo

func (m *FaceFrame) GetNormalizedBoundingBoxes() []*NormalizedBoundingBox {
	if m != nil {
		return m.NormalizedBoundingBoxes
	}
	return nil
}

func (m *FaceFrame) GetTimeOffset() *duration.Duration {
	if m != nil {
		return m.TimeOffset
	}
	return nil
}

// Face annotation.
type FaceAnnotation struct {
	// Thumbnail of a representative face view (in JPEG format).
	Thumbnail []byte `protobuf:"bytes,1,opt,name=thumbnail,proto3" json:"thumbnail,omitempty"`
	// All video segments where a face was detected.
	Segments []*FaceSegment `protobuf:"bytes,2,rep,name=segments,proto3" json:"segments,omitempty"`
	// All video frames where a face was detected.
	Frames               []*FaceFrame `protobuf:"bytes,3,rep,name=frames,proto3" json:"frames,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *FaceAnnotation) Reset()         { *m = FaceAnnotation{} }
func (m *FaceAnnotation) String() string { return proto.CompactTextString(m) }
func (*FaceAnnotation) ProtoMessage()    {}
func (*FaceAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{16}
}
func (m *FaceAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FaceAnnotation.Unmarshal(m, b)
}
func (m *FaceAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FaceAnnotation.Marshal(b, m, deterministic)
}
func (dst *FaceAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FaceAnnotation.Merge(dst, src)
}
func (m *FaceAnnotation) XXX_Size() int {
	return xxx_messageInfo_FaceAnnotation.Size(m)
}
func (m *FaceAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_FaceAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_FaceAnnotation proto.InternalMessageInfo

func (m *FaceAnnotation) GetThumbnail() []byte {
	if m != nil {
		return m.Thumbnail
	}
	return nil
}

func (m *FaceAnnotation) GetSegments() []*FaceSegment {
	if m != nil {
		return m.Segments
	}
	return nil
}

func (m *FaceAnnotation) GetFrames() []*FaceFrame {
	if m != nil {
		return m.Frames
	}
	return nil
}

// Annotation results for a single video.
type VideoAnnotationResults struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Label annotations on video level or user specified segment level.
	// There is exactly one element for each unique label.
	SegmentLabelAnnotations []*LabelAnnotation `protobuf:"bytes,2,rep,name=segment_label_annotations,json=segmentLabelAnnotations,proto3" json:"segment_label_annotations,omitempty"`
	// Label annotations on shot level.
	// There is exactly one element for each unique label.
	ShotLabelAnnotations []*LabelAnnotation `protobuf:"bytes,3,rep,name=shot_label_annotations,json=shotLabelAnnotations,proto3" json:"shot_label_annotations,omitempty"`
	// Label annotations on frame level.
	// There is exactly one element for each unique label.
	FrameLabelAnnotations []*LabelAnnotation `protobuf:"bytes,4,rep,name=frame_label_annotations,json=frameLabelAnnotations,proto3" json:"frame_label_annotations,omitempty"`
	// Face annotations. There is exactly one element for each unique face.
	FaceAnnotations []*FaceAnnotation `protobuf:"bytes,5,rep,name=face_annotations,json=faceAnnotations,proto3" json:"face_annotations,omitempty"`
	// Shot annotations. Each shot is represented as a video segment.
	ShotAnnotations []*VideoSegment `protobuf:"bytes,6,rep,name=shot_annotations,json=shotAnnotations,proto3" json:"shot_annotations,omitempty"`
	// Explicit content annotation.
	ExplicitAnnotation *ExplicitContentAnnotation `protobuf:"bytes,7,opt,name=explicit_annotation,json=explicitAnnotation,proto3" json:"explicit_annotation,omitempty"`
	// Speech transcription.
	SpeechTranscriptions []*SpeechTranscription `protobuf:"bytes,11,rep,name=speech_transcriptions,json=speechTranscriptions,proto3" json:"speech_transcriptions,omitempty"`
	// If set, indicates an error. Note that for a single `AnnotateVideoRequest`
	// some videos may succeed and some may fail.
	Error                *status.Status `protobuf:"bytes,9,opt,name=error,proto3" json:"error,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *VideoAnnotationResults) Reset()         { *m = VideoAnnotationResults{} }
func (m *VideoAnnotationResults) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationResults) ProtoMessage()    {}
func (*VideoAnnotationResults) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{17}
}
func (m *VideoAnnotationResults) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationResults.Unmarshal(m, b)
}
func (m *VideoAnnotationResults) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationResults.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationResults) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationResults.Merge(dst, src)
}
func (m *VideoAnnotationResults) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationResults.Size(m)
}
func (m *VideoAnnotationResults) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationResults.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationResults proto.InternalMessageInfo

func (m *VideoAnnotationResults) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationResults) GetSegmentLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.SegmentLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.ShotLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFrameLabelAnnotations() []*LabelAnnotation {
	if m != nil {
		return m.FrameLabelAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetFaceAnnotations() []*FaceAnnotation {
	if m != nil {
		return m.FaceAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetShotAnnotations() []*VideoSegment {
	if m != nil {
		return m.ShotAnnotations
	}
	return nil
}

func (m *VideoAnnotationResults) GetExplicitAnnotation() *ExplicitContentAnnotation {
	if m != nil {
		return m.ExplicitAnnotation
	}
	return nil
}

func (m *VideoAnnotationResults) GetSpeechTranscriptions() []*SpeechTranscription {
	if m != nil {
		return m.SpeechTranscriptions
	}
	return nil
}

func (m *VideoAnnotationResults) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

// Video annotation response. Included in the `response`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoResponse struct {
	// Annotation results for all videos specified in `AnnotateVideoRequest`.
	AnnotationResults    []*VideoAnnotationResults `protobuf:"bytes,1,rep,name=annotation_results,json=annotationResults,proto3" json:"annotation_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *AnnotateVideoResponse) Reset()         { *m = AnnotateVideoResponse{} }
func (m *AnnotateVideoResponse) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoResponse) ProtoMessage()    {}
func (*AnnotateVideoResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{18}
}
func (m *AnnotateVideoResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoResponse.Unmarshal(m, b)
}
func (m *AnnotateVideoResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoResponse.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoResponse.Merge(dst, src)
}
func (m *AnnotateVideoResponse) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoResponse.Size(m)
}
func (m *AnnotateVideoResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoResponse proto.InternalMessageInfo

func (m *AnnotateVideoResponse) GetAnnotationResults() []*VideoAnnotationResults {
	if m != nil {
		return m.AnnotationResults
	}
	return nil
}

// Annotation progress for a single video.
type VideoAnnotationProgress struct {
	// Video file location in
	// [Google Cloud Storage](https://cloud.google.com/storage/).
	InputUri string `protobuf:"bytes,1,opt,name=input_uri,json=inputUri,proto3" json:"input_uri,omitempty"`
	// Approximate percentage processed thus far. Guaranteed to be
	// 100 when fully processed.
	ProgressPercent int32 `protobuf:"varint,2,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent update.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *VideoAnnotationProgress) Reset()         { *m = VideoAnnotationProgress{} }
func (m *VideoAnnotationProgress) String() string { return proto.CompactTextString(m) }
func (*VideoAnnotationProgress) ProtoMessage()    {}
func (*VideoAnnotationProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{19}
}
func (m *VideoAnnotationProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_VideoAnnotationProgress.Unmarshal(m, b)
}
func (m *VideoAnnotationProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_VideoAnnotationProgress.Marshal(b, m, deterministic)
}
func (dst *VideoAnnotationProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_VideoAnnotationProgress.Merge(dst, src)
}
func (m *VideoAnnotationProgress) XXX_Size() int {
	return xxx_messageInfo_VideoAnnotationProgress.Size(m)
}
func (m *VideoAnnotationProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_VideoAnnotationProgress.DiscardUnknown(m)
}

var xxx_messageInfo_VideoAnnotationProgress proto.InternalMessageInfo

func (m *VideoAnnotationProgress) GetInputUri() string {
	if m != nil {
		return m.InputUri
	}
	return ""
}

func (m *VideoAnnotationProgress) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *VideoAnnotationProgress) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *VideoAnnotationProgress) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// Video annotation progress. Included in the `metadata`
// field of the `Operation` returned by the `GetOperation`
// call of the `google::longrunning::Operations` service.
type AnnotateVideoProgress struct {
	// Progress metadata for all videos specified in `AnnotateVideoRequest`.
	AnnotationProgress   []*VideoAnnotationProgress `protobuf:"bytes,1,rep,name=annotation_progress,json=annotationProgress,proto3" json:"annotation_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *AnnotateVideoProgress) Reset()         { *m = AnnotateVideoProgress{} }
func (m *AnnotateVideoProgress) String() string { return proto.CompactTextString(m) }
func (*AnnotateVideoProgress) ProtoMessage()    {}
func (*AnnotateVideoProgress) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{20}
}
func (m *AnnotateVideoProgress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AnnotateVideoProgress.Unmarshal(m, b)
}
func (m *AnnotateVideoProgress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AnnotateVideoProgress.Marshal(b, m, deterministic)
}
func (dst *AnnotateVideoProgress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AnnotateVideoProgress.Merge(dst, src)
}
func (m *AnnotateVideoProgress) XXX_Size() int {
	return xxx_messageInfo_AnnotateVideoProgress.Size(m)
}
func (m *AnnotateVideoProgress) XXX_DiscardUnknown() {
	xxx_messageInfo_AnnotateVideoProgress.DiscardUnknown(m)
}

var xxx_messageInfo_AnnotateVideoProgress proto.InternalMessageInfo

func (m *AnnotateVideoProgress) GetAnnotationProgress() []*VideoAnnotationProgress {
	if m != nil {
		return m.AnnotationProgress
	}
	return nil
}

// Config for SPEECH_TRANSCRIPTION.
type SpeechTranscriptionConfig struct {
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](https://cloud.google.com/speech/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,1,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechTranscription`. The server may return fewer than
	// `max_alternatives`. Valid values are `0`-`30`. A value of `0` or `1` will
	// return a maximum of one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,2,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	FilterProfanity bool `protobuf:"varint,3,opt,name=filter_profanity,json=filterProfanity,proto3" json:"filter_profanity,omitempty"`
	// *Optional* A means to provide context to assist the speech recognition.
	SpeechContexts []*SpeechContext `protobuf:"bytes,4,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// *Optional* If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all. The default 'false' value
	// does not add punctuation to result hypotheses. NOTE: "This is currently
	// offered as an experimental service, complimentary to all users. In the
	// future this may be exclusively available as a premium feature."
	EnableAutomaticPunctuation bool `protobuf:"varint,5,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// *Optional* For file formats, such as MXF or MKV, supporting multiple audio
	// tracks, specify up to two tracks. Default: track 0.
	AudioTracks []int32 `protobuf:"varint,6,rep,packed,name=audio_tracks,json=audioTracks,proto3" json:"audio_tracks,omitempty"`
	// *Optional* If 'true', enables speaker detection for each recognized word in
	// the top alternative of the recognition result using a speaker_tag provided
	// in the WordInfo.
	// Note: When this is true, we send all the words from the beginning of the
	// audio for the top alternative in every consecutive responses.
	// This is done in order to improve our speaker tags as our models learn to
	// identify the speakers in the conversation over time.
	EnableSpeakerDiarization bool `protobuf:"varint,7,opt,name=enable_speaker_diarization,json=enableSpeakerDiarization,proto3" json:"enable_speaker_diarization,omitempty"`
	// *Optional*
	// If set, specifies the estimated number of speakers in the conversation.
	// If not set, defaults to '2'.
	// Ignored unless enable_speaker_diarization is set to true.
	DiarizationSpeakerCount int32 `protobuf:"varint,8,opt,name=diarization_speaker_count,json=diarizationSpeakerCount,proto3" json:"diarization_speaker_count,omitempty"`
	// *Optional* If `true`, the top result includes a list of words and the
	// confidence for those words. If `false`, no word-level confidence
	// information is returned. The default is `false`.
	EnableWordConfidence bool     `protobuf:"varint,9,opt,name=enable_word_confidence,json=enableWordConfidence,proto3" json:"enable_word_confidence,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscriptionConfig) Reset()         { *m = SpeechTranscriptionConfig{} }
func (m *SpeechTranscriptionConfig) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscriptionConfig) ProtoMessage()    {}
func (*SpeechTranscriptionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{21}
}
func (m *SpeechTranscriptionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscriptionConfig.Unmarshal(m, b)
}
func (m *SpeechTranscriptionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscriptionConfig.Marshal(b, m, deterministic)
}
func (dst *SpeechTranscriptionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscriptionConfig.Merge(dst, src)
}
func (m *SpeechTranscriptionConfig) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscriptionConfig.Size(m)
}
func (m *SpeechTranscriptionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscriptionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscriptionConfig proto.InternalMessageInfo

func (m *SpeechTranscriptionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *SpeechTranscriptionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetFilterProfanity() bool {
	if m != nil {
		return m.FilterProfanity
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetAudioTracks() []int32 {
	if m != nil {
		return m.AudioTracks
	}
	return nil
}

func (m *SpeechTranscriptionConfig) GetEnableSpeakerDiarization() bool {
	if m != nil {
		return m.EnableSpeakerDiarization
	}
	return false
}

func (m *SpeechTranscriptionConfig) GetDiarizationSpeakerCount() int32 {
	if m != nil {
		return m.DiarizationSpeakerCount
	}
	return 0
}

func (m *SpeechTranscriptionConfig) GetEnableWordConfidence() bool {
	if m != nil {
		return m.EnableWordConfidence
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](https://cloud.google.com/speech/limits#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{22}
}
func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (dst *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(dst, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechTranscription struct {
	// May contain one or more recognition hypotheses (up to the maximum specified
	// in `max_alternatives`).  These alternatives are ordered in terms of
	// accuracy, with the top (first) alternative being the most probable, as
	// ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. The
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag of the
	// language in this result. This language code was detected to have the most
	// likelihood of being spoken in the audio.
	LanguageCode         string   `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechTranscription) Reset()         { *m = SpeechTranscription{} }
func (m *SpeechTranscription) String() string { return proto.CompactTextString(m) }
func (*SpeechTranscription) ProtoMessage()    {}
func (*SpeechTranscription) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{23}
}
func (m *SpeechTranscription) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechTranscription.Unmarshal(m, b)
}
func (m *SpeechTranscription) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechTranscription.Marshal(b, m, deterministic)
}
func (dst *SpeechTranscription) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechTranscription.Merge(dst, src)
}
func (m *SpeechTranscription) XXX_Size() int {
	return xxx_messageInfo_SpeechTranscription.Size(m)
}
func (m *SpeechTranscription) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechTranscription.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechTranscription proto.InternalMessageInfo

func (m *SpeechTranscription) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *SpeechTranscription) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is typically provided only for the top hypothesis, and
	// only for `is_final=true` results. Clients should not rely on the
	// `confidence` field as it is not guaranteed to be accurate or consistent.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// A list of word-specific information for each recognized word.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{24}
}
func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (dst *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(dst, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words. Word information is only
// included in the response when certain request parameters are set, such
// as `enable_word_time_offsets`.
type WordInfo struct {
	// Time offset relative to the beginning of the audio, and
	// corresponding to the start of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time offset relative to the beginning of the audio, and
	// corresponding to the end of the spoken word. This field is only set if
	// `enable_word_time_offsets=true` and only in the top hypothesis. This is an
	// experimental feature and the accuracy of the time offset can vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The word corresponding to this set of information.
	Word string `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,4,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A distinct integer value is assigned for every speaker within
	// the audio. This field specifies which one of those speakers was detected to
	// have spoken this word. Value ranges from 1 up to diarization_speaker_count,
	// and is only set if speaker diarization is enabled.
	SpeakerTag           int32    `protobuf:"varint,5,opt,name=speaker_tag,json=speakerTag,proto3" json:"speaker_tag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_video_intelligence_0a28b09d859e5ccc, []int{25}
}
func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (dst *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(dst, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func (m *WordInfo) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *WordInfo) GetSpeakerTag() int32 {
	if m != nil {
		return m.SpeakerTag
	}
	return 0
}

func init() {
	proto.RegisterType((*AnnotateVideoRequest)(nil), "google.cloud.videointelligence.v1.AnnotateVideoRequest")
	proto.RegisterType((*VideoContext)(nil), "google.cloud.videointelligence.v1.VideoContext")
	proto.RegisterType((*LabelDetectionConfig)(nil), "google.cloud.videointelligence.v1.LabelDetectionConfig")
	proto.RegisterType((*ShotChangeDetectionConfig)(nil), "google.cloud.videointelligence.v1.ShotChangeDetectionConfig")
	proto.RegisterType((*ExplicitContentDetectionConfig)(nil), "google.cloud.videointelligence.v1.ExplicitContentDetectionConfig")
	proto.RegisterType((*FaceDetectionConfig)(nil), "google.cloud.videointelligence.v1.FaceDetectionConfig")
	proto.RegisterType((*VideoSegment)(nil), "google.cloud.videointelligence.v1.VideoSegment")
	proto.RegisterType((*LabelSegment)(nil), "google.cloud.videointelligence.v1.LabelSegment")
	proto.RegisterType((*LabelFrame)(nil), "google.cloud.videointelligence.v1.LabelFrame")
	proto.RegisterType((*Entity)(nil), "google.cloud.videointelligence.v1.Entity")
	proto.RegisterType((*LabelAnnotation)(nil), "google.cloud.videointelligence.v1.LabelAnnotation")
	proto.RegisterType((*ExplicitContentFrame)(nil), "google.cloud.videointelligence.v1.ExplicitContentFrame")
	proto.RegisterType((*ExplicitContentAnnotation)(nil), "google.cloud.videointelligence.v1.ExplicitContentAnnotation")
	proto.RegisterType((*NormalizedBoundingBox)(nil), "google.cloud.videointelligence.v1.NormalizedBoundingBox")
	proto.RegisterType((*FaceSegment)(nil), "google.cloud.videointelligence.v1.FaceSegment")
	proto.RegisterType((*FaceFrame)(nil), "google.cloud.videointelligence.v1.FaceFrame")
	proto.RegisterType((*FaceAnnotation)(nil), "google.cloud.videointelligence.v1.FaceAnnotation")
	proto.RegisterType((*VideoAnnotationResults)(nil), "google.cloud.videointelligence.v1.VideoAnnotationResults")
	proto.RegisterType((*AnnotateVideoResponse)(nil), "google.cloud.videointelligence.v1.AnnotateVideoResponse")
	proto.RegisterType((*VideoAnnotationProgress)(nil), "google.cloud.videointelligence.v1.VideoAnnotationProgress")
	proto.RegisterType((*AnnotateVideoProgress)(nil), "google.cloud.videointelligence.v1.AnnotateVideoProgress")
	proto.RegisterType((*SpeechTranscriptionConfig)(nil), "google.cloud.videointelligence.v1.SpeechTranscriptionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.videointelligence.v1.SpeechContext")
	proto.RegisterType((*SpeechTranscription)(nil), "google.cloud.videointelligence.v1.SpeechTranscription")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.videointelligence.v1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.videointelligence.v1.WordInfo")
	proto.RegisterEnum("google.cloud.videointelligence.v1.Feature", Feature_name, Feature_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.LabelDetectionMode", LabelDetectionMode_name, LabelDetectionMode_value)
	proto.RegisterEnum("google.cloud.videointelligence.v1.Likelihood", Likelihood_name, Likelihood_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// VideoIntelligenceServiceClient is the client API for VideoIntelligenceService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VideoIntelligenceServiceClient interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type videoIntelligenceServiceClient struct {
	cc *grpc.ClientConn
}

func NewVideoIntelligenceServiceClient(cc *grpc.ClientConn) VideoIntelligenceServiceClient {
	return &videoIntelligenceServiceClient{cc}
}

func (c *videoIntelligenceServiceClient) AnnotateVideo(ctx context.Context, in *AnnotateVideoRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoIntelligenceServiceServer is the server API for VideoIntelligenceService service.
type VideoIntelligenceServiceServer interface {
	// Performs asynchronous video annotation. Progress and results can be
	// retrieved through the `google.longrunning.Operations` interface.
	// `Operation.metadata` contains `AnnotateVideoProgress` (progress).
	// `Operation.response` contains `AnnotateVideoResponse` (results).
	AnnotateVideo(context.Context, *AnnotateVideoRequest) (*longrunning.Operation, error)
}

func RegisterVideoIntelligenceServiceServer(s *grpc.Server, srv VideoIntelligenceServiceServer) {
	s.RegisterService(&_VideoIntelligenceService_serviceDesc, srv)
}

func _VideoIntelligenceService_AnnotateVideo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AnnotateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.videointelligence.v1.VideoIntelligenceService/AnnotateVideo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoIntelligenceServiceServer).AnnotateVideo(ctx, req.(*AnnotateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VideoIntelligenceService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.videointelligence.v1.VideoIntelligenceService",
	HandlerType: (*VideoIntelligenceServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AnnotateVideo",
			Handler:    _VideoIntelligenceService_AnnotateVideo_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/videointelligence/v1/video_intelligence.proto",
}

func init() {
	proto.RegisterFile("google/cloud/videointelligence/v1/video_intelligence.proto", fileDescriptor_video_intelligence_0a28b09d859e5ccc)
}

var fileDescriptor_video_intelligence_0a28b09d859e5ccc = []byte{
	// 2132 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x59, 0xcd, 0x6f, 0x23, 0x49,
	0x15, 0xa7, 0x9d, 0xd8, 0x13, 0x3f, 0x27, 0xb1, 0xa7, 0xf2, 0xe5, 0x64, 0x67, 0x32, 0x99, 0x5e,
	0x90, 0x66, 0x66, 0xc1, 0x21, 0x61, 0x99, 0xdd, 0xcd, 0xae, 0x04, 0x8e, 0xd3, 0xd9, 0x31, 0x9b,
	0x89, 0xad, 0xb2, 0x67, 0xd8, 0x59, 0x8d, 0xd4, 0xea, 0x74, 0x97, 0xdb, 0xbd, 0x69, 0x77, 0x35,
	0xfd, 0x11, 0x66, 0x56, 0x70, 0x00, 0x21, 0xb8, 0x70, 0xe3, 0xc2, 0x0d, 0x90, 0x38, 0xf1, 0x07,
	0x20, 0x24, 0x84, 0xb4, 0xda, 0x23, 0x17, 0x0e, 0x9c, 0xb8, 0xef, 0x1f, 0x82, 0xea, 0xa3, 0xed,
	0xf6, 0x47, 0x92, 0xce, 0xc0, 0xcd, 0xf5, 0x3e, 0x7e, 0xef, 0xd5, 0xab, 0x57, 0xaf, 0xde, 0x6b,
	0xc3, 0x81, 0x4d, 0xa9, 0xed, 0x92, 0x5d, 0xd3, 0xa5, 0xb1, 0xb5, 0x7b, 0xe1, 0x58, 0x84, 0x3a,
	0x5e, 0x44, 0x5c, 0xd7, 0xb1, 0x89, 0x67, 0x92, 0xdd, 0x8b, 0x3d, 0x41, 0xd4, 0xd3, 0xd4, 0x9a,
	0x1f, 0xd0, 0x88, 0xa2, 0xfb, 0x42, 0xb7, 0xc6, 0x75, 0x6b, 0x53, 0xba, 0xb5, 0x8b, 0xbd, 0xad,
	0x3b, 0x12, 0xde, 0xf0, 0x9d, 0x5d, 0xc3, 0xf3, 0x68, 0x64, 0x44, 0x0e, 0xf5, 0x42, 0x01, 0xb0,
	0xf5, 0xb6, 0xe4, 0xba, 0xd4, 0xb3, 0x83, 0xd8, 0xf3, 0x1c, 0xcf, 0xde, 0xa5, 0x3e, 0x09, 0xc6,
	0x84, 0xb6, 0xa5, 0x10, 0x5f, 0x9d, 0xc5, 0xbd, 0x5d, 0x2b, 0x16, 0x02, 0x92, 0x7f, 0x6f, 0x92,
	0x1f, 0x39, 0x03, 0x12, 0x46, 0xc6, 0xc0, 0x97, 0x02, 0x1b, 0x52, 0x20, 0xf0, 0xcd, 0xdd, 0x30,
	0x32, 0xa2, 0x58, 0x22, 0xab, 0x7f, 0xcd, 0xc1, 0x6a, 0x5d, 0x38, 0x45, 0x9e, 0x33, 0xef, 0x31,
	0xf9, 0x49, 0x4c, 0xc2, 0x08, 0xbd, 0x05, 0x45, 0xc7, 0xf3, 0xe3, 0x48, 0x8f, 0x03, 0xa7, 0xaa,
	0xec, 0x28, 0x0f, 0x8a, 0x78, 0x81, 0x13, 0x9e, 0x05, 0x0e, 0x7a, 0x1b, 0x96, 0x04, 0xd3, 0xa4,
	0x5e, 0x44, 0xbc, 0xa8, 0x5a, 0xd8, 0x51, 0x1e, 0x2c, 0xe2, 0x45, 0x4e, 0x6c, 0x08, 0x1a, 0x3a,
	0x86, 0x85, 0x1e, 0x31, 0xa2, 0x38, 0x20, 0x61, 0x35, 0xb7, 0x33, 0xf7, 0x60, 0x79, 0xff, 0x51,
	0xed, 0xda, 0x68, 0xd5, 0x8e, 0x85, 0x0a, 0x1e, 0xea, 0xa2, 0x2e, 0x2c, 0x89, 0xf0, 0x73, 0x63,
	0xaf, 0xa2, 0xea, 0xdc, 0x8e, 0xf2, 0xa0, 0xb4, 0xbf, 0x9b, 0x01, 0x8c, 0xef, 0xa8, 0x21, 0xd4,
	0xf0, 0xe2, 0x45, 0x6a, 0x85, 0xee, 0x02, 0xd0, 0x38, 0x4a, 0x36, 0x38, 0xcf, 0x37, 0x58, 0x14,
	0x14, 0xb6, 0xc3, 0x7b, 0x50, 0x72, 0xa9, 0xc9, 0x63, 0xac, 0x3b, 0x56, 0x35, 0xcf, 0xf9, 0x90,
	0x90, 0x9a, 0x96, 0xfa, 0x55, 0x1e, 0x16, 0xd3, 0xf0, 0xe8, 0x13, 0x58, 0x08, 0x89, 0x3d, 0x20,
	0x5e, 0x14, 0x56, 0x95, 0x9d, 0xb9, 0x9b, 0x78, 0xd8, 0x11, 0x7a, 0x78, 0x08, 0x80, 0x06, 0xb0,
	0xee, 0x1a, 0x67, 0xc4, 0xd5, 0x2d, 0x12, 0x11, 0x93, 0x7b, 0x61, 0x52, 0xaf, 0xe7, 0xd8, 0xd5,
	0x1c, 0xdf, 0xfc, 0x7b, 0x19, 0xa0, 0x4f, 0x18, 0xc0, 0x51, 0xa2, 0xdf, 0xe0, 0xea, 0x78, 0xd5,
	0x9d, 0x41, 0x45, 0x3f, 0x87, 0x3b, 0x61, 0x9f, 0x46, 0xba, 0xd9, 0x37, 0x3c, 0x9b, 0x4c, 0x1b,
	0x15, 0x11, 0xff, 0x28, 0x83, 0xd1, 0x4e, 0x9f, 0x46, 0x0d, 0x8e, 0x32, 0x69, 0x79, 0x33, 0xbc,
	0x8c, 0x85, 0x7e, 0xab, 0xc0, 0x7d, 0xf2, 0xca, 0x77, 0x1d, 0xd3, 0x19, 0xa6, 0xd4, 0xb4, 0x13,
	0xf3, 0xdc, 0x89, 0x7a, 0x06, 0x27, 0x34, 0x89, 0x25, 0x33, 0x71, 0xd2, 0x93, 0x6d, 0x72, 0x25,
	0x1f, 0x7d, 0x0e, 0x6b, 0x3d, 0xc3, 0x9c, 0x11, 0x86, 0x3c, 0xf7, 0xe0, 0x71, 0x96, 0x2c, 0x36,
	0xcc, 0xa9, 0x00, 0xac, 0xf4, 0xa6, 0x89, 0xe8, 0x67, 0xf0, 0x56, 0xe8, 0x13, 0x62, 0xf6, 0xf5,
	0x28, 0x30, 0xbc, 0xd0, 0x0c, 0x1c, 0x3f, 0x6d, 0xb1, 0x90, 0x3d, 0xf0, 0x1c, 0xa5, 0x9b, 0x06,
	0x19, 0x06, 0xfe, 0x32, 0x96, 0xfa, 0x95, 0x02, 0xab, 0xb3, 0xd2, 0x04, 0xd9, 0xb0, 0x3a, 0x99,
	0x7f, 0x03, 0x6a, 0x11, 0x5e, 0x08, 0x96, 0xf7, 0xbf, 0x7f, 0xe3, 0xec, 0x7b, 0x4a, 0x2d, 0x82,
	0x91, 0x3b, 0x45, 0x43, 0xef, 0xc0, 0xed, 0x50, 0x14, 0x44, 0x23, 0x78, 0xad, 0x9b, 0xc6, 0x80,
	0x04, 0x06, 0xcf, 0xf1, 0x05, 0x5c, 0x19, 0x31, 0x1a, 0x9c, 0x8e, 0x56, 0x21, 0xcf, 0xbc, 0x70,
	0x79, 0x3e, 0x16, 0xb1, 0x58, 0xa8, 0x7b, 0xb0, 0x79, 0x69, 0xd6, 0x8d, 0x54, 0x94, 0xb4, 0xca,
	0x63, 0xd8, 0xbe, 0x3a, 0x47, 0x2e, 0xd1, 0x33, 0x60, 0x65, 0xc6, 0xc9, 0xce, 0x16, 0x46, 0xef,
	0xc2, 0xba, 0xe3, 0x99, 0x6e, 0x6c, 0x11, 0xfd, 0x8c, 0xc6, 0x9e, 0xe5, 0x78, 0xb6, 0x7e, 0x46,
	0x5f, 0xf1, 0x6a, 0xc8, 0xf6, 0xb7, 0x2a, 0xb9, 0x87, 0x92, 0x79, 0xc8, 0x78, 0xea, 0xef, 0x15,
	0x59, 0x57, 0x64, 0x51, 0x40, 0x1a, 0x8f, 0x50, 0x10, 0xe9, 0xac, 0xa6, 0xeb, 0xb4, 0xd7, 0x0b,
	0x49, 0xc4, 0x0d, 0x95, 0xf6, 0x37, 0x93, 0x73, 0x48, 0xea, 0x7e, 0xed, 0x48, 0xbe, 0x0b, 0xb8,
	0xcc, 0x75, 0xba, 0xce, 0x80, 0xb4, 0xb8, 0x06, 0xaa, 0x43, 0x99, 0x78, 0xd6, 0x18, 0x48, 0xee,
	0x3a, 0x90, 0x25, 0xe2, 0x59, 0x23, 0x08, 0xf5, 0x35, 0x2c, 0xf2, 0x53, 0x4d, 0x3c, 0x6b, 0xc2,
	0x2d, 0x59, 0xb0, 0xa4, 0x3f, 0x37, 0x2e, 0x78, 0x89, 0x3e, 0xda, 0x06, 0xe0, 0x19, 0x6f, 0x31,
	0x31, 0xee, 0x58, 0x0e, 0xa7, 0x28, 0x6a, 0x1f, 0x80, 0x9b, 0x3e, 0x0e, 0x8c, 0x01, 0x41, 0x07,
	0x50, 0xba, 0x51, 0x30, 0x20, 0x1a, 0xc5, 0xe1, 0x3a, 0x4b, 0x2e, 0x14, 0x34, 0x2f, 0x72, 0xa2,
	0xd7, 0xec, 0x05, 0x24, 0xfc, 0x17, 0x7b, 0x00, 0xe4, 0x0b, 0x28, 0x08, 0x4d, 0x0b, 0xed, 0x40,
	0xc9, 0x22, 0xc3, 0xeb, 0xc4, 0x71, 0x8a, 0x38, 0x4d, 0x62, 0x6f, 0xa4, 0x6b, 0x78, 0x76, 0x6c,
	0xd8, 0x44, 0x37, 0xd9, 0xdd, 0x11, 0x49, 0xbb, 0x98, 0x10, 0x1b, 0xd4, 0x22, 0xea, 0x97, 0x39,
	0x28, 0xf3, 0x8d, 0xd5, 0x87, 0x8d, 0x01, 0xaa, 0x43, 0x41, 0x98, 0x91, 0x1b, 0x7b, 0x98, 0xa5,
	0xe2, 0x71, 0x05, 0x2c, 0x15, 0xd1, 0x73, 0xb8, 0x6d, 0x1a, 0x11, 0xb1, 0x69, 0xf0, 0x5a, 0xe7,
	0x24, 0x47, 0xbe, 0xc1, 0x37, 0x42, 0xab, 0x24, 0x18, 0x9a, 0x84, 0x18, 0x7b, 0xe3, 0xe6, 0x32,
	0xbf, 0x71, 0xe9, 0xa4, 0x49, 0xbd, 0x71, 0x1a, 0x14, 0x7a, 0xec, 0x38, 0xc3, 0xea, 0x3c, 0x87,
	0xfa, 0x4e, 0x56, 0x28, 0x9e, 0x04, 0x58, 0x2a, 0xab, 0x7f, 0x53, 0x60, 0x75, 0xe2, 0x32, 0xff,
	0xef, 0x59, 0x62, 0xc1, 0xba, 0x4f, 0x03, 0x8f, 0xda, 0x81, 0xe1, 0xf7, 0x5f, 0xeb, 0xae, 0x73,
	0x4e, 0x5c, 0xa7, 0x4f, 0xa9, 0xc5, 0x4f, 0x7a, 0x39, 0x9b, 0xaf, 0x43, 0x25, 0xbc, 0x96, 0x02,
	0x1b, 0x91, 0x55, 0x17, 0x36, 0x27, 0x3c, 0x4f, 0xa5, 0x41, 0x6b, 0x18, 0x1e, 0xd1, 0x4d, 0xbc,
	0x77, 0xf3, 0x87, 0x6f, 0x3c, 0x50, 0xe7, 0xb0, 0x76, 0x4a, 0x83, 0x81, 0xe1, 0x3a, 0x5f, 0x10,
	0x2b, 0x55, 0x74, 0x10, 0x82, 0x79, 0x97, 0xf4, 0x44, 0x84, 0x72, 0x98, 0xff, 0x46, 0x15, 0x98,
	0x8b, 0xa8, 0x2f, 0xef, 0x07, 0xfb, 0xc9, 0x8a, 0x5c, 0xe0, 0xd8, 0x7d, 0xd1, 0x7e, 0xe5, 0xb0,
	0x58, 0xa0, 0x75, 0x28, 0x9c, 0xd1, 0x28, 0xa2, 0x03, 0xfe, 0x3c, 0xe7, 0xb0, 0x5c, 0xa9, 0x9f,
	0x42, 0x89, 0x55, 0xca, 0xff, 0x7f, 0xa9, 0x50, 0xff, 0xa1, 0x40, 0x91, 0x41, 0x8b, 0x43, 0x8e,
	0x60, 0xd3, 0x1b, 0x6e, 0x6a, 0xb2, 0xce, 0x8a, 0xc0, 0xbd, 0x9f, 0xc1, 0xd4, 0xcc, 0xc0, 0xe0,
	0x0d, 0x6f, 0x16, 0x99, 0x84, 0x93, 0xa9, 0x95, 0xbb, 0x41, 0x6a, 0xa9, 0x5f, 0x2a, 0xb0, 0xcc,
	0xfc, 0x4f, 0x1d, 0xf5, 0x1d, 0x28, 0x46, 0xfd, 0x78, 0x70, 0xe6, 0x19, 0x8e, 0x78, 0x43, 0x16,
	0xf1, 0x88, 0x80, 0x7e, 0x94, 0xba, 0x74, 0xe2, 0x0e, 0xd7, 0x32, 0x76, 0x20, 0xd3, 0x77, 0xee,
	0x68, 0x98, 0x54, 0xe2, 0xfa, 0x7e, 0x3b, 0x23, 0xd2, 0x78, 0x26, 0xfd, 0xbd, 0x00, 0xeb, 0xfc,
	0x70, 0x46, 0x7b, 0xc0, 0x24, 0x8c, 0xdd, 0x28, 0xbc, 0x7a, 0x6c, 0xf0, 0x60, 0x53, 0x7a, 0xa2,
	0x8b, 0xee, 0x22, 0x35, 0x0e, 0xc9, 0xad, 0xed, 0x67, 0x2d, 0x02, 0x29, 0xd3, 0x1b, 0x12, 0x74,
	0x82, 0x1e, 0xa2, 0x3e, 0xac, 0xf3, 0xb6, 0x76, 0xda, 0xd8, 0xdc, 0x1b, 0x1b, 0x5b, 0x65, 0x88,
	0x53, 0x96, 0x3e, 0x87, 0x0d, 0x1e, 0x9b, 0x19, 0xa6, 0xe6, 0xdf, 0xd8, 0xd4, 0x1a, 0x87, 0x9c,
	0xb2, 0xf5, 0x12, 0x2a, 0xbc, 0x3d, 0x4d, 0x1b, 0xc9, 0x73, 0x23, 0x7b, 0x19, 0x4f, 0x33, 0x65,
	0xa3, 0xdc, 0x1b, 0x5b, 0x87, 0xe8, 0x33, 0xa8, 0xf0, 0x98, 0xa5, 0xd1, 0x0b, 0x6f, 0x36, 0xce,
	0x94, 0x19, 0x50, 0x1a, 0x7b, 0x00, 0x2b, 0xc3, 0x36, 0x7f, 0x84, 0x5f, 0xbd, 0x95, 0xb9, 0xc9,
	0xbd, 0xb4, 0x5a, 0x62, 0x94, 0x00, 0xa7, 0xae, 0xd5, 0x39, 0xac, 0xcd, 0xea, 0xad, 0xc3, 0x6a,
	0x89, 0xef, 0xe7, 0xf1, 0x9b, 0x75, 0xd5, 0x78, 0x75, 0x46, 0x3f, 0x1d, 0xa2, 0x07, 0x90, 0x27,
	0x41, 0x40, 0x83, 0x6a, 0x91, 0xef, 0x06, 0x25, 0xe0, 0x81, 0x6f, 0xd6, 0x3a, 0x7c, 0xe2, 0xc6,
	0x42, 0x40, 0xfd, 0x85, 0x02, 0x6b, 0x13, 0x23, 0x77, 0xe8, 0x53, 0x2f, 0x24, 0xa8, 0x0f, 0x68,
	0x14, 0x16, 0x3d, 0x10, 0x57, 0x4a, 0x56, 0xb1, 0x0f, 0xb2, 0x46, 0x7f, 0xea, 0x4e, 0xe2, 0xdb,
	0xc6, 0x24, 0x49, 0xfd, 0x8f, 0x02, 0x1b, 0x13, 0xd2, 0xed, 0x80, 0xda, 0x01, 0x09, 0xaf, 0xb9,
	0xc2, 0x0f, 0xa1, 0xe2, 0x4b, 0x41, 0xdd, 0x27, 0x81, 0xc9, 0x2a, 0x3a, 0x2b, 0x7f, 0x79, 0x5c,
	0x4e, 0xe8, 0x6d, 0x41, 0x46, 0x1f, 0x00, 0x8c, 0x1a, 0x57, 0x39, 0x42, 0x6e, 0x4d, 0xd5, 0xc8,
	0x6e, 0xf2, 0xa5, 0x02, 0x17, 0x87, 0x2d, 0x2b, 0xfa, 0x10, 0x4a, 0xb1, 0x6f, 0x19, 0x11, 0x11,
	0xba, 0xf3, 0xd7, 0xea, 0x82, 0x10, 0x67, 0x04, 0xf5, 0x57, 0x93, 0xf1, 0x1d, 0xee, 0xec, 0x1c,
	0x56, 0x52, 0xf1, 0x4d, 0xfc, 0x95, 0x01, 0x3e, 0xb8, 0x79, 0x80, 0x13, 0x60, 0x9c, 0x3a, 0xb6,
	0x84, 0xa6, 0xfe, 0x7a, 0x1e, 0x36, 0x2f, 0x1d, 0xca, 0xa6, 0xbb, 0x43, 0x65, 0xba, 0x3b, 0x64,
	0xc1, 0x1e, 0x18, 0xaf, 0x74, 0xc3, 0x8d, 0x48, 0xe0, 0x19, 0x91, 0x73, 0x21, 0x67, 0x87, 0x3c,
	0x2e, 0x0f, 0x8c, 0x57, 0xf5, 0x14, 0x99, 0x89, 0xf6, 0x1c, 0x46, 0x60, 0xdb, 0xea, 0x19, 0x1e,
	0x6b, 0x1f, 0xe7, 0xf8, 0x98, 0x51, 0x16, 0xf4, 0x76, 0x42, 0x46, 0x2f, 0xa0, 0x2c, 0xaf, 0x85,
	0xfc, 0xa0, 0x92, 0xd4, 0xa8, 0xef, 0x66, 0xbe, 0x10, 0xc9, 0x27, 0x95, 0xe5, 0x30, 0xbd, 0x0c,
	0xd1, 0x0f, 0xe1, 0x0e, 0xf1, 0x8c, 0x33, 0x97, 0xe8, 0x46, 0x1c, 0xd1, 0x81, 0x11, 0x39, 0xa6,
	0xee, 0xc7, 0x9e, 0x19, 0xc5, 0xe2, 0xa6, 0xe7, 0xb9, 0x47, 0x5b, 0x42, 0xa6, 0x9e, 0x88, 0xb4,
	0x47, 0x12, 0xe8, 0x3e, 0x2c, 0x1a, 0xb1, 0xe5, 0x50, 0x76, 0x65, 0xcd, 0x73, 0x51, 0x7a, 0xf2,
	0xb8, 0xc4, 0x69, 0x5d, 0x4e, 0x42, 0x1f, 0x81, 0x04, 0xd0, 0x43, 0x9f, 0x18, 0xe7, 0x24, 0xd0,
	0x2d, 0xc7, 0x08, 0x9c, 0x2f, 0x46, 0xc5, 0x64, 0x01, 0x57, 0x85, 0x44, 0x47, 0x08, 0x1c, 0x8d,
	0xf8, 0xe8, 0x00, 0x36, 0x53, 0xe2, 0x43, 0x08, 0x93, 0xc6, 0x5e, 0x54, 0x5d, 0xe0, 0xc1, 0xdd,
	0x48, 0x09, 0x48, 0x84, 0x06, 0x63, 0xb3, 0x89, 0x4e, 0x5a, 0xfe, 0x29, 0x0d, 0x2c, 0x3d, 0x35,
	0x47, 0x14, 0xc5, 0x44, 0x27, 0xb8, 0x3f, 0xa6, 0x81, 0xd5, 0x18, 0x4d, 0x14, 0x0f, 0x61, 0x69,
	0x2c, 0x6a, 0xa8, 0x0a, 0xb7, 0xfc, 0x7e, 0x60, 0x84, 0xb2, 0x43, 0x29, 0xe2, 0x64, 0xa9, 0xfe,
	0x41, 0x81, 0x95, 0x19, 0x39, 0x83, 0x4c, 0x58, 0x1c, 0x4b, 0x02, 0x91, 0xb1, 0x3f, 0xc8, 0x7c,
	0x5e, 0x98, 0x98, 0xd4, 0xf6, 0x1c, 0x86, 0x95, 0xca, 0x1a, 0x3c, 0x06, 0x3a, 0x9d, 0x92, 0xb9,
	0x19, 0x03, 0xcb, 0x9f, 0x14, 0xb8, 0x73, 0x15, 0x26, 0x9b, 0xaf, 0x46, 0xd5, 0x56, 0x66, 0x75,
	0x8a, 0x72, 0xdd, 0xfc, 0x85, 0xea, 0x90, 0x67, 0xc1, 0x4d, 0x9e, 0xe8, 0x77, 0x32, 0xec, 0x91,
	0xc5, 0xbb, 0xe9, 0xf5, 0x28, 0x16, 0x9a, 0xea, 0xbf, 0x14, 0x58, 0x48, 0x68, 0xe8, 0xfd, 0xb1,
	0x2a, 0x74, 0xed, 0x10, 0x90, 0x2a, 0x42, 0xef, 0xc2, 0x42, 0x32, 0x31, 0x5f, 0xdf, 0xe1, 0xdd,
	0x92, 0xa3, 0x32, 0x6b, 0xa6, 0x99, 0x17, 0x72, 0xda, 0xe3, 0xbf, 0x27, 0xf6, 0x3c, 0x3f, 0xb5,
	0xe7, 0x7b, 0x50, 0x4a, 0xf2, 0x30, 0x32, 0xc4, 0x67, 0xa6, 0x3c, 0x06, 0x49, 0xea, 0x1a, 0xf6,
	0xa3, 0x3f, 0x2a, 0x70, 0x4b, 0x7e, 0x18, 0x45, 0x1b, 0xb0, 0x72, 0xac, 0xd5, 0xbb, 0xcf, 0xb0,
	0xa6, 0x3f, 0x3b, 0xed, 0xb4, 0xb5, 0x46, 0xf3, 0xb8, 0xa9, 0x1d, 0x55, 0xbe, 0x81, 0x56, 0xa0,
	0x7c, 0x52, 0x3f, 0xd4, 0x4e, 0xf4, 0x23, 0xad, 0xab, 0x35, 0xba, 0xcd, 0xd6, 0x69, 0x45, 0x41,
	0x9b, 0xb0, 0xd6, 0x79, 0xd2, 0xea, 0xea, 0x8d, 0x27, 0xf5, 0xd3, 0x8f, 0xb5, 0x14, 0x2b, 0x87,
	0xb6, 0x61, 0x4b, 0xfb, 0xb4, 0x7d, 0xd2, 0x6c, 0x34, 0xbb, 0x7a, 0xa3, 0x75, 0xda, 0xd5, 0x4e,
	0xbb, 0x29, 0xfe, 0x1c, 0x42, 0xb0, 0x7c, 0x5c, 0x6f, 0xa4, 0x75, 0xe6, 0x51, 0x15, 0x56, 0x3b,
	0x6d, 0x4d, 0x6b, 0x3c, 0xd1, 0xbb, 0xb8, 0x7e, 0xda, 0x69, 0xe0, 0x66, 0x9b, 0x73, 0x0a, 0x8f,
	0x02, 0x40, 0xd3, 0x9f, 0x7c, 0xd0, 0x37, 0x61, 0x67, 0xc2, 0x27, 0xfd, 0x69, 0xeb, 0x68, 0xd2,
	0xf3, 0x25, 0x28, 0x72, 0x27, 0x19, 0xab, 0xa2, 0xa0, 0x65, 0x80, 0x63, 0x5c, 0x7f, 0xaa, 0x89,
	0x75, 0x8e, 0xed, 0x98, 0xb3, 0xeb, 0xa7, 0x47, 0x7a, 0x8a, 0x31, 0xf7, 0x28, 0x02, 0x18, 0x4d,
	0x53, 0x68, 0x0b, 0xd6, 0x4f, 0x9a, 0x9f, 0x68, 0x27, 0xcd, 0x27, 0xad, 0xd6, 0xd1, 0x84, 0x85,
	0xdb, 0xb0, 0xf4, 0x5c, 0xc3, 0x2f, 0xf4, 0x67, 0xa7, 0x5c, 0xe4, 0x45, 0x45, 0x41, 0x8b, 0xb0,
	0x30, 0x5c, 0xe5, 0xd8, 0xaa, 0xdd, 0xea, 0x74, 0x9a, 0x87, 0x27, 0x5a, 0x65, 0x0e, 0x01, 0x14,
	0x24, 0x67, 0x1e, 0x95, 0xa1, 0xc4, 0x55, 0x25, 0x21, 0xbf, 0xff, 0x67, 0x05, 0xaa, 0xfc, 0x21,
	0x68, 0xa6, 0xf2, 0xb0, 0x43, 0x82, 0x0b, 0xc7, 0x24, 0xe8, 0x37, 0x0a, 0x2c, 0x8d, 0x3d, 0x3e,
	0x28, 0xcb, 0xdc, 0x36, 0xeb, 0x0b, 0xfc, 0xd6, 0xdd, 0x44, 0x31, 0xf5, 0xd7, 0x40, 0xad, 0x95,
	0xfc, 0x35, 0xa0, 0x6e, 0xff, 0xf2, 0xdf, 0x5f, 0xff, 0x2e, 0x57, 0x55, 0x57, 0x86, 0xff, 0x4f,
	0x84, 0x07, 0xf2, 0x19, 0x22, 0x07, 0xca, 0xa3, 0xc3, 0xaf, 0x15, 0xf8, 0x96, 0x49, 0x07, 0xd7,
	0x5b, 0x3f, 0xbc, 0x7b, 0xd9, 0x6e, 0xda, 0x2c, 0xcd, 0xdb, 0xca, 0x67, 0x58, 0x62, 0xd8, 0x94,
	0xd5, 0x82, 0x1a, 0x0d, 0xec, 0x5d, 0x9b, 0x78, 0xfc, 0x12, 0xec, 0x0a, 0x96, 0xe1, 0x3b, 0xe1,
	0x15, 0xff, 0x9f, 0x7c, 0x38, 0x45, 0xfc, 0x4b, 0xee, 0xfe, 0xc7, 0x02, 0xb4, 0xc1, 0x1d, 0x9b,
	0x72, 0xa1, 0xf6, 0x7c, 0xef, 0x9f, 0x89, 0xcc, 0x4b, 0x2e, 0xf3, 0x72, 0x4a, 0xe6, 0xe5, 0xf3,
	0xbd, 0xb3, 0x02, 0x77, 0xe3, 0x7b, 0xff, 0x0d, 0x00, 0x00, 0xff, 0xff, 0x97, 0xe1, 0xdb, 0x00,
	0xc5, 0x19, 0x00, 0x00,
}
