/*
 * Decompiled with CFR 0.152.
 */
package gnu.bioinformatics.jaligner.algorithms;

import gnu.bioinformatics.jaligner.util.Alignment;

public class SmithWaterman {
    private static final byte DIRECTION_DIAGONAL = 0;
    private static final byte DIRECTION_LEFT = 1;
    private static final byte DIRECTION_UP = 2;
    private float score = Float.NEGATIVE_INFINITY;
    private int startTracebackRow;
    private int startTracebackCol;

    private SmithWaterman() {
    }

    public static Alignment align(char[] sequence1, char[] sequence2, float[][] matrix, float open, float extend) {
        System.out.println("Aligning with Smith-Waterman (" + sequence1.length + " by " + sequence2.length + ") ...");
        System.out.println("$Revision: 1.20 $");
        long start = System.currentTimeMillis();
        SmithWaterman instance = new SmithWaterman();
        byte[] pointers = instance.construct(sequence1, sequence2, matrix, open, extend);
        Alignment alignment = instance.traceback(sequence1, sequence2, matrix, pointers);
        long end = System.currentTimeMillis();
        System.out.println("Finished aligning with Smith-Waterman in " + (end - start) + " milliseconds");
        return alignment;
    }

    private byte[] construct(char[] sequence1, char[] sequence2, float[][] matrix, float open, float extend) {
        int m = sequence1.length + 1;
        int n = sequence2.length + 1;
        float[] similarity = new float[n];
        float[] vertical = new float[n];
        float[] horizontal = new float[n];
        int currentTracebackRow = 0;
        int currentTracebackCol = 0;
        float currentScore = Float.NEGATIVE_INFINITY;
        horizontal[0] = 0.0f;
        vertical[0] = 0.0f;
        similarity[0] = 0.0f;
        byte[] pointers = new byte[m * n];
        float diagonal = 0.0f;
        int i = 1;
        int row = n;
        while (i < m) {
            int j = 1;
            while (j < n) {
                float s;
                float a = diagonal + matrix[sequence1[i - 1]][sequence2[j - 1]];
                float o = similarity[j] - open;
                float e = vertical[j] - extend;
                vertical[j] = o > e ? o : e;
                float b = vertical[j];
                o = similarity[j - 1] - open;
                e = horizontal[j - 1] - extend;
                float f = o > e ? o : e;
                horizontal[j - 1] = f;
                float c = f;
                if (a > b) {
                    if (a > c) {
                        s = a;
                        pointers[row + j] = 0;
                    } else {
                        s = c;
                        pointers[row + j] = 1;
                    }
                } else if (c > b) {
                    s = c;
                    pointers[row + j] = 1;
                } else {
                    s = b;
                    pointers[row + j] = 2;
                }
                diagonal = similarity[j];
                float f2 = similarity[j] = s > 0.0f ? s : 0.0f;
                if (s > currentScore) {
                    currentScore = s;
                    currentTracebackRow = i;
                    currentTracebackCol = j;
                }
                ++j;
            }
            ++i;
            row += n;
        }
        this.score = currentScore;
        this.startTracebackRow = currentTracebackRow;
        this.startTracebackCol = currentTracebackCol;
        return pointers;
    }

    private Alignment traceback(char[] sequence1, char[] sequence2, float[][] matrix, byte[] pointers) {
        int maxlen = sequence1.length + sequence2.length;
        char[] reversedSequenceA = new char[maxlen];
        char[] reversedSequenceB = new char[maxlen];
        char[] reversedMarkup = new char[maxlen];
        int len1 = 0;
        int len2 = 0;
        int len3 = 0;
        int identity = 0;
        int similarity = 0;
        int gaps = 0;
        int currentRow = this.startTracebackRow;
        int currentCol = this.startTracebackCol;
        int n = sequence2.length + 1;
        int row = currentRow * n;
        while (currentRow != 0 && currentCol != 0) {
            switch (pointers[row + currentCol]) {
                case 2: {
                    reversedSequenceA[len1++] = sequence1[currentRow - 1];
                    reversedSequenceB[len2++] = 45;
                    reversedMarkup[len3++] = 32;
                    ++gaps;
                    --currentRow;
                    row -= n;
                    break;
                }
                case 0: {
                    char c1 = sequence1[currentRow - 1];
                    char c2 = sequence2[currentCol - 1];
                    reversedSequenceA[len1++] = c1;
                    reversedSequenceB[len2++] = c2;
                    if (c1 == c2) {
                        reversedMarkup[len3++] = 124;
                        ++identity;
                        ++similarity;
                    } else if (matrix[c1][c2] > 0.0f) {
                        reversedMarkup[len3++] = 58;
                        ++similarity;
                    } else {
                        reversedMarkup[len3++] = 46;
                    }
                    --currentRow;
                    --currentCol;
                    row -= n;
                    break;
                }
                case 1: {
                    reversedSequenceA[len1++] = 45;
                    reversedSequenceB[len2++] = sequence2[currentCol - 1];
                    reversedMarkup[len3++] = 32;
                    ++gaps;
                    --currentCol;
                }
            }
        }
        Alignment alignment = new Alignment();
        alignment.setScore(this.score);
        alignment.setIdentity(identity);
        alignment.setSimilarity(similarity);
        alignment.setGaps(gaps);
        alignment.setOffset1(currentRow);
        alignment.setOffset2(currentCol);
        char[] aligned1 = new char[len1];
        char[] aligned2 = new char[len2];
        char[] markup = new char[len3];
        int i = len1 - 1;
        int j = 0;
        while (i >= 0) {
            aligned1[j] = reversedSequenceA[i];
            --i;
            ++j;
        }
        i = len2 - 1;
        j = 0;
        while (i >= 0) {
            aligned2[j] = reversedSequenceB[i];
            --i;
            ++j;
        }
        i = len3 - 1;
        j = 0;
        while (i >= 0) {
            markup[j] = reversedMarkup[i];
            --i;
            ++j;
        }
        alignment.setSequence1(aligned1);
        alignment.setSequence2(aligned2);
        alignment.setMarkup(markup);
        return alignment;
    }
}

