/*
 * Decompiled with CFR 0.152.
 */
package jalview.analysis;

import jalview.datamodel.SequenceI;
import java.util.Hashtable;
import java.util.Vector;

public class AAFrequency {
    public static final String MAXCOUNT = "C";
    public static final String MAXRESIDUE = "R";
    public static final String PID_GAPS = "G";
    public static final String PID_NOGAPS = "N";

    public static final Hashtable[] calculate(Vector sequences, int start, int end) {
        SequenceI[] seqs = new SequenceI[sequences.size()];
        int width = 0;
        for (int i = 0; i < sequences.size(); ++i) {
            seqs[i] = (SequenceI)sequences.elementAt(i);
            if (seqs[i].getLength() <= width) continue;
            width = seqs[i].getLength();
        }
        Hashtable[] reply = new Hashtable[width];
        if (end >= width) {
            end = width;
        }
        AAFrequency.calculate(seqs, start, end, reply);
        return reply;
    }

    public static final void calculate(SequenceI[] sequences, int start, int end, Hashtable[] result) {
        int jSize = sequences.length;
        int[] values = new int[255];
        for (int i = start; i < end; ++i) {
            Hashtable<String, Object> residueHash = new Hashtable<String, Object>();
            int maxCount = 0;
            String maxResidue = "";
            int nongap = 0;
            values = new int[255];
            for (int j = 0; j < jSize; ++j) {
                char[] seq = sequences[j].getSequence();
                if (seq.length > i) {
                    int c = seq[i];
                    if (c == 46 || c == 32) {
                        c = 45;
                    }
                    if (c == 45) {
                        values[45] = values[45] + 1;
                        continue;
                    }
                    if (97 <= c && c <= 122) {
                        c = (char)(c - 32);
                    }
                    ++nongap;
                    int n = c;
                    values[n] = values[n] + 1;
                    continue;
                }
                values[45] = values[45] + 1;
            }
            for (int v = 65; v < 90; ++v) {
                if (values[v] < 2 || values[v] < maxCount) continue;
                if (values[v] > maxCount) {
                    maxResidue = String.valueOf((char)v);
                } else if (values[v] == maxCount) {
                    maxResidue = maxResidue + String.valueOf((char)v);
                }
                maxCount = values[v];
            }
            if (maxResidue.length() == 0) {
                maxResidue = "-";
            }
            residueHash.put(MAXCOUNT, new Integer(maxCount));
            residueHash.put(MAXRESIDUE, maxResidue);
            float percentage = (float)maxCount * 100.0f / (float)jSize;
            residueHash.put(PID_GAPS, new Float(percentage));
            percentage = (float)maxCount * 100.0f / (float)nongap;
            residueHash.put(PID_NOGAPS, new Float(percentage));
            result[i] = residueHash;
        }
    }
}

