package utils

import (
	"fmt"

	"github.com/godbus/dbus"
)

// UserInfo convert dbus userinfo prop
type UserInfo struct {
	UserID      int64
	Region      string
	Token       string
	AccessToken string
	HardwareID  string
}

// FromDBus convert map to struct
func (u *UserInfo) FromDBus(v interface{}) {
	vMap, ok := v.(map[string]dbus.Variant)
	if !ok {
		u.Token = ""
		return
	}

	if v, ok := vMap["Token"]; ok {
		u.Token = fmt.Sprint(v.Value())
	} else {
		u.Token = ""
	}

	if v, ok := vMap["AccessToken"]; ok {
		u.AccessToken = fmt.Sprint(v.Value())
	} else {
		u.AccessToken = ""
	}

	if v, ok := vMap["HardwareID"]; ok {
		u.HardwareID = fmt.Sprint(v.Value())
	} else {
		u.HardwareID = ""
	}

	if v, ok := vMap["UserID"]; ok {
		u.UserID = v.Value().(int64)
	} else {
		u.UserID = -1
	}

	if v, ok := vMap["Region"]; ok {
		u.Region = fmt.Sprint(v.Value())
	} else {
		u.Region = ""
	}
}

// IsValid check userinfo is valid
func (u *UserInfo) IsValid() bool {
	return u.UserID > 0 && u.AccessToken != "" && u.Token != ""
}
