/*
* Copyright (C) 2019 ~ 2020 Uniontech Software Technology Co.,Ltd.
*
* Author:     wangzhixuan <wangzhixuan@uniontech.com>
*
* Maintainer: wangzhixuan <wangzhixuan@uniontech.com>
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation, either version 3 of the License, or
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/
#include "PhoneTreeEBookModel.h"

#include <QFileInfo>
#include <DFileIconProvider>

#include "TrObject.h"

#include "defines.h"

DWIDGET_USE_NAMESPACE

#define CHECK_COL 0 //CheckBox
#define NAME_COL 1 // 文件名
#define EBSIZE_COL 2 // 文件大小
#define EBDATE_COL 3 // 修改时间
#define EBTYPE_COL 4 // 类型

PhoneTreeEBookModel::PhoneTreeEBookModel(QObject *parent)
    : BaseItemModel(parent)
{
    setHorizontalHeaderLabels(QStringList()
                              << "" << TrObject::getInstance()->getTreeHeaderText(Header_Name)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Size)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Time_modified)
                              << TrObject::getInstance()->getTreeHeaderText(Header_Type));
}

void PhoneTreeEBookModel::appendData(const QVariant &data)
{
    auto fi = data.value<QFileInfo>();

    int nRow = this->rowCount();
    QStandardItem *item = nullptr;
    item = new QStandardItem("");
    this->setItem(nRow, CHECK_COL, item);

    item = new QStandardItem(fi.completeBaseName());
    item->setIcon(getFileIcon(fi.suffix(), fi));
    item->setData(data, ROLE_ITEM_DATA);
    this->setItem(nRow, NAME_COL, item);

    item = new QStandardItem(dataSizeToString(quint64(fi.size())));
    item->setData(fi.size(), ROLE_ITEM_SIZE);
    this->setItem(nRow, EBSIZE_COL, item);

    item = new QStandardItem(fi.lastModified().toString("yyyy/MM/dd hh:mm:ss"));
    this->setItem(nRow, EBDATE_COL, item);

    item = new QStandardItem(fi.suffix());
    this->setItem(nRow, EBTYPE_COL, item);
}

void PhoneTreeEBookModel::deleteRowByPath(const QString &, const QString &)
{
}

qint64 PhoneTreeEBookModel::getTotalSize()
{
    int sizeCol = EBSIZE_COL;

    qint64 totalSize = 0;

    for (int i = 0; i < rowCount(); i++) {
        totalSize += item(i, sizeCol)->data(ROLE_ITEM_SIZE).value<qint64>();
    }

    return totalSize;
}
