/*
 * Copyright (C) 2017 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     rekols <rekols@foxmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef THEMEITEMDELEGATE_H
#define THEMEITEMDELEGATE_H

#include <QAbstractItemDelegate>
#include <QPainterPath>

class ThemeItemDelegate : public QAbstractItemDelegate
{
    Q_OBJECT

public:
    ThemeItemDelegate(QObject *parent = nullptr);
    ~ThemeItemDelegate();

protected:
    void paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const;
    QSize sizeHint(const QStyleOptionViewItem &option, const QModelIndex &index) const;

private:
    int m_itemPaddingY = 8;
    int m_itemPaddingX = 20;
    int m_frameRadius = 5;
};

#endif
