/**
 * @copyright 2020-2020 Uniontech Technology Co., Ltd.
 *
 * @file partitioninfo.cpp
 *
 * @brief 分区信息类
 *
 * @date 2020-09-21 14:49
 *
 * Author: liweigang  <liweigang@uniontech.com>
 *
 * Maintainer: liweigang  <liweigang@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

#include "partitioninfo.h"

#include <QDBusArgument>

PartitionInfo::PartitionInfo()
    : m_insideExtended(false)
    , m_busy(false)
    , m_fileSystemReadOnly(false)
{
    //inside_extended = busy = fs_readonly = false;
    m_devicePath = m_uuid = m_name = m_path = m_fileSystemLabel = "";
    m_partitionNumber = m_type = m_status = m_alignment = m_fileSystemType = 0;
    m_sectorStart = m_sectorEnd = m_sectorsUsed = m_sectorsUnused = m_sectorsUnallocated = m_significantThreshold = m_freeSpaceBefore = 0;
    m_flag = m_sectorSize = m_fileSystemBlockSize = 0;
    m_vgFlag = LVM_FLAG_NOT_PV;
    // mountpoints.clear();
}

Sector PartitionInfo::getSectorLength() const
{
    if (m_sectorStart >= 0 && m_sectorEnd >= 0)
        return m_sectorEnd - m_sectorStart + 1;
    else
        return -1;
}

Byte_Value PartitionInfo::getByteLength() const
{
    if (getSectorLength() >= 0)
        return getSectorLength() * m_sectorSize;
    else
        return -1;
}

bool PartitionInfo::operator==(const PartitionInfo &info) const
{
    return m_devicePath == info.m_devicePath && m_partitionNumber == info.m_partitionNumber && m_sectorStart == info.m_sectorStart && m_type == info.m_type;
}

QDBusArgument &operator<<(QDBusArgument &argument, const PartitionInfo &info)
{
    argument.beginStructure();
    argument << info.m_devicePath
             << info.m_partitionNumber
             << info.m_type
             << info.m_status
             << info.m_alignment
             << info.m_fileSystemType
             << info.m_uuid
             << info.m_name
             << info.m_sectorStart
             << info.m_sectorEnd
             << info.m_sectorsUsed
             << info.m_sectorsUnused
             << info.m_sectorsUnallocated
             << info.m_significantThreshold
             << info.m_freeSpaceBefore
             << info.m_sectorSize
             << info.m_fileSystemBlockSize
             << info.m_path
             << info.m_fileSystemLabel
             << info.m_insideExtended
             << info.m_busy
             << info.m_fileSystemReadOnly
             << info.m_flag
             << info.m_mountPoints
             << static_cast<int>(info.m_vgFlag)
             << info.m_vgData
             << info.m_fsLimits.min_size
             << info.m_fsLimits.max_size;

    argument.endStructure();

    return argument;
}

const QDBusArgument &operator>>(const QDBusArgument &argument, PartitionInfo &info)
{
    argument.beginStructure();
    int flag = 0;
    argument >> info.m_devicePath
             >> info.m_partitionNumber
             >> info.m_type
             >> info.m_status
             >> info.m_alignment
             >> info.m_fileSystemType
             >> info.m_uuid
             >> info.m_name
             >> info.m_sectorStart
             >> info.m_sectorEnd
             >> info.m_sectorsUsed
             >> info.m_sectorsUnused
             >> info.m_sectorsUnallocated
             >> info.m_significantThreshold
             >> info.m_freeSpaceBefore
             >> info.m_sectorSize
             >> info.m_fileSystemBlockSize
             >> info.m_path
             >> info.m_fileSystemLabel
             >> info.m_insideExtended
             >> info.m_busy
             >> info.m_fileSystemReadOnly
             >> info.m_flag
             >> info.m_mountPoints
             >> flag
             >> info.m_vgData
             >> info.m_fsLimits.min_size
             >> info.m_fsLimits.max_size;
    info.m_vgFlag = static_cast<LVMFlag>(flag);
    argument.endStructure();

    return argument;
}
