/*
 * Copyright (C) 2011 ~ 2018 Deepin Technology Co., Ltd.
 *
 * Author:     listenerri <listenerri@gmail.com>
 *
 * Maintainer: listenerri <listenerri@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef APPDRAG_H
#define APPDRAG_H

#include "appdragwidget.h"

#include <QDrag>
#include <QWidget>

class AppDrag : public QDrag
{
public:
    explicit AppDrag(QObject *dragSource);
    virtual ~AppDrag();

    void setPixmap(const QPixmap &);
    QPixmap pixmap() const;

    Qt::DropAction start(Qt::DropActions supportedActions = Qt::CopyAction);
    Qt::DropAction exec(Qt::DropActions supportedActions = Qt::MoveAction);
    Qt::DropAction exec(Qt::DropActions supportedActions, Qt::DropAction defaultAction);

    AppDragWidget *appDragWidget();

private:
    void setDragMoveCursor();

private:
    QPointer<AppDragWidget> m_appDragWidget;
};

#endif /* DRAGAPP_H */
