% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBResult.R
\name{dbGetRowCount}
\alias{dbGetRowCount}
\title{The number of rows fetched so far}
\usage{
dbGetRowCount(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbGetRowCount()} returns a scalar number (integer or numeric),
the number of rows fetched so far.
After calling \code{\link[=dbSendQuery]{dbSendQuery()}},
the row count is initially zero.
After a call to \code{\link[=dbFetch]{dbFetch()}} without limit,
the row count matches the total number of rows returned.
Fetching a limited number of rows
increases the number of rows by the number of rows returned,
even if fetching past the end of the result set.
For queries with an empty result set,
zero is returned
even after fetching.
For data manipulation statements issued with
\code{\link[=dbSendStatement]{dbSendStatement()}},
zero is returned before
and after calling \code{dbFetch()}.
Attempting to get the row count for a result set cleared with
\code{\link[=dbClearResult]{dbClearResult()}} gives an error.
}
\description{
Returns the total number of rows actually fetched with calls to \code{\link[=dbFetch]{dbFetch()}}
for this result set.

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbGetRowCount")}
}
\examples{
con <- dbConnect(RSQLite::SQLite(), ":memory:")

dbWriteTable(con, "mtcars", mtcars)
rs <- dbSendQuery(con, "SELECT * FROM mtcars")

dbGetRowCount(rs)
ret1 <- dbFetch(rs, 10)
dbGetRowCount(rs)
ret2 <- dbFetch(rs)
dbGetRowCount(rs)
nrow(ret1) + nrow(ret2)

dbClearResult(rs)
dbDisconnect(con)
}
\seealso{
Other DBIResult generics: \code{\link{DBIResult-class}},
  \code{\link{dbBind}}, \code{\link{dbClearResult}},
  \code{\link{dbColumnInfo}}, \code{\link{dbFetch}},
  \code{\link{dbGetInfo}}, \code{\link{dbGetRowsAffected}},
  \code{\link{dbGetStatement}},
  \code{\link{dbHasCompleted}}, \code{\link{dbIsReadOnly}},
  \code{\link{dbIsValid}}, \code{\link{dbQuoteIdentifier}},
  \code{\link{dbQuoteLiteral}},
  \code{\link{dbQuoteString}},
  \code{\link{dbUnquoteIdentifier}}
}
\concept{DBIResult generics}
