/*----------------------------------------------------------------------------
    ChucK Concurrent, On-the-fly Audio Programming Language
      Compiler and Virtual Machine

    Copyright (c) 2004 Ge Wang and Perry R. Cook.  All rights reserved.
      http://chuck.cs.princeton.edu/
      http://soundlab.cs.princeton.edu/

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
    U.S.A.
-----------------------------------------------------------------------------*/

//-----------------------------------------------------------------------------
// file: util_console.h
// desc: utility for console I/O
//
// author: Spencer Salazar (ssalazar@princeton.edu)
//         Ge Wang (gewang@cs.princeton.edu)
// date: Autumn 2005
//-----------------------------------------------------------------------------
#ifndef __UTIL_CONSOLE_H__
#define __UTIL_CONSOLE_H__

#include "chuck_def.h"

// read a line
char * io_readline( const char * );

// add a line to the history
void io_addhistory( const char * );

// kb hit emulation
t_CKBOOL kb_initscr();
void kb_endwin();
t_CKINT kb_hit();
t_CKINT kb_getch();
t_CKBOOL kb_ready();


#endif
