{ -*- buffer-read-only: t -*-

  Copyright 2015-2018 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in nodes_specification/components/ ,
  - and regenerate include files by running
    nodes_specification/x3d-nodes-to-pascal/x3d-nodes-to-pascal.lpr .

  The documentation for properties should go to x3dnodes_documentation.txt . }

{$ifdef read_interface}

  strict private
    function GetTransparency: Single;
    procedure SetTransparency(const Value: Single);
  public
    procedure SetGroundAngle(const Value: array of Single);
    procedure SetGroundAngle(const Value: TSingleList);
    procedure SetGroundColor(const Value: array of TCastleColorRGB);
    procedure SetGroundColor(const Value: TVector3List);
    procedure SetSkyAngle(const Value: array of Single);
    procedure SetSkyAngle(const Value: TSingleList);
    procedure SetSkyColor(const Value: array of TCastleColorRGB);
    procedure SetSkyColor(const Value: TVector3List);
    property Transparency: Single read GetTransparency write SetTransparency;

{$endif read_interface}

{$ifdef read_implementation}

{ TAbstractBackgroundNode ----------------------------------------------- }

procedure TAbstractBackgroundNode.SetGroundAngle(const Value: array of Single);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstractBackgroundNode.SetGroundAngle(const Value: TSingleList);
begin
  FdGroundAngle.Send(Value);
end;

procedure TAbstractBackgroundNode.SetGroundColor(const Value: array of TCastleColorRGB);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstractBackgroundNode.SetGroundColor(const Value: TVector3List);
begin
  FdGroundColor.Send(Value);
end;

procedure TAbstractBackgroundNode.SetSkyAngle(const Value: array of Single);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstractBackgroundNode.SetSkyAngle(const Value: TSingleList);
begin
  FdSkyAngle.Send(Value);
end;

procedure TAbstractBackgroundNode.SetSkyColor(const Value: array of TCastleColorRGB);
begin
  FdSkyColor.Send(Value);
end;

procedure TAbstractBackgroundNode.SetSkyColor(const Value: TVector3List);
begin
  FdSkyColor.Send(Value);
end;

function TAbstractBackgroundNode.GetTransparency: Single;
begin
  Result := FdTransparency.Value;
end;

procedure TAbstractBackgroundNode.SetTransparency(const Value: Single);
begin
  FdTransparency.Send(Value);
end;

{$endif read_implementation}
