# Copyright 2004,2005 Pierre Martineau <pmartino@users.sourceforge.net>
# This file is part of Bibus, a bibliographic database that can
# work together with OpenOffice.org to generate bibliographic indexes.
#
# Bibus is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Bibus is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Bibus; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA.
#
# generated by wxGlade 0.3.4 on Sat Oct  2 21:17:33 2004

import wx

# begin wxGlade: dependencies
# end wxGlade

class SeparatorsDialog(wx.Dialog):
	def __init__(self, *args, **kwds):
		self.separators = kwds["separators"]
		del kwds["separators"]
		# begin wxGlade: SeparatorsDialog.__init__
		kwds["style"] = wx.DEFAULT_DIALOG_STYLE
		wx.Dialog.__init__(self, *args, **kwds)
		self.label_1 = wx.StaticText(self, -1, _("Separator 1"))
		self.label_2 = wx.StaticText(self, -1, _("Separator 2"))
		self.label_4 = wx.StaticText(self, -1, _("Separator 3"))
		self.sep_1 = wx.TextCtrl(self, -1, "")
		self.sep_2 = wx.TextCtrl(self, -1, "")
		self.sep_3 = wx.TextCtrl(self, -1, "")
		self.static_line_2 = wx.StaticLine(self, -1)
		self.button_1 = wx.Button(self, wx.ID_OK, _("OK"))

		self.__set_properties()
		self.__do_layout()
		# end wxGlade
		wx.EVT_BUTTON(self,wx.ID_OK,self.OnOK)

	def __set_properties(self):
		# begin wxGlade: SeparatorsDialog.__set_properties
		self.SetTitle(_("Separators"))
		self.button_1.SetDefault()
		# end wxGlade
		# set the values of the TextCtrl according to self.separators
		self.sep_1.SetValue(self.separators[0])
		self.sep_2.SetValue(self.separators[1])
		self.sep_3.SetValue(self.separators[2])

	def __do_layout(self):
		# begin wxGlade: SeparatorsDialog.__do_layout
		sizer_24 = wx.BoxSizer(wx.VERTICAL)
		grid_sizer_2 = wx.GridSizer(2, 3, 0, 20)
		grid_sizer_2.Add(self.label_1, 0, 0, 0)
		grid_sizer_2.Add(self.label_2, 0, 0, 0)
		grid_sizer_2.Add(self.label_4, 0, 0, 0)
		grid_sizer_2.Add(self.sep_1, 0, 0, 0)
		grid_sizer_2.Add(self.sep_2, 0, 0, 0)
		grid_sizer_2.Add(self.sep_3, 0, 0, 0)
		sizer_24.Add(grid_sizer_2, 0, wx.EXPAND, 0)
		sizer_24.Add(self.static_line_2, 0, wx.EXPAND, 0)
		sizer_24.Add(self.button_1, 0, wx.ALL|wx.ALIGN_RIGHT, 5)
		self.SetSizer(sizer_24)
		sizer_24.Fit(self)
		self.Layout()
		self.Centre()
		# end wxGlade

	def OnOK(self,evt):
		self.separators = self.sep_1.GetValue(),self.sep_2.GetValue(),self.sep_3.GetValue(),'',''
		self.EndModal(wx.ID_OK)

# end of class SeparatorsDialog


