/*
 * This file was automatically generated by EvoSuite
 * Fri Jan 12 16:53:51 GMT 2018
 */

package uk.ac.sanger.artemis.util;

import org.junit.Test;
import static org.junit.Assert.*;
import static org.evosuite.runtime.EvoAssertions.*;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.PipedReader;
import java.io.Reader;
import org.evosuite.runtime.EvoRunner;
import org.evosuite.runtime.EvoRunnerParameters;
import org.junit.runner.RunWith;
import uk.ac.sanger.artemis.util.LinePushBackReader;

@RunWith(EvoRunner.class) @EvoRunnerParameters(mockJVMNonDeterminism = true, useVFS = true, useVNET = true, resetStaticState = true, separateClassLoader = true, useJEE = true) 
public class LinePushBackReader_ESTest extends LinePushBackReader_ESTest_scaffolding {

  @Test(timeout = 4000)
  public void test00()  throws Throwable  {
      char[] charArray0 = new char[6];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      linePushBackReader0.readLine();
      linePushBackReader0.readLine();
      assertEquals(1, linePushBackReader0.getLineNumber());
  }

  @Test(timeout = 4000)
  public void test01()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      char[] charArray0 = new char[2];
      int int0 = linePushBackReader0.read(charArray0, 0, 0);
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test02()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      try { 
        linePushBackReader0.readLine();
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Pipe not connected
         //
         verifyException("java.io.PipedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test03()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      // Undeclared exception!
      try { 
        linePushBackReader0.read((char[]) null, 3224, 3224);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.BufferedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test04()  throws Throwable  {
      char[] charArray0 = new char[6];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      // Undeclared exception!
      try { 
        linePushBackReader0.read(charArray0, (-439), 0);
        fail("Expecting exception: IndexOutOfBoundsException");
      
      } catch(IndexOutOfBoundsException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.BufferedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test05()  throws Throwable  {
      LinePushBackReader linePushBackReader0 = null;
      try {
        linePushBackReader0 = new LinePushBackReader((Reader) null);
        fail("Expecting exception: NullPointerException");
      
      } catch(NullPointerException e) {
         //
         // no message in exception (getMessage() returned null)
         //
         verifyException("java.io.Reader", e);
      }
  }

  @Test(timeout = 4000)
  public void test06()  throws Throwable  {
      PipedReader pipedReader0 = new PipedReader();
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(pipedReader0);
      linePushBackReader0.pushBack("c''CU[HJq?z&");
      try { 
        linePushBackReader0.pushBack("c''CU[HJq?z&");
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // LinePushBackReader.pushBack () called twice before calling readLine ()
         //
         verifyException("uk.ac.sanger.artemis.util.LinePushBackReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test07()  throws Throwable  {
      char[] charArray0 = new char[0];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      linePushBackReader0.pushBack("");
      String string0 = linePushBackReader0.readLine();
      assertEquals("", string0);
  }

  @Test(timeout = 4000)
  public void test08()  throws Throwable  {
      char[] charArray0 = new char[6];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      linePushBackReader0.readLine();
      int int0 = linePushBackReader0.getLineNumber();
      assertEquals(1, int0);
  }

  @Test(timeout = 4000)
  public void test09()  throws Throwable  {
      char[] charArray0 = new char[6];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      int int0 = linePushBackReader0.getLineNumber();
      assertEquals(0, int0);
  }

  @Test(timeout = 4000)
  public void test10()  throws Throwable  {
      char[] charArray0 = new char[0];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 0, 0);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      linePushBackReader0.close();
      try { 
        linePushBackReader0.read(charArray0, 10, 0);
        fail("Expecting exception: IOException");
      
      } catch(IOException e) {
         //
         // Stream closed
         //
         verifyException("java.io.BufferedReader", e);
      }
  }

  @Test(timeout = 4000)
  public void test11()  throws Throwable  {
      char[] charArray0 = new char[4];
      CharArrayReader charArrayReader0 = new CharArrayReader(charArray0, 2, 2);
      LinePushBackReader linePushBackReader0 = new LinePushBackReader(charArrayReader0);
      int int0 = linePushBackReader0.read(charArray0, 2, 2);
      assertEquals(2, int0);
  }
}
