/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AttributesEditor;
import proguard.classfile.editor.BootstrapMethodsAttributeAdder;
import proguard.classfile.editor.ConstantPoolEditor;

public class ConstantAdder
implements ConstantVisitor {
    private final ConstantPoolEditor constantPoolEditor;
    private final BootstrapMethodsAttributeAdder bootstrapMethodsAttributeAdder;
    private int constantIndex;

    public ConstantAdder(ProgramClass programClass) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
        this.bootstrapMethodsAttributeAdder = new BootstrapMethodsAttributeAdder(programClass);
    }

    public int addConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
        return this.constantIndex;
    }

    public int addConstant(Clazz clazz, Constant constant) {
        constant.accept(clazz, this);
        return this.constantIndex;
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.constantIndex = this.constantPoolEditor.addIntegerConstant(integerConstant.getValue());
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.constantIndex = this.constantPoolEditor.addLongConstant(longConstant.getValue());
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.constantIndex = this.constantPoolEditor.addFloatConstant(floatConstant.getValue());
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.constantIndex = this.constantPoolEditor.addDoubleConstant(doubleConstant.getValue());
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        this.constantIndex = this.constantPoolEditor.addPrimitiveArrayConstant(primitiveArrayConstant.getValues());
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.constantIndex = this.constantPoolEditor.addStringConstant(stringConstant.getString(clazz), stringConstant.referencedClass, stringConstant.referencedMember);
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.constantIndex = this.constantPoolEditor.addUtf8Constant(utf8Constant.getString());
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        AttributesEditor attributesEditor = new AttributesEditor((ProgramClass)clazz, false);
        BootstrapMethodsAttribute bootstrapMethodsAttribute = (BootstrapMethodsAttribute)attributesEditor.findAttribute("BootstrapMethods");
        clazz.constantPoolEntryAccept(invokeDynamicConstant.u2nameAndTypeIndex, this);
        Clazz[] clazzArray = invokeDynamicConstant.referencedClasses;
        Clazz[] clazzArray2 = null;
        if (clazzArray != null) {
            clazzArray2 = new Clazz[clazzArray.length];
            System.arraycopy(clazzArray, 0, clazzArray2, 0, clazzArray.length);
        }
        bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, invokeDynamicConstant.getBootstrapMethodAttributeIndex(), this.bootstrapMethodsAttributeAdder);
        this.constantIndex = this.constantPoolEditor.addInvokeDynamicConstant(this.bootstrapMethodsAttributeAdder.getBootstrapMethodIndex(), this.constantIndex, clazzArray2);
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        clazz.constantPoolEntryAccept(methodHandleConstant.u2referenceIndex, this);
        this.constantIndex = this.constantPoolEditor.addMethodHandleConstant(methodHandleConstant.getReferenceKind(), this.constantIndex);
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        this.constantIndex = this.constantPoolEditor.addModuleConstant(moduleConstant.getName(clazz));
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        this.constantIndex = this.constantPoolEditor.addPackageConstant(packageConstant.getName(clazz));
    }

    @Override
    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addFieldrefConstant(this.constantIndex, fieldrefConstant.getName(clazz), fieldrefConstant.getType(clazz), fieldrefConstant.referencedClass, fieldrefConstant.referencedMember);
    }

    @Override
    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addInterfaceMethodrefConstant(this.constantIndex, interfaceMethodrefConstant.getName(clazz), interfaceMethodrefConstant.getType(clazz), interfaceMethodrefConstant.referencedClass, interfaceMethodrefConstant.referencedMember);
    }

    @Override
    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        clazz.constantPoolEntryAccept(methodrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addMethodrefConstant(this.constantIndex, methodrefConstant.getName(clazz), methodrefConstant.getType(clazz), methodrefConstant.referencedClass, methodrefConstant.referencedMember);
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.constantIndex = this.constantPoolEditor.addClassConstant(classConstant.getName(clazz), classConstant.referencedClass);
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        this.constantIndex = this.constantPoolEditor.addMethodTypeConstant(methodTypeConstant.getType(clazz), methodTypeConstant.referencedClasses);
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.constantIndex = this.constantPoolEditor.addNameAndTypeConstant(nameAndTypeConstant.getName(clazz), nameAndTypeConstant.getType(clazz));
    }
}

