<?php
$guide = array(
	'r' => array(
		'subdirs' => array(
			'techtree' => array(
				'gen' => 108,
				'text' => '<p>
Because so many people have asked, here\'s a full tech tree. Note that most Warzone technologies have more than one prerequisite, so you\'ll have to click through to see all the prerequisites.
</p>
<p>
Many Warzone technologies have more than one prerequisite, so they\'re listed under their first prerequisite, and subsequent prerequisites just have a "See above" link to where they\'re first mentioned.
</p>
<p>
Some random statistics: There are 428 technologies. Stormbringer Emplacement takes the longest to research. EMP Mortar has more prerequisites, though, but you can theoretically get it faster because you can spread them out over many research facilities. Other technologies with many requirements include Missile Fortress, Mass Driver Fortress, and Plasmite Bomb.
</p>',
				'title' => '',
				'titlebar' => ''
			)
		)
	),
	'suggestions' => array(
		'autogen' => TRUE,
		'title' => 'Suggestions',
		'titlebar' => '<strong>Suggestions</strong>',
		'text' => '<p><em>v0.1 by Ratarf - Last updated: 10/10/2008</em></p>
<h3><a name="intro">Introduction</a></h3>
<p>This page tracks feature requests for the game Warzone 2100.</p>

<p>Of course, we need a better, more dynamic approach before we can actually put this page in use. For example using PHP or the wiki. This version is only an example of how it COULD look, and meant primarly for getting as much feedback as possible, so we can use the maximum potential.</p>
<p>For now, this page contains some random suggestions. These are all scraped from the warzone forums without mentioning who suggested them. If any content on this page is your property, and you would like to see it removed, please post in the appropriate forum thread.</p>
<p><strong>For more \'about\'-information, look below the list!</strong></p>
<p class="msg"><strong>All discussion about this page can be found here: <a href="http://forums.wz2100.net/viewtopic.php?f=2&amp;t=2212">http://forums.wz2100.net/viewtopic.php?f=2&amp;t=2212</a>. Please help us improve this page by giving your opinion! </strong></p>

<h3><a name="features">Features List</a></h3>
<h4><a name="gui">GUI</a></h4>
<p>Graphical user-interface suggestions, both ingame as in the menu.</p>

<table width="671">
 <tr>
  <th width="221"><div align="center"><span class="style1">Feature</span></div></th>
  <th width="119"><div align="center"><span class="style1">State</span></div></th>
  <th width="110"><div align="center"><span class="style1">More Info </span></div></th>

  <th width="193"><div align="center"><span class="style1">Comment</span></div></th>
 </tr>

 <tr>
  <td>Design screen tooltip</td>
  <td bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>
  <td bgcolor="#660000"><div align="center" class="style1">Wishlist</div></td>
  <td>Show design name + required power</td>

 </tr>

 <tr>
  <td>Power summary window</td>
  <td bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>
  <td bgcolor="#660000"><div align="center" class="style1">Wishlist</div></td>
  <td>Show derricks owned, power production per minute,...</td>
 </tr>

 <tr>
  <td>Recycled units list </td>
  <td bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>
  <td bgcolor="#660000"><div align="center" class="style1">Wishlist</div></td>
  <td>Show ranks of pilot crews in queue</td>
 </tr>
 <tr>

  <td>Move \'Skirmish\' to Singleplayer </td>
  <td bgcolor="#669933"><div align="center"><strong>Trunk</strong></div></td>
  <td bgcolor="#FFFF00"><div align="center"><strong>/</strong></div></td>
  <td>Makes more sense! </td>
 </tr>
</table>
<h4><a name="terrain">Terrain &amp; World</a></h4>

<p>Suggestions related to the terrain and the world.</p>
<table width="671">
 <tr>
  <th width="221"><div align="center"><span class="style1">Feature</span></div></th>
  <th width="119"><div align="center"><span class="style1">State</span></div></th>
  <th width="110"><div align="center"><span class="style1">More Info </span></div></th>
  <th width="193"><div align="center"><span class="style1">Comment</span></div></th>

 </tr>
</table>
<h4><a name="units">Units</a></h4>
<p>Suggestions related to units and the manufacturing of units.</p>
<table width="671">
 <tr>
  <th><div align="center"><span class="style1">Feature</span></div></th>
  <th><div align="center"><span class="style1">State</span></div></th>

  <th><div align="center"><span class="style1">More Info </span></div></th>

  <th><div align="center"><span class="style1">Comment</span></div></th>
 </tr>

 <tr>
  <td width="221">Take all power at start of order</td>
  <td width="119" bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>

  <td width="110" bgcolor="#660000"><div align="center" class="style1">Wishlist</div></td>
  <td width="193">Optional, requires ctrl + click </td>

 </tr>
 <tr>
  <td>Realistic turning for tracked units</td>
  <td bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>

  <td bgcolor="#FF9900"><div align="center"><strong>???</strong></div></td>
  <td>Drive backwards, rotate in place,...</td>
 </tr>




</table>
<h4><a name="building">Building</a></h4>
<p>Building and buildings</p>

<table width="671">
 <tr>
  <th><div align="center"><span class="style1">Feature</span></div></th>
  <th><div align="center"><span class="style1">State</span></div></th>
  <th><div align="center"><span class="style1">More Info </span></div></th>

  <th><div align="center"><span class="style1">Comment</span></div></th>
 </tr>

 <tr>
  <td width="221">Gates</td>
  <td width="119" bgcolor="#FFFF00"><div align="center"><strong>Mod</strong></div></td>
  <td width="110" bgcolor="#00FF00"><div align="center"><strong><a href="http://forums.wz2100.net/viewtopic.php?f=10&amp;t=2186">Topic</a></strong></div></td>
  <td width="193">Optional, requires ctrl + click </td>

 </tr>

 <tr>
  <td>Semi-Transparent previews of ordered buildings</td>
  <td bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>
  <td bgcolor="#660000"><div align="center"><strong>Wishlist</strong></div></td>
  <td> </td>

 </tr>

</table>
<h4><a name="other">Other</a></h4>
<p>All suggestions that do not fit in another category</p>
<table width="671">
 <tr>
  <th><div align="center"><span class="style1">Feature</span></div></th>
  <th><div align="center"><span class="style1">State</span></div></th>
  <th><div align="center"><span class="style1">More Info </span></div></th>

  <th><div align="center"><span class="style1">Comment</span></div></th>
 </tr>
 <tr>
  <td width="221">Multiplayer savegames</td>
  <td width="119" bgcolor="#FF9900"><div align="center"><strong>Planned</strong></div></td>
  <td width="110"><div align="center"><strong>???</strong></div></td>

  <td width="193"> </td>

 </tr>
</table>
<h3><a name="about">About this page</a></h3>
<h4><a name="putwhat">What can be put here?</a></h4>
<ul>
 <li>Please no balancing stuff here. This would really clutter this page. </li>
 <li>Not too much technical details here. Off course an important \'AI patch\' is legal, but no bugfixes or references to code lines please. </li>

 <li>This page lists features that might make it in the game someday. It\'s purpose is not to list ALL suggestions ever made. </li>
</ul>
<h4>Where does this come from?</h4>
<p> The idea for this page comes from the OpenTTD Community. They have such a nice system for tracking features there, especially when compared to the chronological wishlist threats on the warzone forum, which are very cluttered. So why not use a similar approach here? </p>
<p>Specific pages to learn from: </p>
<ul>
 <li><a href="http://wiki.openttd.org/wiki/index.php/Requested_features">http://wiki.openttd.org/wiki/index.php/Requested_features</a></li>
 <li><a href="http://wiki.openttd.org/wiki/index.php/Talk:Requested_features">http://wiki.openttd.org/wiki/index.php/Talk:Requested_features</a></li>

 <li><a href="http://wiki.openttd.org/wiki/index.php/Talk:Requested_features/Archive">http://wiki.openttd.org/wiki/index.php/Talk:Requested_features/Archive</a></li>

</ul>
<h4><a name="statuses">Statuses and their explanation:</a></h4>
<table width="554">
 <tr>
  <td width="100" bgcolor="#CC0000"><div align="center" class="style1">Idea</div></td>
  <td width="438">Just an idea someone, or more people, came up with. </td>
 </tr>

 <tr>
  <td bgcolor="#330066"><div align="center" class="style1">Concept</div></td>

  <td>Properly sketched or prepared idea </td>
 </tr>
 <tr>
  <td bgcolor="#FF9900"><div align="center"><strong>Planned</strong></div></td>
  <td>Planned by the dev-team for a later release </td>

 </tr>
 <tr>

  <td bgcolor="#FFFF00"><div align="center"><strong>Mod</strong></div></td>
  <td>Available in a mod </td>
 </tr>
 <tr>
  <td bgcolor="#666600"><div align="center"><strong>Branch</strong></div></td>

  <td>...</td>
 </tr>

 <tr>
  <td bgcolor="#669933"><div align="center"><strong>Trunk</strong></div></td>
  <td>...</td>
 </tr>
 <tr>

  <td bgcolor="#00FF00"><div align="center"><strong>Stable Release </strong></div></td>
  <td>...</td>






 </tr>
</table>
<h4><a name="aboutmoreinfo">About \'More Info\'</a></h4>

<table width="509">
 <tr>
  <td width="47" bgcolor="#660000"><div align="center" class="style1">Wishlist</div></td>
  <td width="446">Discussion about this feature is in the wishlist (see below). Happy searching! </td>
 </tr>
 <tr>

  <td bgcolor="#FFFF00"><div align="center" class="style3">/</div></td>

  <td>This feature is obvious and no further discussion (topic) is required</td>
 </tr>
 <tr>
  <td bgcolor="#00FF00"><div align="center"><strong>Topic</strong></div></td>
  <td>There\'s at least 1 discussion topic for this feature (there could also be a wiki article). So please note that there could be multiple links here!</td>
 </tr>

 <tr>

  <td bgcolor="#FF9900"><div align="center"><strong>???</strong></div></td>
  <td>Not sure where this feature is discussed. </td>
 </tr>
</table>
<h3><a name="wishlist">Wishlist</a></h3>
<p>The wishlist topics can be found here:</p>
<ol>
 <li>
  <a href="http://forums.wz2100.net/viewtopic.php?f=6&amp;t=771">Wishlist 1</a></li>

 <li><a href="http://forums.wz2100.net/viewtopic.php?f=6&amp;t=1267">Wishlist 2</a></li>
 <li><a href="http://forums.wz2100.net/viewtopic.php?f=6&amp;t=2224">Wishlist 3</a></li>
</ol>
<h3><a name="why">Why this list?</a></h3>
<ul>
 <li>Give players ONE place to look for new features</li>

 <li>Enable developers to get a quick overview of the things players want in the game</li>

 <li>Save people the time of looking up requests in a 15-pages long topic. </li>
 <li>Save everyone the time of explaining a feature over and over again because it gets lost in the threads. </li>
 <li>Allow player X\'s feature requests to inspire players Y and Z to yet another great idea.</li>
</ul>
<h3><a name="howhelp">How to help?</a></h3>
<ul>
 <li>Move worthy suggestions from the wishlist to their own topic, with a clear name. </li>

 <li>Look for topics discussing certain existing features and add them to this list. </li>
 <li>Do useful feature requests the right way!</li>
 <li>Update the progress in this list (<strong>not available yet, since you can not edit it</strong>). </li>
 <li><a href="http://forums.wz2100.net/viewtopic.php?f=2&amp;t=2212">Discuss </a>everything about this page. Colors, categories,... Everything is welcome!</li>
 <li>Especially, discuss the best way to put this page in use, <strong>technically</strong>. </li>

 <li>Always keep looking for ways to do things the best way. </li>
</ul>
<p class="msg"> <strong>All discussion about this page can be found here: <a href="http://forums.wz2100.net/viewtopic.php?f=2&amp;t=2212">http://forums.wz2100.net/viewtopic.php?f=2&amp;t=2212</a>. Please help us improve this page by giving your opinion!</strong></p>',
		'cachedsb' => '<li><a href="#intro">Introduction</a></li><li><a href="#features">Features List</a><ul><li><a href="#gui">GUI</a></li><li><a href="#terrain">Terrain &amp; World</a></li><li><a href="#units">Units</a></li><li><a href="#building">Building</a></li><li><a href="#other">Other</a></li></ul></li><li><a href="#about">About this page</a><ul><li><a href="#putwhat">What can be put here?</a></li><li><a href="#statuses">Statuses and their explanation:</a></li><li><a href="#aboutmoreinfo">About \'More Info\'</a></li></ul></li><li><a href="#wishlist">Wishlist</a></li><li><a href="#why">Why this list?</a></li><li><a href="#howhelp">How to help?</a>'
	),
	'b' => array(
		'subdirs' => array(
			'commandcenter' => array(
				'gen' => 109,
				'text' => '<p>
The Command Center is the heart of every Warzone base. It\'s needed for two things: To <a href="../design">design units</a>, and to show the <a href="../minimap">minimap</a>.
</p>',
				'title' => '',
				'titlebar' => ''
			),
			'powergenerator' => array(
				'gen' => 109,
				'text' => '<p>
The power generator in conjunction with oil derricks <a href="../power">gives the player power</a>. One power generator is needed for every four oil derricks, or the oil derricks will not function. Additional power generators will not generate any more power.
</p>
<p>
The power module gives power faster (+50.9% to the power multipliers - note that this is in addition to the fact that researching Power Module sets the base multiplier to 125%).
</p>',
				'title' => '',
				'titlebar' => ''
			),
			'researchfacility' => array(
				'gen' => 109,
				'text' => '<p>
The research facility allows the player to <a href="../research">research upgrades and new technologies</a>. One research facility can research one technology at a time, and research cannot be queued.
</p>
<p>
The research module allows for faster research (+85.7% to the current research multiplier).
</p>',
				'title' => '',
				'titlebar' => ''
			),
			'factory' => array(
				'gen' => 109,
				'text' => '<p>
Factories are needed to <a href="../manufacture">manufacture units</a>: Factories produce tanks, Cyborg Factories produce cyborgs, and VTOL Factories produce VTOL aircraft.
</p>
<p>
Factories and VTOL Factories can be upgraded with Factory Modules up to two times. This will add 100% to its production rate multiplier and allow production of larger tanks/VTOLs. One Factory Module is needed to produce tanks with medium bodies, and two Factory Modules on the same Factory are needed to produce tanks with heavy bodies.
</p>
<p>
It takes a number of seconds equal to weight/100 to rearm a VTOL, before rearming pad upgrades.
</p>',
				'title' => '',
				'titlebar' => ''
			),
			'commandrelaycenter' => array(
				'gen' => 109,
				'text' => '<p>
The Command Relay Center is required to make <a href="../commanders">Commanders</a> (tanks with Command Turrets). Commanders <a href="../experience">provide bonuses</a> to units assigned to them.
</p>',
				'title' => '',
				'titlebar' => ''
			)
		)
	),
	'index' => array(
		'autogen' => TRUE,
		'title' => 'Home',
		'titlebar' => '<strong>Home</strong>',
		'text' => '      <div style="max-width:10in;"><div style="float:right;width:320px;"><script type="text/javascript" src="images/swfobject.js"></script>
<div id="player" class="p">&nbsp;</div>
<script type="text/javascript">
<!--
// style="float:left;padding-right:1em;"
      var so = false;
      var size = -1;
      function resizemovie(nsize)
      {
        if (size == nsize) return false;
        var w=320, h=260;
        switch (nsize)
        {
        case 1:
		w=640; h=500;
		break;
        }
        so = new SWFObject(\'images/flvplayer.swf\',\'single\',\'\'+w,\'\'+h,\'7\');
        so.addParam("allowfullscreen","true");
        so.addVariable("file","devastation.flv");
        so.addVariable("image","images/devastation.jpg");
        so.addVariable("backcolor","0x5D91DA");
        so.addVariable("frontcolor","0xD9E1F6");
        so.addVariable("lightcolor","0xFFFFFF");
        so.write(\'player\');
        //if (size >= 0) document.getElementById(\'size\'+size).className = \'nsel\';
        //size = nsize;
        //document.getElementById(\'size\'+size).className = \'sel\';
        //document.getElementById(\'size\'+size).blur();
      }
      resizemovie(0);
//-->
</script>

<p class="backforward"><a href="story">Larger size &raquo;</a></p>
<ul class="nav">
<li><a href="http://wz2100.net/download">Download game</a></li>
</ul>
</div>
<div style="margin-right:340px;">
<h3 id="intro">Introduction</h3>
<p>

Warzone 2100 is a <a href="http://en.wikipedia.org/wiki/Real-time_strategy" target="_blank">real-time strategy</a> game, originally developed by Pumpkin Studios and published by Eidos Interactive, now developed by the <a href="http://wz2100.net">Warzone 2100 Project</a>. Compared to other real-time strategy games, it has a greater focus on artillery, radar, and counter-battery technologies, more frequent in-game cinematic updates as game play progresses, a <a href="r/tech-tree">massive research tree</a>, as well as a vehicle design system.

</p>
<p class="backforward"><a href="intro">Read more &raquo;</a></p>
<h3 id="manual">Manual</h3>
<ul class="nav">
<li><a href="basics">Basics</a></li>
<li><a href="keyboard">Keyboard shortcuts</a></li>
<li><a href="walkthrough">Walkthrough</a></li>
</ul>
<h3 id="reference">Reference</h3>
<ul class="nav">
<li><a href="b/">Base structures</a></li>
<li><a href="d/">Defensive structures</a></li>
<li><a href="w/">Turrets</a></li>
<li><a href="c/">Cyborgs</a></li>
<li><a href="bp/">Bodies and Propulsion</a></li>
<li><a href="r/tech-tree">Tech tree</a></li>
<li><a href="experience">Unit experience</a></li>
</ul>
<h3 id="advanced">Advanced strategy</h3>
<ul class="nav">
<li><a href="earlygamestrategy">Early-game strategy</a></li>
<li><a href="damage">Damage formula</a></li>
<li><a href="weapons">Weapon guide</a></li>
<li><a href="rankings">Multiplayer rankings</a></li>
</ul>
<h3 id="dev">For developers</h3>
<ul class="nav">
<li><a href="cheats">Cheats</a></li>
<li><a href="http://developer.wz2100.net/">Development</a></li>
</ul>
</div></div>
<h4><a name="note">Note</a> </h4>
<p>
<em>The Warzone 2100 Guide applies to the latest version, version 2.2, of Warzone 2100. For guides for other versions of the game, see <a href="ntw/" rel="nofollow">NTW Guide</a> or <a href="1.10/" rel="nofollow">Warzone 1.10 Guide</a>.</em>
</p>',
		'cachedsb' => '<li><a href="#intro">Introduction</a></li><li><a href="#manual">Manual</a></li><li><a href="#reference">Reference</a></li><li><a href="#advanced">Advanced strategy</a></li><li><a href="#dev">For developers</a>'
	),
	'intro' => array(
		'autogen' => TRUE,
		'title' => 'Introduction',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Introduction</strong>',
		'text' => '<h3 id="intro">Introduction</h3>

<p>
Warzone 2100 is a <a href="http://en.wikipedia.org/wiki/Real-time_strategy">real-time strategy</a> game, originally developed by Pumpkin Studios and published by Eidos Interactive, now developed by the <a href="http://wz2100.net">Warzone 2100 Project</a>. Compared to other real-time strategy games, it has a greater focus on artillery, radar, and counter-battery technologies, more frequent in-game cinematic updates as game play progresses, a <a href="new/r/tech-tree">massive research tree</a>, as well as a vehicle design system.
</p>

<h3 id="story">Story</h3>

<p>
In the late 21st century, NASDA (the North American Strategic Defense Agency) developed and deployed a massive missile defense system, including a network of nuclear-equipped satellites and ground-based launch sites. However, during a routine maintenance check, something went terribly wrong...
</p>
<p class="backforward"><a href="story"><em>Read more</em> &raquo;</a></p>

<h3 id="multiplay">Multiplayer</h3>

<p>
Outside of the story, Warzone 2100 only has a single faction. This limits some of the variety that can be expected from <a href="http://en.wikipedia.org/wiki/Real-time_strategy">real-time strategy</a> games, although the single faction is very complex. Essentially, Warzone 2100 plays much like <a href="http://en.wikipedia.org/wiki/Earth_2150">Earth 2150</a> with 3D units and terrain, customizable vehicles, a lack of traditional infantry, use of "research" to acquire new technologies, and the differentiation of vehicles types.
</p>
<p>
Compared to other RTS\'s, Warzone 2100 has:
</p>
<ul>
<li><p>A unit design system that lets players choose bodies, propulsions, and weapons.</p></li>
<li><p>A greater emphasis on sensors and radar: Basic sensors detect units and can co-ordinate ground attacks. Counter-battery (CB) sensors detect enemy artillery batteries and coordinate artillery strikes against enemy artillery. VTOL sensors and VTOL CB sensors coordinate VTOL attacks. Radar detectors detect enemy sensors.</p></li>
<li><p>A greater emphasis on artillery: With the assistance of sensors, late game artillery can fire from huge distances.</p></li>
<li><p>A massive <a href="new/r/tech-tree">technology tree</a>, with small incremental advancements over existing technologies being required for later technologies.</p></li>
</ul>

<h3 id="installing">Installing</h3>

<p>
Warzone can be downloaded from:
</p>
<ul class="nav"><li><p><a href="http://wz2100.net/download"><em>Download</em> Warzone 2100</a></p></li></ul>
<p>
On most distributions of Linux, Warzone should be available in your repositories. However, these are often outdated, and you are encouraged to compile Warzone yourself, which is the usual:
</p>
<blockquote><p><code>./configure && make</code></p></blockquote>
<p>
For compiling tips on other platforms, or if the above fails, see the <a href="http://developer.wz2100.net/wiki/CompileGuide">Compile Guide</a>.
</p>

<h3 id="playing">Playing Warzone</h3>

<p>
<em>See also:</em> <a href="http://wz2100.net/faq">FAQ</a>
</p>
<p>
The easiest way to learn how to play is to play the <strong>Tutorial</strong> in the game.
</p>',
		'cachedsb' => '<li><a href="#intro">Introduction</a></li><li><a href="#story">Story</a></li><li><a href="#multiplay">Multiplayer</a></li><li><a href="#installing">Installing</a></li><li><a href="#playing">Playing Warzone</a>'
	),
	'weapons' => array(
		'autogen' => TRUE,
		'title' => 'Weapon Guide',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Weapon guide</strong>',
		'text' => '<h3 id="classification">Classification</h3>

<p>
Warzone weapons can be classified four different ways: targeting, type, class, and subclass.
</p>
<h3 id="targeting">Targeting</h3>

<ul>
<li><p><em>direct</em> &ndash; Direct-fire weapons fire projectiles that fly in a straight line at their target.</p></li>
<li><p><em>erratic direct</em> &ndash; A VTOL bomb. Equivalent to a direct weapon for all intents and purposes.</p></li>

<li><p><em>direct homing</em> &ndash; Direct homing weapons will fire projectiles in the direction of their target, but the projectile will "home in" on its target, i.e. it will continually adjust itself so it will still hit its target if its target moves.</p></li>
<li><p><em>indirect</em> &ndash; Indirect weapons, better known as artillery weapons, will fire in an arc, and do not require a line-of-sight between itself and what it\'s shooting. With the exception of the <a href="w/minirocketartillery">mini-rocket artillery</a>, indirect weapons are generally used as long-range weapons. They require sensor turrets to take advantage of their long range.</p></li>

</ul>
<h3 id="type">Type</h3>
<p>The type of a weapon determines what it\'s effective against and what it\'s not effective against.</p>

<p><em>See also:</em> <a href="w/#weapontable">Weapon damage table</a></p>
<ul>
<li><p><em>anti-personnel</em> &ndash; Anti-personnel weapons are most effective against cyborgs. They do below-average damage to tracked tanks and hard structures, and average damage to other targets. All anti-personnel weapons can also hit VTOLs. <br />Examples: machineguns, lasers</p></li>
<li><p><em>anti-tank</em> &ndash; Anti-tank weapons are most effective against tanks. They do below-average damage to everything else, and very little damage to cyborgs and hard structures. Most anti-tank weapons do high damage, but have low HP, and so are best protected by cannons. When wielded by cyborgs, many anti-tank weapons can also hit air. <br />Examples: mini-rockets, rockets, missiles</p></li>

<li><p><em>all-rounder</em> &ndash; Despite their name, all-rounder weapons do not do average damage to everything: they do above-average damage against tanks and structures. They do below-average damage to bunkers, and average damage to everything else. The "traditional" all-rounder weapons have high HP, making them suitable for sieging a base. <br />Examples: cannons, rails, VTOL machineguns, Plasma Cannon</p></li>
<li><p><em>anti-structure</em> &ndash; Anti-structure weapons do the most damage against bunkers, but a lot of damage against other structures. They do little damage against tanks and cyborgs. The <a href="w/bunkerbuster">bunker buster</a> is the only anti-structure weapon in the base un-modded game of Warzone.</p></li>
<li><p><em>flamer</em> &ndash; Flamers are very good against cyborgs and bunkers. They do good damage against most other targets, but practically no damage against hard structures. The only flamer weapons are in the flamer subclass.</p></li>

<li><p><em>artillery</em> &ndash; Artillery-type weapons (not to be confused with artillery weapons, which don\'t include bombs) are like anti-personnel weapons: They do high damage to cyborgs and hard structures, low damage to bunkers, and moderate damage to everything else. <br />Examples: mortars, howitzers, bombs, all other artillery weapons, <a href="w/lassat">Laser Satellite Command Post</a></p></li>
<li><p>(<em>anti-aircraft</em>) &ndash; Anti-aircraft weapons technically have a type of "anti-tank", but they can only hit aircraft. <br />Examples: AA-guns, SAMs, <a href="w/stormbringer">Stormbringer</a></p></li>
</ul>

<p>Note that just because a weapon\'s type does high damage to a particular target does not mean that it is suitable for that target. In particular, it would not be a good idea to use a <a href="w/lassat">laser satellite</a> against a cyborg. On the other hand, Scourge Missile, while being an anti-tank weapon, can be useful for attacking unattended structures from a distance.</p>

<h3 id="class">Class</h3>
<ul>
<li><p><em>kinetic</em> &ndash; Kinetic weapons are weapons that derive most of their damage from their impact. Most weapons in Warzone are kinetic.</p></li>
<li><p><em>thermal</em> &ndash; Thermal weapons are weapons that derive most of their damage from heat or fire. On average, they do greater damage to tanks and cyborgs. New Paradigm and Super Heavy bodies have high thermal armor, while Project and Collective bodies have low thermal armor. <br />Examples: lasers, flamers, incendiary artillery, firebombs, Laser Satellite Command Post</p></li>

</ul>
<p>
Again, just because a weapon\'s class does higher damage to a body does not mean the weapon itself is suitable to attack a tank with that body. In particular, lasers, as anti-personnel weapons, do low damage even to Collective bodies.

</p>
<h3 id="special">Special weapons</h3>
<p>
Some weapons are special, and can have one or more of the following attributes:
</p>
<ul>
<li><p><em>splash damage</em> &ndash; Weapons with splash damage will do damage to everything in the area around where it hits. The area can be large or small, depending on the weapon. <br />Examples: artillery-type weapons, cannons, rails, <a href="w/lassat">Laser Satellite Command Post</a></p></li>

<li><p><em>fire damage</em> &ndash; Weapons with fire damage (more than just flamers, not to be confused with thermal weapons) will cause things they hit to catch fire and take damage over a certain amount of time. <br />Examples: flamers, incendiary artillery, firebombs</p></li>

<li><p><em>EMP</em> &ndash; EMP weapons will disable their target for a short period of time. <br />Examples: <a href="w/empcannon">EMP cannon</a>, <a href="w/empmissilelauncher">VTOL EMP missile launcher</a>, <a href="w/empmortar">EMP mortar</a></p></li>

</ul>
<h3 id="subclasses">Subclasses</h3>
<p>
By far the biggest most important division between weapons is the subclasses.
</p>

<p>
Research tips: Unless otherwise specified, stronger weapons in a subclass are obtained by upgrading that subclass. Stronger weapons, as well as stronger weapon upgrades, generally require better research speed upgrades (Synaptic Link Data Analysis, Dedicated Synaptic Link Data Analysis, Neural Synapse Research Brain). Most stronger weapons require damage upgrades, although rotary weapons usually require rate-of-fire (ROF) upgrades instead.
</p>
<h3 id="t1">T1 Subclasses</h3>
<h4>Machineguns</h4>
<p>
The first weapon you get in Warzone is the Machinegun, and the Twin Machinegun and Heavy Machinegun (often called HMG) shortly thereafter. Machineguns (often called MGs) are good all-rounder weapons, but quickly get outclassed by anti-tank weapons.
</p>

<h4>Mini-Rockets</h4>
<p>
The Mini-Rocket Pod, obtained by researching Fuel Injection Engine, is a good early-T1 anti-tank weapon, but it will quickly lose out to more powerful anti-tank weapons such as cannons and rockets. The Mini-Rocket Artillery (often called MRL) is a good complement for anti-tank weapons, best against the targets anti-tank weapons like mini-rockets and rockets are worst against, but users of Mini-Rockets will find themselves disadvantaged against a research rusher if they do not upgrade to Lancers as soon as possible.
</p>
<h4>Cannons</h4>

<p>
Cannons, obtained by upgrading machinegun damage, (Light Cannon, Medium Cannon, Heavy Cannon, often abbreviated LC, MC, and HC respectively) are weapons with high HP and moderate damage against tanks and walls. VTOL cannons, unlike VTOL rockets, cannot attack other VTOLs.
</p>
<h4>Rockets</h4>
<p>
The Lancer, obtained by upgrading mini-rocket damage and acccuracy, is an anti-tank weapon with low HP, high damage, and long range. Unlike the cannon, however, it is <em>very</em> ineffective against cyborgs and walls. VTOL lancers, unlike VTOL cannons, are effective against other VTOLs, although they do plenty of damage to ground tanks, as well.

</p>
<p>
Users of rockets and missiles should remember to right-click them and set them to Long Range for maximum effectiveness.
</p>
<p>
The Bunker Buster, also obtained by upgrading mini-rocket damage and accuracy, is the only anti-structure weapon, and is generally used as a support weapon to destroy enemy defensive structures.
</p>

<h4>Flamers</h4>
<p>
Flamers, obtained by upgrading machineguns and Fuel Injection Engine, have the lowest range and highest damage rate of all T1 weapons, once their incendiary effect (read: setting things on fire) is taken into account. They also do fire damage to multiple targets within range at once, making them deadly if they survive to get close to enemy tanks, cyborgs, and bunkers. However, they are usually very weak, making hit-and-run tactics surprisingly effective on them.
</p>
<p>
Although the flamer is very effective against tanks, cyborgs, and bunkers, it is <em>extremely</em> ineffective against walls.

</p>
<p>
Since cyborgs are inexpensive (and thus can be massed) and have high speed, flamers are best used on cyborgs.
</p>
<h4>Mortars</h4>
<p>

Mortars, obtained by upgrading cannons, are artillery weapons. As artillery weapons, they have a relatively low damage rate but very long range when assigned to a sensor. They are good all-rounder weapons, but do especially high damage against cyborgs, and relatively low damage to tracked tanks. Because of their low damage rate and low HP, they do very poorly in close-ranged combat, and should be carefully protected by direct-fire weapons.
</p>
<h4>Bombs</h4>
<p>
The Cluster Bombs Bay is the VTOL equivalent of an artillery weapon like the mortar. An all-rounder weapon.
</p>
<h3 id="t2">T2 Subclasses</h3>

<h4>Machineguns</h4>
<p>
The Assault Gun is useful against cyborgs, and Rotary MG Bunkers are particularly inexpensive, but they aren\'t as good general-purpose weapons as cannons or mortars.
</p>
<h4>Cannons</h4>
<p>

The Hyper Velocity Cannon is a longer-range cannon with lower HP. It still has higher HP and lower damage than a rocket, and is similar to the T1 cannons in every other way.
</p>
<p>
Although the Hyper Velocity Cannon (often called HPV or HVC) is the only actual T2 cannon, Heavy Cannons are also very usable in T2.
</p>
<h4>Rockets</h4>
<p>

The Tank Killer is similar to a Lancer, but has a slightly longer range, higher damage rate, and a slower reload.
</p>
<p>
Ripple Rockets are the earliest very-long-range artillery players can get. It has a very slow reload time, but is devastating to enemy structures.
</p>
<h4>Flamers</h4>
<p>
The Inferno is a more powerful flamer, and is used similarly.

</p>
<h4>Mortars</h4>
<p>
The incendiary mortar is a twist on the generic artillery concept, for anyone who wishes to digress their mortar research into flamers.
</p>
<h4>Howitzers</h4>

<p>
Howitzers are mortars with significantly longer range and slower reloading. They are used similarly to mortars.
</p>
<h4>Bombs</h4>
<p>
Firebombs, obtained by upgrading bombs and flamers, are useful for damaging a wide area.
</p>
<h3 id="t3">T3 weapons</h3>

<h4>Cannons</h4>
<p>
Cannons are (debatably) the only T1 subclass to be usable in T3, and even the best cannon upgrades are cheaper than T3 weapon upgrades &ndash; notable to anyone who wishes to save money on research. Assault cannons are used similarly to cannons in T1, although, as assault weapons, they are better against cyborgs than their predecessors.

</p>
<h4>Missiles</h4>
<p>
The Scourge Missile, obtained by upgrading rockets, is the only homing ground-to-ground and air-to-ground tank weapon (technically, lasers are also homing, but their projectiles move too quickly to make a difference). It also has the highest damage rate of any medium or long range weapon, and is tied for longest-range direct-fire ground weapon. Though it has many strenghths, it shares the weaknesses of its predecessors: Low HP and ineffectiveness against cyborgs and walls.
</p>
<p>
Angel Missiles are a stronger version of Mini-Rocket Artillery. Archangel Missiles are stronger long-range artillery with slow reload times, similar to Ripple Rockets. Archangel Missiles have the longest range of any artillery weapon.
</p>
<h4>Rail guns</h4>

<p>
Rail guns, obtained by upgrading cannons, are improved, long-range versions of T1 cannons with higher HP and damage rate. They are used similarly.
</p>
<h4>Lasers</h4>

<p>
Lasers are the first thermal weapon that isn\'t a fire weapon. They are anti-personnel, and are used similarly to machineguns at all. Although their reload time isn\'t nearly as fast as a rotary weapon, they still usually have faster reload times than most other weapons.
</p>
<p>
Flashlight and Pulse Laser are long-range weapons (Pulse Laser being tied with Scourge for longest-range direct-fire ground weapon). They are good general-purpose weapons.
</p>
<p>
Heavy Laser is a short-range weapon with a high damage rate. Plasma Cannon is an even shorter-range weapon with a higher damage rate and a slow reload time.
</p>
<h4>Flamers</h4>
<p>

The Plasmite Flamer is an even more powerful flamer, and is used similarly to the Inferno.
</p>
',
		'cachedsb' => '<li><a href="#classification">Classification</a></li><li><a href="#targeting">Targeting</a></li><li><a href="#type">Type</a></li><li><a href="#class">Class</a></li><li><a href="#special">Special weapons</a></li><li><a href="#subclasses">Subclasses</a></li><li><a href="#t1">T1 Subclasses</a></li><li><a href="#t2">T2 Subclasses</a></li><li><a href="#t3">T3 weapons</a>'
	),
	'damage' => array(
		'autogen' => TRUE,
		'title' => 'Damage formula',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Damage calculation</strong>',
		'text' => '<p>

Ever wonder how damage is calculated in Warzone? If you just want to know if armor is subtractive or multiplicative, it\'s subtractive:
</p>
<p>
[DAMAGE] = [BASE DAMAGE] - [ARMOR]
</p>
<p>
<em>or</em>
</p>
<p>
[DAMAGE] = 30% x [BASE DAMAGE]
</p>
<p>

whichever is higher.
</p>
<p>

But to know exactly how much damage you\'re going to do, you need to know how to calculate base damage.
</p>
<h3 id="formula">The formula</h3>
<p>
[BASE DAMAGE] = [WEAPON DAMAGE] x [WEAPON SUBCLASS DAMAGE UPGRADE] x [WEAPON TARGET MODIFIER]
</p>
<p>
[ARMOR] = [TARGET WEAPON CLASS ARMOR] x [CLASS ARMOR UPGRADE]
</p>
<p>
Damage is [BASE DAMAGE] - [ARMOR], or 30% of [BASE DAMAGE], whichever is higher, rounded down (The exception is when rounding down would make damage 0, in which case damage is rounded up to 1).
<h3 id="weapontable">Weapon Multiplier Table</h3>

<p>Use values in this table for [WEAPON TARGET MODIFIER].</p>

<p><em>This table can also be found in the Weapons section of <a href="w/">Turrets</a>.</em></p>
<div style="max-width:800px;"><table width="100%" border="0" cellspacing="0" class="mpad"> 
<tr valign="top"><th class="r nb" width="22%">&nbsp;</th><th class="c" width="13%"><acronym title="Anti-Personnel">AP</acronym></th><th class="c" width="13%">Anti-Tank</th><th class="c" width="13%">Anti-Struct</th><th class="c" width="13%">Artillery</th><th class="c" width="13%">Flamer</th><th class="c" width="13%">All-Rounder</th></tr> 
<tr><th class="l">Cyborg</td><td class="c">140%</td><td class="c">30%</td><td class="c">30%</td><td class="c">130%</td><td class="c">130%</td><td class="c">60%</td></tr> 


<tr><th class="l">Wheels</td><td class="c">100%</td><td class="c">130%</td><td class="c">30%</td><td class="c">95%</td><td class="c">110%</td><td class="c">120%</td></tr> 
<tr><th class="l">Half-Tracks</td><td class="c">80%</td><td class="c">125%</td><td class="c">40%</td><td class="c">80%</td><td class="c">100%</td><td class="c">110%</td></tr> 
<tr><th class="l">Tracks</td><td class="c">60%</td><td class="c">120%</td><td class="c">50%</td><td class="c">65%</td><td class="c">90%</td><td class="c">100%</td></tr> 


<tr><th class="l">VTOL</td><td class="c">60%</td><td class="c">80%</td><td class="c">30%</td><td class="c">40%</td><td class="c">25%</td><td class="c">50%</td></tr> 
<tr><th class="l">Hover</td><td class="c">110%</td><td class="c">100%</td><td class="c">20%</td><td class="c">110%</td><td class="c">130%</td><td class="c">100%</td></tr> 
<tr><th class="l">Soft structures</td><td class="c">160%</td><td class="c">75%</td><td class="c">100%</td><td class="c">200%</td><td class="c">150%</td><td class="c">130%</td></tr> 


<tr><th class="l">Medium structures</td><td class="c">80%</td><td class="c">50%</td><td class="c">120%</td><td class="c">120%</td><td class="c">60%</td><td class="c">110%</td></tr> 
<tr><th class="l">Hard structures</td><td class="c">45%</td><td class="c">25%</td><td class="c">300%</td><td class="c">100%</td><td class="c">10%</td><td class="c">90%</td></tr> 
<tr><th class="l">Bunkers</td><td class="c">80%</td><td class="c">60%</td><td class="c">400%</td><td class="c">40%</td><td class="c">300%</td><td class="c">50%</td></tr> 


</table></div>
<h3 id="clarification">Clarification</h3>
<ul>
<li><p>[WEAPON DAMAGE] is the base damage of the weapon - what you see in the "Damage" column of the turret table.</p></li>
<li><p>[WEAPON SUBCLASS DAMAGE UPGRADE] is the best damage upgrade you\'ve researched for the weapon\'s subclass.</p></li>
<li><p>[WEAPON TARGET MODIFIER] is the multiplier in the above damage table.</p></li>
<li><p>[TARGET WEAPON CLASS ARMOR] is the target\'s thermal armor for thermal weapons, and kinetic armor for kinetic weapons. In tanks and VTOLs, thermal armor depends on nothing but the vehicle body.</p></li>
<li><p>[CLASS ARMOR UPGRADE] is the best kinetic/thermal armor upgrade your target has researched for it.</p></li>
</ul>
<h3 id="example">An example</h3>

<p>
Green\'s Tank Killer Scorpion Half-Tracks shoots Yellow\'s Heavy Cannon Python Tracks. Green has HESH Rocket Warhead Mk2, and Yellow has Dense Composite Alloys.
</p>
<p>
Tank Killer (an anti-tank weapon) has 120 damage. HESH Rocket Warhead Mk2 gives 150%, and anti-tank weapons do 110% damage against tracks.
</p>
<p>
[BASE DAMAGE] = 120 x 150% x 110% = 198.
</p>
<p>
Tank Killer is a kinetic weapon, and Python has 20 Kinetic Armor. Dense Composite Alloys upgrades 220%.
</p>
<p>
[ARMOR] = 20 x 220% = 44
</p>
<p>

198 - 44 (154) is greater than 198 x 30% (59), so the tank killer does 154 damage each time it hits (Notice that it fires four salvos; if they all hit, the tank killer does 616 damage, a significant proportion of the 880 HP the heavy cannon tank has).

</p>',
		'cachedsb' => '<li><a href="#formula">The formula</a></li><li><a href="#weapontable">Weapon Multiplier Table</a></li><li><a href="#clarification">Clarification</a></li><li><a href="#example">An example</a>'
	),
	'sensors' => array(
		'autogen' => TRUE,
		'title' => 'Sensors and artillery',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Using sensors and artillery</strong>',
		'text' => '<p>
<em>See also:</em> <a href="commanders">Commanders</a>

</p>
<h3 id="artillery">Artillery</h3>
<p>
As a review, keep in mind that "artillery" here refers to all indirect-fire weapons except the Mini-Rocket Array (MRL) and Seraph Missile Array, namely:
</p>
<ul>
<li>Mortars (mortar, bombard, pepperpot, incendiary mortar)</li>
<li>Howitzers (howitzer, ground shaker, hellstorm, incendiary howitzer)</li>
<li>Ripple rockets</li>
<li>Archangel missiles</li>
</ul>
<p>
Although the MRL and Seraph are indirect-fire weapons, they should be used like one would use direct-fire weapons, since their range is low enough that its internal sensor can handle it; external sensors are unnecessary.
</p>
<h3 id="sensors">Sensors</h3>
<p>
<img src="icon/w/sensorturret.gif" alt="" />
</p>
<p>
Regular sensors can be used for scouting and surveillance, but they have a more important usage: to spot for artillery.
</p>
<h4 id="spotting">Using sensors with artillery</h4>
<p>
Artillery weapons, by themselves, cannot fire more than their sensor range (8 tiles without upgrades). However, even the lowly mortar has an 18-tile weapon range. To use it, players need to use sensors.
</p>
<p>
Artillery structures are the easiest. Simply build a sensor tower, and if the sensor tower is targeting something within your artillery structures\' weapon range, they will fire at it.

</p>
<p>
An artillery tank, however, needs to be explicitly assigned to a sensor to function. Select the artillery tanks, then click on a sensor to assign the tank to the sensor.
</p>

<p>
<img src="pictures/sensors-assign.jpg" alt="Hellstorms assigned to Wide Spectrum Sensor" /><br />
<em>Artillery assigned to a sensor. Notice the * next to them, which indicates that they are assigned.</em>
</p>
<p>
Once the artillery is assigned, if it is assigned to a sensor tower, that tower will target enemies that come in range automatically.
</p>
<p>
If it is assigned to a sensor tank, the sensor can be used to attack enemies by selecting the sensor and targeting an enemy. All artillery assigned to the sensor will attack its target.
</p>
<p>

<img src="pictures/sensors-longrange.jpg" alt="Hellstorms seiging an enemy hardpoint" /><br />
<em>Notice that the artillery can be very far away&mdash;only the sensor turret needs to get within range.</em>
</p>

<p>
To unassign a unit from a sensor, the easiest way is to <span class="click">right-click</span> it, then tell it to move somewhere. Multiple units can be selected with <span class="key">ctrl</span>+<span class="click">click</span>, and moving them all.
</p>
<h4 id="cb">CB sensors</h4>

<p>
<img src="icon/w/cbradarturret.gif" alt="" />
</p>
<p>
A CB (Counter-Battery) tower or turret is used similarly to a standard sensor; however, it serves a specialized purpose: To counter-attack enemy artillery.
</p>
<p>
Normal sensor towers will direct your artillery to attack whatever is nearby, but CB towers will direct your artillery to attack any artillery attacking you, even if they are further away from you than other targets. If you have both a CB tower and a sensor tower, artillery structures will attack CB targets first, and only other targets once you are no longer being bombarded by enemy artillery.
</p>
<p>
<img src="icon/w/vtolcbradarturret.gif" alt="" />
</p>
<p>
A VTOL CB sensor does the same thing, except to VTOLs assigned to it.
</p>
<h4 id="towers">Sensor towers</h4>

<p>
Sensor towers and sensor units have several major differences:
</p>
<ul>
<li class="p">A standard sensor turret has a range of 12; a standard sensor tower has a range of 16 (special sensor turrets have the same range as their tower).</li>

<li class="p">A sensor tower cannot be ordered to target something specific; they automatically target the nearest unit (except CB and VTOL CB towers).</li>
<li class="p">A sensor turret will not target anything automatically; it must be manually ordered to attack a target</li>
</ul>
<h4 id="counts">What counts as a sensor</h4>
<p>
<img src="icon/b/commandcenter.gif" alt="Command Center" style="vertical-align:middle" /> <big>=</big> <img src="icon/d/hardenedsensortower.gif" alt="Sensor Tower" style="vertical-align:middle" />

</p>
<p>
<img src="icon/d/satelliteuplinkcenter.gif" alt="Satellite Uplink Center" style="vertical-align:middle" /> <big>=</big> <img src="icon/d/widespectrumsensortower.gif" alt="Wide Spectrum Sensor Tower" style="vertical-align:middle" />
</p>
<p>
The Command Center (HQ) is also considered a standard sensor tower, while the Satellite Uplink Center is also considered a Wide Spectrum sensor tower. In addition to their usual functionality, they can also be used as the corresponding sensor tower (for instance, you can assign artillery to them).
</p>
<p>
Note that while the Uplink Center reveals the entire map, it does <em>not</em> provide sensor attack coverage over the entire map, but only within a 26-tile radius.
</p>',
		'cachedsb' => '<li><a href="#artillery">Artillery</a></li><li><a href="#sensors">Sensors</a><ul><li><a href="#spotting">Using sensors with artillery</a></li><li><a href="#cb">CB sensors</a></li><li><a href="#towers">Sensor towers</a></li><li><a href="#counts">What counts as a sensor</a></li>'
	),
	'design' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<p>
<h3>Design</h3>
You need to design new units and VTOLs if you want to overpower your enemies and get that sweet taste of victory. This aspect of the game is what makes Warzone unique in it\'s own way.</p>
<p>
<h3>Screenshots</h3>
<img src="pictures/design-1.jpg" alt="" /><br>
1: Designing a new unit
</p>
<p>
<img src="pictures/design-2.jpg" alt="" /><br>
2: The unit being designed
</p>
<p>

<h3> Designing a unit </h3>
To make a new unit, select the Design icon in the Command Panel. This will make two columns appear on the left of the screen. To make a new design, select the green body. To select another unit to edit, just click it.</p>

<p>
Designing a new unit is simple. Its a three-step procedure: selecting a body, a propulsion system, and a turret. The three picked will result in a new unit.</p>
<h3>More screenshots</h3>
<p>
<img src="pictures/design.gif" alt="" /><br>
</p>
<p>
Clockwise, from top left: Select a body, propulsion type, turret, and closing the menu.</p>

<p>
<h3> Designing the unit </h3>
When a new unit is started, a list of bodies will appear on the right, with a green outline of a body in the centre. A two-column body list will appear on the right. Select one to move on to the next section  the propulsion type. Select a type and move on to the turret. There are two types of turrets, weapons and systems. Both are defined at the top of the two-column  by buttons  you can switch by clicking the respective button. Select a turret, and youre done.</p>
<p>
<img src="pictures/design-3.jpg" alt="" /><br>
</p>
<p>
<h3> Another set of screenshots </h3>
The top half of the Design (minus completed designs)</p>

<p>

1: The name of a unit. You can click this and change it by typing.<br>
2: Click this to change a body of a design.<br>
3: Click this to change a propulsion type of a design.<br>
4: Click this to change a turret of a design.<br>
5: Click this to delete the currently selected design (only works with completed designs)<br>
6: Power required to make the unit<br>
7: Hit points the unit has<br>
8: Select the System turrets (turret only, normal units only)<br>

9: Select the Weapon turrets (turret only, normal units only)</p>
<p>
<img src="pictures/image37.jpg" alt="" /><br>
</p>
<p>
10: How fast the unit moves over roads<br>
11: How fast the unit moves off-road<br>
12: How fast the unit moves over water<br>
13: Weight of the unit (affects the speed and durability of the unit)</p>',
		'title' => 'Design',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Design</strong>',
		'cachedsb' => ''
	),
	'basics' => array(
		'autogen' => TRUE,
		'text' => '<h3 id="basics">Basics</h3>

<p>
This is an introduction for complete beginners to Warzone. Much of this can be learned from the Tutorial, although we go into a bit more detail here.
</p>
<ul class="nav">
<li><a href="gettingstarted">Getting started</a></li>
<li><a href="interface">Interface</a></li>
<li><a href="camera">Controlling the camera</a></li>
<li><a href="minimap">Minimap</a></li>
<li><a href="power">Power</a></li>
<li><a href="orderingunits">Ordering units</a></li>
<li><a href="orderingvtols">Ordering VTOLs</a></li>

<li><a href="commandpanel">Command panel</a></li>
<li><a href="manufacture"> &raquo; Manufacture</a></li>
<li><a href="research"> &raquo; Research</a></li>
<li><a href="build"> &raquo; Build</a></li>
<li><a href="design"> &raquo; Design</a></li>

<li><a href="intelligence"> &raquo; Intelligence</a></li>
<li><a href="commanders"> &raquo; Commanders</a></li>
<li><a href="sensors">Sensors and artillery</a></li>
<li><a href="transports">Transports</a></li>
</ul>',
		'title' => 'Basics',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Basics</strong>',
		'cachedsb' => '<li><a href="#basics">Basics</a>'
	),
	'rankings' => array(
		'autogen' => TRUE,
		'text' => '<p>

<em>See also:</em> <a href="experience">Unit experience</a>
</p>
<h3 id="rankings">Multiplayer rankings</h3>

<p>
Ever notice the stars and medals next to a player\'s name in the multiplayer screen? Here\'s how to get them.
</p>
<p>
If you have played 4 or fewer games, you will have a <img src="images/icons/pacifier.gif" alt="" /> (pacifier), and no other stars. Otherwise:
</p>
<h4 id="top">Top star</h4>

<table class="mpad" style="width: 260px;">
<tr>
<th class="l nb" width="55%"></th><th class="c" width="45%">Droids killed</th>
</tr>
<tr><td class="l"><img src="images/icons/star1.gif" alt="" /> Bronze</td><td class="c">150</td></tr>

<tr><td class="l"><img src="images/icons/star2.gif" alt="" /> Silver</td><td class="c">300</td></tr>
<tr><td class="l"><img src="images/icons/star3.gif" alt="" /> Gold</td><td class="c">600</td></tr>

</table>
<h4 id="middle">Middle star</h4>
<table class="mpad" style="width: 260px;">
<tr>
<th class="l nb" width="55%"></th><th class="c" width="45%">Games played</th>
</tr>
<tr><td class="l"><img src="images/icons/star1.gif" alt="" /> Bronze</td><td class="c">50</td></tr>

<tr><td class="l"><img src="images/icons/star2.gif" alt="" /> Silver</td><td class="c">100</td></tr>

<tr><td class="l"><img src="images/icons/star3.gif" alt="" /> Gold</td><td class="c">200</td></tr>
</table>
<h4 id="bottom">Bottom star</h4>
<table class="mpad" style="width: 260px;">
<tr>
<th class="l nb" width="55%"></th><th class="c" width="45%">Games won</th>
</tr>
<tr><td class="l"><img src="images/icons/star1.gif" alt="" /> Bronze</td><td class="c">10</td></tr>

<tr><td class="l"><img src="images/icons/star2.gif" alt="" /> Silver</td><td class="c">40</td></tr>
<tr><td class="l"><img src="images/icons/star3.gif" alt="" /> Gold</td><td class="c">80</td></tr>
</table>
<h4 id="medal">Medal</h4>
<table class="mpad" style="width: 377px;">
<tr>
<th class="l nb" width="38%"></th><th class="c" width="31%">Games won</th><th class="c" width="31%">Win:loss&nbsp;ratio</th>

</tr>
<tr><td class="l"><img src="images/icons/medal1.gif" alt="" /> Silver chevron</td><td class="c">6</td><td class="c">2:1</td></tr>
<tr><td class="l"><img src="images/icons/medal2.gif" alt="" /> Double chevron</td><td class="c">12</td><td class="c">4:1</td></tr>
<tr><td class="l"><img src="images/icons/medal3.gif" alt="" /> Gold star</td><td class="c">24</td><td class="c">8:1</td></tr>

</table>',
		'title' => 'Multiplayer rankings',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Multiplayer rankings</strong>',
		'cachedsb' => '<li><a href="#rankings">Multiplayer rankings</a><ul><li><a href="#top">Top star</a></li><li><a href="#middle">Middle star</a></li><li><a href="#bottom">Bottom star</a></li><li><a href="#medal">Medal</a></li>'
	),
	'story' => array(
		'autogen' => TRUE,
		'text' => '<script type="text/javascript" src="images/swfobject.js"></script>
<div id="player" class="p">&nbsp;</div>
<script type="text/javascript">
<!--
      var so = false;
      var size = -1;
      function resizemovie(nsize)
      {
        if (size == nsize) return false;
        var w=320, h=260;
        switch (nsize)
        {
        case 1:
		w=640; h=500;
		break;
        }
        so = new SWFObject(\'images/flvplayer.swf\',\'single\',\'\'+w,\'\'+h,\'7\');
        so.addParam("allowfullscreen","true");
        so.addVariable("file","devastation.flv");
        so.addVariable("image","images/devastation.jpg");
        so.addVariable("backcolor","0x5D91DA");
        so.addVariable("frontcolor","0xD9E1F6");
        so.addVariable("lightcolor","0xFFFFFF");
        so.write(\'player\');
        //if (size >= 0) document.getElementById(\'size\'+size).className = \'nsel\';
        //size = nsize;
        //document.getElementById(\'size\'+size).className = \'sel\';
        //document.getElementById(\'size\'+size).blur();
      }
      resizemovie(1);
//-->
</script>

<h3 id="story">Story</h3>

<p>
In the late 21st century, NASDA (the North American Strategic Defense Agency) developed and deployed a massive missile defense system, including a network of nuclear-equipped satellites and ground-based launch sites. However, during a routine maintenance check, something went terribly wrong...
</p>
<blockquote><p>"The Collapse came fast and hard. Following a technical error in the satellite defense system, nuclear warheads were fired at Washington, Beijing and Moscow. Minutes later, ground based sites fired in response to the launch. Millions died as nuclear firestorms wiped out the world\'s cities. Billions more died as plagues and epidemics swept away what remained of civilization. Less than a million people survived the Collapse. Earth broke into hundreds of small scavenger bands battling each other for the remnants of the former civilization. Only a few had the vision to attempt to rebuild a new world from the ashes."</p></blockquote>
<p>

The player (referred to as "the Commander") is part of a group of survivors that seeks shelter in a military base in the Rocky Mountains. They emerge from the base with the goal of rebuilding the world, adopting the name "The Project".
</p>
<p>
The Project dispatches three teams with the objective of reclaiming artifacts, thus allowing the research and application of pre-Collapse technologies. Team Alpha is sent to an Arizona desert location southeast of Project HQ. Beta team is sent to the remains of Chicago. Gamma team is sent into the northern Rockies in Colorado.
</p>
<p>
<em>See also:</em> <a href="walkthrough">Walkthrough</a>

</p>
<h4 id="cam1">Campaign One</h4>
<img src="pictures/scavengers.jpg" alt="" style="float:left;margin-right:10px;" />
<p>
In Campaign One, the Commander accompanies and commands Team Alpha in Arizona. Team Alpha\'s primary objective is to find and recover the "Synaptic Link" technology, which is later explained to allow a neural interface between man and machine, and thus the construction of cyborg infantry. Secondary objectives include the recovery of other artifacts and technology, and the elimination of hostiles.
</p>

<p>
The "Scavengers" are the first hostile race to be encountered. Weak but numerous, scavengers provide a small challenge. As technologies are recovered from the scavengers, the Project encounters the "New Paradigm". This faction is hostile to the Project, and possesses superior technology.
</p>
<p>
A transmission to the New Paradigm is intercepted by the Project and it is apparent that the New Paradigm is following orders by some entity called "Nexus". The Project eventually chases the New Paradigm to their home base. As the last standing base of the New Paradigm is eradicated, Team Beta sends a distress signal and informs Team Alpha that they are under attack and need reinforcements. Team Alpha loads reinforcements on transport bound for Beta Base, and Campaign One ends.
</p>
<h4 id="cam2">Campaign Two</h4>
<img src="pictures/collective.jpg" alt="" style="float:left;margin-right:10px;" />

<p>
In Campaign Two, the commander arrives at and takes control of Beta Base in the ruins of Chicago. After fending off a fierce attack by an unnamed enemy, Project HQ informs the commander that the primary objective of Team Beta is to recover <a href="r/vtolpropulsion"><abbr title="Vertical Take-Off and Landing">VTOL</a></a> technology from before the Collapse.
</p>
<p>
It is discovered that Team Beta\'s attackers call themselves "The Collective" and constantly attempt to attack and destroy Beta team. As attacks increase in strength, the commander is also sent to destroy missile bases in the area. Though these are successfully destroyed, Project HQ detects a missile launch from near the Rocky Mountains area that soon hits Alpha Base. Suspecting a launch aimed at Beta Base, The Project orders an evacuation of Beta Base.

</p>
<p>
As Team Beta prepares to evacuate Beta Base, the Collective launches a massive attack on Beta Base, unaware of the impending nuclear attack. The Project races to evacuate as many troops as possible while defending against the Collective\'s attack. As Beta Base is destroyed and the evacuees head off to meet Team Gamma, Campaign Two ends.
</p>
<h4 id="cam3">Campaign Three</h4>
<img src="pictures/nexus.jpg" alt="" style="float:left;margin-right:10px;" />
<p>
Campaign Three begins with the commander and his forces landing in an unoccupied area near Gamma Base. After setting up a base, the commander is attacked by Nexus forces. Further, the commander discovers that Nexus possesses technology capable of taking over control of Project units and destroying Project structures by hacking into their computer systems.

</p>
<p>
Soon, Gamma Base sends out a distress call requesting relief from attacks by Nexus. After fighting past Nexus forces to get to Gamma Base, Nexus reveals that they have completely taken over Gamma Base, and the Project is forced to destroy it.
</p>
<p>
As this happens, Nexus explains its history. It had a military contract to develop the synaptic link technology, but after years of research and little progress, the Synaptic Link project is shut down. The leader of the program, Dr. Reed, hacked into NASDA and takes revenge by causing the Collapse. He plants his consciousness into a virus called the Nexus Intruder Program.
</p>
<p>

Campaign Three continues with a massive escalation in conflict. The Project learns that Nexus has gained control of a missile base in the Rocky Mountains region, and attacks it. Although the attack is successful and the facility destroyed, the Nexus sets the missiles to detonate in their silos and the commander races to find shelter from the impending impact.
</p>
<p>
After the explosion, the commander returns to base, and receives a distress call from the survivors of the earlier attack on Alpha Base. Once rescued and found to be free of Nexus absorption, Team Alpha reveals a small base they constructed and gives control over to the commander.
</p>
<p>
Nexus then announces that it has gained control of the laser-equipped satellites and begins using them to fire upon the Project\'s forces. Fortunately, the orbits of the satellites are unstable, so the firing is inaccurate. Project HQ declares that these satellites must be eliminated before they compromise the Project. Another nearby missile base is located and captured, but Nexus has stabilized the satellites\' orbits and declares that firing will be precise and deadly. As Project researches race to crack the missile launch codes, Nexus laser satellites and ground forces unrelentingly attack Team Gamma.
</p>

<p>
The Project finally cracks the missile launch codes and launches missiles destroying Nexus\' laser satellites. With the laser satellites gone, the Project launches a final attack on Nexus headquarters.
</p>
<h3 id="timeline">Timeline</h3>
<ul>
<li><p>2050: NATO alliance collapses in face of growing nationalism and unrest in Europe.</p></li>

<li><p>2075: Nationalist unrest in Eastern Europe and Asia leads to nuclear attacks by terrorists.</p></li>

<li><p>2075: Synaptic Link research begins.</p></li>

<li><p>2077: Mongolia attacks China.</p></li>

<li><p>2079: Korea allies with Mongolia.</p></li>

<li><p>2080: Synaptic link patented. First cyborg soldiers developed.</p></li>

<li><p>2080: NASDA (the North American Strategic Defense Agency) formed to protect North America from nuclear attacks.</p></li>

<li><p>2081: NASDA begins building a satellite defense array.</p></li>

<li><p>2082: The NASDA satellite system comes on line.</p></li>

<li><p>2085: During routine testing the NASDA system malfunctions and launches nuclear strikes against all major cities in the world. The target countries respond with nuclear counter strikes.  NASDA fails to defend against incoming missiles.</p></li>

<li><p>2086: Nuclear Winter begins. Widespread plagues and famines kill billions of people. Civilization ends. NASDA systems lie dormant following electromagnetic pulses. A group of survivors discover an abandoned subterranean military base. They set up home there and begin The Project.</p></li>

<li><p>2099: The Project emerges from it\'s military base.</p></li>

<li><p>2100: The Project begins its search for pre-Collapse technologies.</p></li>

</ul>
',
		'title' => 'Story',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Story</strong>',
		'cachedsb' => '<li><a href="#story">Story</a><ul><li><a href="#cam1">Campaign One</a></li><li><a href="#cam2">Campaign Two</a></li><li><a href="#cam3">Campaign Three</a></li></ul></li><li><a href="#timeline">Timeline</a>'
	),
	'experience' => array(
		'autogen' => TRUE,
		'title' => 'Unit experience',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Unit experience</strong>',
		'text' => '<p><em>See also:</em> <a href="rankings">Multiplayer rankings</a></p>

<h3 id="experience">Unit experience table</h3>
<table class="mpad">
<tr>
<th class="l nb" width="22%"></th><th class="c" width="15%">Kills&nbsp;required<br /><span class="small">(Normal unit)</span></th><th class="c" width="15%">Kills&nbsp;required<br /><span class="small">(Commander)</span></th><th width="12%">Speed</th><th width="12%">Accuracy</th><th width="12%">Enemy<br />Accuracy</th><th width="12%">Damage<br />Taken</th>

</tr>
<tr>
<td class="l"><img src="images/icons/blank.gif" alt="" /> Rookie</td><td class="c">0</td><td class="c">0</td><td class="c">+0%</td><td class="c">+0%</td><td class="c">&minus;0%</td><td class="c">&minus;0%</td>
</tr>
<tr>
<td class="l"><img src="images/icons/rank1.gif" alt="" /> Green</td><td class="c">4</td><td class="c">16</td><td class="c">+5%</td><td class="c">+5%</td><td class="c">&minus;5%</td><td class="c">&minus;6%</td>

</tr>
<tr>
<td class="l"><img src="images/icons/rank2.gif" alt="" /> Trained</td><td class="c">8</td><td class="c">32</td><td class="c">+10%</td><td class="c">+10%</td><td class="c">&minus;10%</td><td class="c">&minus;12%</td>
</tr>
<tr>
<td class="l"><img src="images/icons/rank3.gif" alt="" /> Regular</td><td class="c">16</td><td class="c">64</td><td class="c">+15%</td><td class="c">+15%</td><td class="c">&minus;15%</td><td class="c">&minus;18%</td>

</tr>
<tr>
<td class="l"><img src="images/icons/rank4.gif" alt="" /> Professional</td><td class="c">32</td><td class="c">128</td><td class="c">+20%</td><td class="c">+20%</td><td class="c">&minus;20%</td><td class="c">&minus;24%</td>
</tr>
<tr>
<td class="l"><img src="images/icons/rank5.gif" alt="" /> Veteran</td><td class="c">64</td><td class="c">256</td><td class="c">+25%</td><td class="c">+25%</td><td class="c">&minus;25%</td><td class="c">&minus;30%</td>

</tr>
<tr>
<td class="l"><img src="images/icons/rank6.gif" alt="" /> Elite</td><td class="c">128</td><td class="c">512</td><td class="c">+30%</td><td class="c">+30%</td><td class="c">&minus;30%</td><td class="c">&minus;36%</td>
</tr>
<tr>
<td class="l"><img src="images/icons/rank7.gif" alt="" /> Special</td><td class="c">256</td><td class="c">1024</td><td class="c">+35%</td><td class="c">+35%</td><td class="c">&minus;35%</td><td class="c">&minus;42%</td>

</tr>
<tr>
<td class="l"><img src="images/icons/rank8.gif" alt="" /> Hero</td><td class="c">512</td><td class="c">2048</td><td class="c">+40%</td><td class="c">+40%</td><td class="c">&minus;40%</td><td class="c">&minus;48%</td>
</tr>
</table>
<p>
If you recycle an experienced unit, in addition to gaining 50% of its price back, the next unit you manufacture will gain its experience. This doesn\'t have to be one at a time: You can recycle an army, then later manufacture a new army with the old army\'s experience.
</p>

<p>

Note that your "saved" experience will <em>not</em> be kept across campaign missions &ndash; if you do not manufacture new units before you win the current mission, the experience will be lost.
</p>
<h3 id="commanders">Commanders</h3>
<p>
<a href="commanders">Commanders</a> increase the experience bonuses of units they command.
</p>
<h4 id="campaign">Campaign</h4>
<p>
If a unit has a commander, it gets bonuses as if its level were the maximum of its own level, or its commander\'s level.
</p>
<p>
For instance, if a Regular unit has a Professional commander, it gets bonuses as if it were a Professional unit. If a Special unit has a Professional commander, however, it would still get bonuses as a Special unit.
</p>
<h4 id="multiplayer">Multiplayer</h4>
<p>
If a unit has a commander, its effective level is the maximum of its own level, or one level higher than its commander\'s level. Commanders also only need half as many kills as they do in campaign (the table).
</p>',
		'cachedsb' => '<li><a href="#experience">Unit experience table</a></li><li><a href="#commanders">Commanders</a><ul><li><a href="#campaign">Campaign</a></li><li><a href="#multiplayer">Multiplayer</a></li>'
	),
	'keyboard' => array(
		'autogen' => TRUE,
		'text' => '<p>
These are the default keyboard shortcuts. If you have customized your key mapping, your shortcuts may be different.
</p>

<h3 id="game">Game</h3>

<table class="list">
<tr><th><kbd>Esc</kbd></th><td>Pause/Menu</td></tr>
<tr><th><kbd>F1</kbd></th><td><a href="manufacture">Manufacture</a></td></tr>
<tr><th><kbd>F2</kbd></th><td><a href="research">Research</a></td></tr>
<tr><th><kbd>F3</kbd></th><td><a href="build">Build</a></td></tr>
<tr><th><kbd>F4</kbd></th><td><a href="design">Design</a></td></tr>
<tr><th><kbd>F5</kbd></th><td><a href="intelligence">Intelligence</a></td></tr>
<tr><th><kbd>F6</kbd></th><td><a href="commanders">Commanders</a></td></tr>
<tr><th><kbd>`</kbd></th><td>Open/close <a href="interface">messages at top</a></td></tr>
</table>

<h3 id="comm">Multiplayer communication</h3>

<table class="list">
<tr><th><kbd>Enter</kbd></th><td>Send message</td></tr>
<tr><th><kbd class="lkey">Alt</kbd>+<kbd>H</kbd></th><td>Drop beacon</td></tr>
</table>

<h3 id="selection">Unit selection</h3>

<h4 id="groups">Groups</h4>
<table class="list">
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd><em>[number]</em></kbd></th><td>Assign <a href="orderingunits#groups">group</a> <em>[number]</em></td></tr>
<tr><th><kbd><em>[number]</em></kbd></th><td>Select <a href="orderingunits#groups">group</a> <em>[number]</em></th></tr>
<tr><th><kbd class="lkey">Alt</kbd>+<kbd><em>[number]</em></kbd></th><td>Select <a href="commanders">commander</a> <em>[number]</em></td></tr>
</table>
<h4 id="type">By type</h4>
<table class="list">
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>U</kbd></th><td>Select all <u>u</u>nits</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>Z</kbd></th><td>Select all similar units</tr>
<tr><th><span class="dblclick"><span class="click">double-click</span></span></th><td>Select all similar units</tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>S</kbd></th><td>Select all units on <u>s</u>creen</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>D</kbd></th><td>Select all heavily <u>d</u>amaged units</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>A</kbd></th><td>Select all <u>a</u>ttack units (units with weapons)</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>V</kbd></th><td>Select all <u>V</u>TOLs</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>H</kbd></th><td>Select all <u>h</u>over units</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>W</kbd></th><td>Select all <u>w</u>heeled units</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>F</kbd></th><td>Select all hal<u>f</u>-tracked units</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>T</kbd></th><td>Select all <u>t</u>racked units</td></tr>
</table>

<h3 id="orders">Unit orders</h3>

<table class="list">
<tr><th><kbd class="lkey">Ctrl</kbd>+<span class="click">click</span></th><td>Queue order *</td></tr>
<tr><th><span class="click">NUM</span><kbd>0</kbd></th><td>Open <a href="orderingunits#ordersmenu">orders menu</a></td></tr>
<tr><th><span class="click">right-click</span></th><td>Open <a href="orderingunits#ordersmenu">orders menu</a></td></tr>
<tr><th><kbd>/</kbd></th><td>Do or Die! (Do not retreat automatically)</td></tr>
<tr><th><kbd>.</kbd></th><td>Retreat at Heavy Damage</td></tr>
<tr><th><kbd>,</kbd></th><td>Retreat at Medium Damage</td></tr>
<tr><th><kbd>F</kbd></th><td>Fire at Will</td></tr>
<tr><th><kbd>E</kbd></th><td>Return Fire</td></tr>
<tr><th><kbd>C</kbd></th><td>Hold Fire</td></tr>
<tr><th><kbd>S</kbd></th><td>Hold Position</td></tr>
<tr><th><kbd>P</kbd></th><td>Pursue</td></tr>
<tr><th><kbd>Q</kbd></th><td>Patrol</td></tr>
<tr><th><kbd>I</kbd></th><td>Optimum Range</td></tr>
<tr><th><kbd>U</kbd></th><td>Long Range</td></tr>
<tr><th><kbd>R</kbd></th><td>Return for Repair</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>R</kbd></th><td>Return for Recycling</td></tr>
</table>
<p>
* "Queue order" means that when you <kbd class="lkey">Ctrl</kbd>+<span class="click">click</span>, the unit will do what it would do if you had clicked, but it will do it <em>after</em> it\'s finished what it\'s currently doing. You can hold down <kbd class="lkey">Ctrl</kbd> and tell the unit to do a whole bunch of things, and it will do them in order.
</p>

<h3 id="control">Game control</h3>

<table class="list">
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>=</kbd></th><td>Increase game speed</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>&minus;</kbd></th><td>Decrease game speed</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd class="lkey">Alt</kbd>+<span class="click">scroll up</span></th><td>Increase game speed</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd class="lkey">Alt</kbd>+<span class="click">scroll down</span></th><td>Decrease game speed</td></tr>
<tr><th><span class="click">NUM</span><kbd>.</kbd></th><td>Toggle sound</td></tr>
</table>

<h3 id="view">View</h3>

<table class="list">
<tr><th><kbd>B</kbd></th><td>Center view on Command Center</td></tr>
<tr><th><kbd>F12</kbd></th><td>View location of previous message</td></tr>
</table>
<h4 id="cam">Camera control</h4>
<table class="list">
<tr><th><span class="click">scroll up</span></th><td>Zoom in</td></tr>
<tr><th><span class="click">scroll down</span></th><td>Zoom out</td></tr>
<tr><th><span class="click">NUM</span><kbd>+</th><td>Zoom in</td></tr>
<tr><th><span class="click">NUM</span><kbd>-</th><td>Zoom out</td></tr>
<tr><th><kbd>Backspace</kbd></th><td>Snap (rotate) view to North</td></tr>
<tr><th><span class="click">NUM</span><kbd>8</kbd></th><td>Pitch back (rotate up)</td></tr>
<tr><th><span class="click">NUM</span><kbd>2</kbd></th><td>Pitch forward (rotate down)</td></tr>
<tr><th><span class="click">NUM</span><kbd>5</kbd></th><td>Reset pitch (reset vertical rotation)</td></tr>
<tr><th><span class="click">NUM</span><kbd>4</kbd></th><td>Rotate left</td></tr>
<tr><th><span class="click">NUM</span><kbd>6</kbd></th><td>Rotate right</td></tr>
<tr><th><kbd><em>space</em></kbd></th><td>Tracking camera (follow selected unit)</td></tr>
</table>

<h3 id="interface">Interface</h3>

<table class="list">
<tr><th><kbd>Z</kbd></th><td>Toggle sensor display</td></tr>
<tr><th><kbd>F10</kbd></th><td>Take screenshot</td></tr>
<tr><th><kbd class="lkey">Shift</kbd>+<kbd>Tab</kbd></th><td>Toggle radar colors</td></tr>
<tr><th><kbd class="lkey">Ctrl</kbd>+<kbd>Tab</kbd></th><td>Toggle radar terrain</td></tr>
<tr><th><kbd>Tab</kbd></th><td>Hide/show interface</td></tr>
</table>
',
		'title' => 'Keyboard shortcuts',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Keyboard shortcuts</strong>',
		'cachedsb' => '<li><a href="#game">Game</a></li><li><a href="#comm">Multiplayer communication</a></li><li><a href="#selection">Unit selection</a><ul><li><a href="#groups">Groups</a></li><li><a href="#type">By type</a></li></ul></li><li><a href="#orders">Unit orders</a></li><li><a href="#control">Game control</a></li><li><a href="#view">View</a><ul><li><a href="#cam">Camera control</a></li></ul></li><li><a href="#interface">Interface</a>'
	),
	'rebalance' => array(
		'autogen' => TRUE,
		'text' => '<p>

The Rebalance Mod is a mod of Warzone 2100 written by Zarel. It aims to improve the balance of Warzone.
</p>
<h3><a name="download">Download</a></h3>
<p>
Rebalance Mod for 2.2 or higher:
</p>
<ul class="nav"><li>
<a href="files/rebalance_0.6.0.wz"><em><strong>Download</strong></em> rebalance_0.6.0.wz</a>
</li></ul>
<p>
Rebalance Mod for 2.1:
</p>
<ul class="nav"><li>

<a href="files/rebalance_0.5.2.wz"><em><strong>Download</strong></em> rebalance_0.5.2.wz</a>
</li></ul>
<h3><a name="install">Installing</a></h3>
<p>
<s>In Windows, the easiest way to install a multiplay mod is to move it into:</s>
</p>
<p>
<s><code>C:/Program Files/Warzone 2100/mods/multiplay/autoload/<span class="grey">rebalance_0.5.1.wz</span></code></s>
</p>
<p>

<s>(You may have to create the "autoload" folder in "multiplay" first.)</s>
</p>
<p>
<s>To temporarily disable a multiplay mod, move it out to:</s>
</p>
<p>
<s><code>C:/Program Files/Warzone 2100/mods/multiplay/<span class="grey">rebalance_0.5.1.wz</span></code></s>
</p>
<p>
Refer to the <a href="http://wz2100.net/faq">FAQ</a> for installation information.

</p>
<p>
In other platforms, mods must be enabled with <a href="http://developer.wz2100.net/wiki/CommandLineOptions">command-line options</a>.
</p>
<h3><a name="chglog">Changelog</a></h3>
<ul>
<li><p>
<strong>0.6.0</strong> - 2009 Oct 11<br />
<br />
- NO LONGER SUPPORTS 2.1<br />

- Multi-turret no longer available for standard heavy bodies<br />
- Most projectiles 1.5x faster. Should reduce sync problems<br />
<br />
<em>Renames:</em><br />
- Mini-Rocket Artillery renamed Mini-Rocket Array<br />
- MRL Emplacement renamed Mini-Rocket Battery<br />
- Angel Missile renamed Seraph Missile Array (should eliminate the "angel missile won\'t fire!" complaints)<br />
- Angel Missile Battery renamed Short-Range Missile Battery<br />
<br />
<em>VTOL balance:</em><br />

- Hurricane damage increased 40 -&gt; 50, splash increased 10 -&gt; 30<br />
- Cyclone damage increased 50 -&gt; 70, splash increased 40 -&gt; 60<br />
- Whirlwind damage increased 50 -&gt; 65, splash increased 30 -&gt; 50<br />

- Avenger and Vindicator damage increased 320 -&gt; 350, accuracy increased 60%-70% -&gt; 70%-80%<br />
- Stormy damage increased 140 -&gt; 180<br />
- All lasers now have 80%-80% accuracy<br />
- Plasmite Bomb weight increased 8000 -&gt; 12000<br />
- Mini-pod can hit air<br />

<br />
<em>Late-game stalemate-busting:</em><br />
- Artillery to hover multiplier decreased from 110% to 100%<br />
- Artillery to tracks multiplier decreased from 65% to 50%<br />
- Artillery to half-tracks multiplier decreased from 80% to 70%<br />
- Artillery to wheels multiplier decreased from 95% to 90%<br />
- Anti-tank to hover multiplier decreased from 100% to 90%<br />
- AP to hard multiplier increased from 45% to 50%<br />
- Seraph (see "Renames") range increased from 5-11 to 5-14<br />

<br />
<em>Truck rush prevention:</em><br />
- Command Center must be built before MG tower can be researched<br />
- Truck HP decreased 50 -&gt; 25<br />
- Truck weight increased 600 -&gt; 800<br />
<br />
<em>Structure research price cuts:</em><br />
- Inferno bunker research price 150 -&gt; 125<br />

- Plasmite bunker research price 150 -&gt; 125<br />
</p></li>
<li><p>
<strong>0.5.1</strong> - 2009 May 7<br />
<br />
- Fixed crash when starting in T2 or T3.
</p></li>
<li><p>
<strong>0.5.2</strong> - 2009 July 20<br />

<br />
- Updated to make it compatible with version 2.2.
</p></li>
<li><p>
<strong>0.5.1</strong> - 2009 May 7<br />
<br />
- Fixed crash when starting in T2 or T3.
</p></li>
<li><p>
<strong>0.5.0</strong> - 2009 May 7<br />
<br />

- Heavy VTOL bombs made lighter, light VTOL bombs made heavier.<br />
- VTOL bomb accuracy upgrades changed to damage upgrades.<br />
- Angel Missile stronger, Archangel Missile weaker, both fewer prereqs.<br />
- Damage upgrades now also upgrade splash and burn damage.<br />
- Needle Gun slightly stronger. Still not actually better than HPV.<br />
- Rails now penetrating weapons. In practice, this shouldn\'t make much difference.<br />
- Factory, Cyborg factory, and VTOL factory upgrades combined; now only 4 upgrades instead of 6-9 each.<br />
- Repair facility upgrades condensed, now only 3 upgrades instead of 6.<br />

- Artillery weapons do less damage to tanks, but more to walls.<br />

- MG damage back down to original levels. The extra APDSB MG Bullets in the early game does plenty to compensate.<br />
- VTOL HP actually makes sense now.<br />
- Cannon HP increased a bit more.<br />
- Stormy nerfed.<br />
- All AA weapons have full fire-on-move.
</p></li>
<li><p>
<strong>0.4.2</strong> - 2009 Apr 14<br />

<br />
- VTOLs partially fixed. Feedback welcome.<br />

- Cannons and rails have more HP.<br />
- Assault/Twin Assault Cannon slightly weakened (still much stronger than 1.10 and 2.1; stop worrying). TK also weakened.<br />
- All weapons that do splash damage will always do splash damage, none of this 25% chance of doing splash damage b.s.<br />
- Rails do splash damage now, and are worth upgrading to now.<br />
- Angel Missile! Now a viable replacement for MRL!<br />
- Heavy cyborgs are slightly lighter. Should be able to move now.<br />
- Truck builds slower. Truck rushes aren\'t nearly so effective now.<br />

- The rest of the structure prereqs are gone.<br />
- Research tree reworked. Rockets/missiles have an easier time upgrading now. Pulse Laser isn\'t hidden behind GTE anymore.<br />

</p></li>
<li><p>
<strong>0.4.1</strong> - 2009 Mar 30<br />
<br />
- Howitzers, incendiary artillery, and T3 weapons strengthened<br />
- All weapons have same damage upgrade progression (25%) and one of two rate upgrade progressions (10% or 15%). This is down from an average of 30% and 20%, respectively. This is intended to make weapon choice matter more.<br />
- Cyborgs further balanced. Not only should they be usable, they should be fairly well balanced within themselves now (Next: VTOLs!)<br />

- Ranges rounded off to multiples half-tiles, except the Wide Spectrum Sensor Turret, which is still 17.7 tiles.
</p></li>
<li><p>
<strong>0.4.0</strong> - 2009 Mar 23<br />

<br />
- Cyborgs no longer have to be researched.<br />
- Cyborg factory only requires Engineering now.<br />
- Trading up weapons offers more of a benefit.<br />
- Weapon multipliers massively rearranged.<br />

- Cannons/Rails split from Rockets/Missiles, no longer both anti-tank.
</p></li>
<li><p>
<strong>0.3.0</strong> - 2009 Mar 7<br />
<br />

- Pulse Laser replaces Flashlight, instead of Heavy Laser.<br />
- Flashlight Hardpoint replaced with Pulse Laser Hardpoint.<br />
- Pulse Laser Emplacement replaced with Pulse Laser Tower.<br />
- Body prices updated to make more sense.<br />

- Some graphics replaced to make more sense.<br />
</p></li>
<li><p>
<strong>0.2.4</strong> - 2009 Feb 20<br />
<br />

- Structures reworked so none of them have more than 2x the amount of HP they had in 1.10.
</p></li>
<li><p>
<strong>0.2.3</strong> - 2009 Feb 17<br />

<br />
- Lancer bunker replaced with lancer tower.<br />
- Flamers strengthened.
</p></li>
<li><p>
<strong>0.2.2</strong> - 2009 Feb 13<br />

<br />
- After a balance test, lancers weakened, cannons strengthened.
</p></li>
<li><p>
<strong>0.2.1</strong> - 2009 Feb 6<br />

<br />
- 2.1 support is back. It was the lack of naval unit support that made it crash.<br />
- Tweaked multipliers some more.<br />
- Pulse laser tower removed until I figure out a way to fit it in.
</p></li>
<li><p>
<strong>0.2</strong> - 2009 Jan 19<br />

<br />
I haven\'t been keeping track of specific changes. Suffice to say it does these main things:<br />
- Mediate 2.1\'s balance with 1.10\'s balance.<br />

- Ensure no weapon is useless.<br />
- Have cycles of strengths/weaknesses ("Rock-paper-scissors" style balancing)<br />
- Remove inconsistencies.
</p></li>
<li><p>
<strong>0.1.1</strong> - 2008 Nov 23<br />
<br />

<em>Fixes:</em><br />
- Much smaller<br />

- Restored compatibility with r6437 and most future changes
</p></li>
<li><p>
<strong>0.1</strong><br />
<br />
<em>Research balance (Mediate 2.1 with 1.10):</em><br />
- Lancer has fewer prereqs (but more than 1.10)<br />
<br />
<em>Research balance (other):</em><br />

- Heavy Cannon requires APFSDS Cannon Shells<br />
- Machinegun upgrades are back through Depleted Uranium MG Bullets<br />

- Rocket upgrades are 20% instead of 10%<br />
- No structure costs more than half its prerequisite turret to research<br />
- Stormbringer easier to get<br />
- Laser prereqs rearranged a lot<br />
- Advanced Missile Warhead no long prereqs Avenger SAM<br />
<br />
<em>New Technology:</em><br />

- Added Sensor Upgrade Mk3<br />
<br />

<em>Weapon balance (Mediate 2.1 with 1.10):</em><br />
- Assault guns and twin assault guns are slightly more powerful (but less than 1.10)<br />
- Mini-pods, rockets, and missiles have less HP (but more than 1.10)<br />
- Mini-pods do slightly less damage (but more than 1.10)<br />
- Rockets and missiles do more damage (but less than 1.10)<br />
- Ripple Rockets do less damage (but more than 1.10)<br />
- Flamers slightly nerfed (still way more powerful than 1.10)<br />

- Cannons and gausses have more HP (but less than 1.10)<br />

- Cannons do less damage (but more than 1.10)<br />
- Gauss Cannon does more damage (but less than 1.10)<br />
- Mortars do less damage (but more than 1.10)<br />
- LasSat reloads in 5 min instead of 8 (back to 1.10)<br />
<br />
<em>Weapon balance (other):</em><br />
- Howitzer HP slightly increased<br />
- Heavy Laser range slightly increased<br />

- Plasma Cannon damage slightly increased, now anti-tank<br />

- Pulse laser damage halved, ROF doubled<br />
- Stormbringer weakened<br />
- Stormbringer is now a thermal AA laser (instead of kinetic AA gun)<br />
- All lasers have very high velocity<br />
- AA guns have increased velocity<br />
- SAMs are more powerful<br />
- Phosphor, Plasmite, and Thermite bombs are now thermal<br />
- Plasmite bomb does more damage<br />

- Missile Fortress nerfed
</p></li>
</ul>
<h3><a name="license">License</a></h3>
<p xmlns:cc="http://creativecommons.org/ns#" xmlns:dct="http://purl.org/dc/terms/" xmlns:vcard="http://www.w3.org/2001/vcard-rdf/3.0#">
  <a rel="license" href="http://creativecommons.org/licenses/zero/1.0/" style="text-decoration:none;">
    <img src="http://i.creativecommons.org/l/zero/1.0/88x31.png" border="0" alt="CC0" />
  </a>
  <br />
  To the extent possible under law, <span property="dct:title">Guangcong Luo</span>

  has waived all copyright and related or neighboring rights to
  <span property="dct:title">Rebalance Mod for Warzone 2100</span>.
This work is published from
<span about="[_:publisher]" property="vcard:Country" datatype="dct:ISO3166" content="US">United States</span>.
</p>',
		'title' => 'Rebalance Mod',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Rebalance Mod</strong>',
		'cachedsb' => '<li><a href="#download">Download</a></li><li><a href="#install">Installing</a></li><li><a href="#chglog">Changelog</a></li><li><a href="#license">License</a>'
	),
	'orderingunits' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3 id="using">Using Units</h3>
<p>
Gotten used to the interface? Okay, well, time to actually use our units.
</p>
<h4 id="selecting">Selecting and moving units</h4>
<p>
To select a unit or cyborg, left click on it. Multiple units can be selected by clicking and dragging, and encasing the units in the drawn \'square\', or by holding down <span class="lkey">Ctrl</span> or <span class="lkey">Shift</span> and clicking on multiple units.
</p>

<p>
To move selected units, left click on the terrain of the map. This can also be done over black areas of the map to explore the area. To attack an enemy unit, left click on it. You can deselect a unit (or a group of units) with a right-click.
</p>
<h4 id="waypoints">Queuing and waypoints</h4>
<p>
You can set a path with waypoints, which units will visit each waypoint in order. You can also select a queue of enemies for units to attack. Hold <span class="lkey">Shift</span> or <span class="lkey">Ctrl</span> while selecting units or clicking places to move. <p> This also works for queuing construction of Oil Derricks and/or structures in a chain - hold the key down while building the structures one by one, then, when building the final structure, release the key.
</p>
<h4 id="groups">Groups of Units</h4>

<p>
To make groups of units, select the units you want and press <span class="lkey">Ctrl</span>+<span class="key">[<em>number</em>]</span> to make a group. A group of units will have a number next to it. To select a group of units you have made, press <span class="key">[<em>number</em>]</span>. Groups can also be selected by double-clicking a unit in a group. To center the camera on a group, press the <span class="key">[<em>number</em>]</span> twice.

</p>
<h4 id="defending">Defending</h4>
<p>
Click a friendly structure or truck with weapon units selected (the cursor will be a shield) and the units will move to guard it.
</p>

<h3 id="ordersmenu">Unit orders menu</h3>
<p><img src="pictures/orders.jpg" alt="" /></p>
<p>
Right-click on a unit (or select a unit and hit <span class="click">NUM</span><span class="key">0</span> on the numeric keypad), and a unit orders menu will appear above the command panel. This contains options to configure a unit\'s behavior.
</p>

<p>
Right-clicking on a factory will customize the orders of all future units that that factory produces.
</p>
<h4 id="attackrange">Attack range</h4>
<p>
<img src="pictures/orders-range.jpg" alt="" /></p>

<table class="list">
<tr>
<td class="r">Optimum Range:</td> <td>Fires at most accurate range (default)</td>
</tr>
<tr>
<td class="r">Short Range:</td> <td>Moves to short range and attacks</td>

</tr>
<tr>
<td class="r">Long Range:</td> <td>Attacks at long range</td>

</tr>
</table>
<h4 id="retreat">Retreat threshold</h4>
<p>
<img src="pictures/orders-retreathealth.jpg" alt="" />
</p>
<table class="list">
<tr>
<td class="r">Do or Die:</td> <td>Your unit will not retreat unless ordered to. (default)</td>

</tr>
<tr>
<td class="r">Retreat at Medium Damage:</td> <td>Your unit will retreat (return to repair facility, HQ, or LZ) at medium (yellow) damage </td>

</tr>
<tr>
<td class="r">Retreat at Heavy Damage:</td> <td>Your unit will retreat at heavy (red) damage</td>
</tr>
</table>
<h4 id="firing">Firing</h4>

<p>
<img src="pictures/orders-holdfire.jpg" alt="" />
</p>
<p>
Fire At Will: Fires at any enemy (default)<br />
Return Fire: Only fire if fired at<br />

Do Not Fire: Units will not fire</p>
<h4 id="movement">Movement</h4>
<p>
<img src="pictures/orders-position.jpg" alt="" />
</p>
<p>

Patrol: Moves in a circle on a position. Just click an area after selecting it.<br />
Pursue: Pursue enemy.<br />
Guard: Stay near an area or structure. (default)<br />
Hold Position: Do not move under any circumstances.
</p>
<h4 id="return">Return</h4>

<p>
<img src="pictures/orders-return.jpg" alt="" />
</p>
<p>
Return for Repair: Unit will return to a Repair Facility<br />

Return to HQ: Unit will return to Command Center or LZ (campaign)<br />
Go To Transport: Unit will go and board transport
</p>
<h4 id="recycling">Recycling</h4>
<p>
<img src="pictures/orders-recycle.jpg" alt="" />
</p>
<p>
Recycling a unit will send it to the nearest Repair Facility or Factory, and destroy it. Half the power used in making it will be refunded to you. The unit\'s experience level will be placed in the next unit that is manufactured.

</p>
<h3 id="experience">Unit experience</h3>
<p><em>See also:</em> <a href="experience">Unit experience</a></p>

<p>
Units have experience levels depending on how many kills the unit has. A higher experience level means that a unit is more accurate, moves faster and takes less damage. An icon displaying a unit\'s rank is displayed next to the unit\'s health bar.
<p>
<h3 id="hardpoints">Hardpoints and bunkers</h3>
<p>
Hardpoints, bunkers, and other defensive structures cannot be ordered to shoot directly.
</p>
<p>
However, you can assign artillery emplacements to a sensor tower. Nearby commanders with the \'indirect fire support\' option activated will also command these structures.
</p>
<h3 id="sensors">Indirect-fire units and sensors</h3>
<p><em>See:</em> <a href="sensors">Sensors and artillery</a></p>

<p class="backforward"><a href="power">&laquo; Prev</a> | <a href="orderingvtols">Next &raquo;</a></p>',
		'title' => 'Ordering Units',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Ordering Units </strong>',
		'cachedsb' => '<li><a href="#using">Using Units</a><ul><li><a href="#selecting">Selecting and moving units</a></li><li><a href="#waypoints">Queuing and waypoints</a></li><li><a href="#groups">Groups of Units</a></li><li><a href="#defending">Defending</a></li></ul></li><li><a href="#ordersmenu">Unit orders menu</a><ul><li><a href="#attackrange">Attack range</a></li><li><a href="#retreat">Retreat threshold</a></li><li><a href="#firing">Firing</a></li><li><a href="#movement">Movement</a></li><li><a href="#return">Return</a></li><li><a href="#recycling">Recycling</a></li></ul></li><li><a href="#experience">Unit experience</a></li><li><a href="#hardpoints">Hardpoints and bunkers</a></li><li><a href="#sensors">Indirect-fire units and sensors</a>'
	),
	'commanders' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3 id="commanders">Commanders</h3>
<p>
<img src="icon/w/commandturret.gif" alt="" />
</p>
<p>
Command turrets are used much like <a href="sensors">sensors</a>, except they can command any attacking unit, not just artillery. They are limited to having 6 non-artillery attacking units assigned to them at first, but this limit rises by 2 each time the commander gains a rank, which happens relatively quickly.
</p>
<p>
Command turrets provide an <a href="experience">accuracy, armor, and movement speed bonus</a> to all units assigned to them.
</p>
<p>
<img src="pictures/commanderorders.jpg" alt="" /><br>
<em>The Commanders panel. Note the similarity to the Unit Orders panel.</em>
</p>

<p>
<h4> Prerequisites </h4>
Commanders require you to research the Commander technology.</p>
<p>
<h4> Attaching </h4>

To attach a unit to a Commander, select a unit, then left-click the Commander you want to attach the unit to. A symbol will appear next to the unit to signify it is attached.</p>
<p>
<h4> Limits </h4>
Be warned, however; Commanders have a limit to the amount of direct-fire units (eg machineguns) which is affected by their own experience level. Levels are earned by the Commander reaching 2 kills, 4, 8, 16, 32, 64 and so on. Each experience level allows the Commander 2 more direct-fire units. However, a Commander can have as many indirect-fire units as it wants.</p>
<p>
<h4> Detaching </h4>
To detach a unit from a Commander, select the unit you want to detach, hold the Control key, and give the unit a new order (eg. move).</p>
<p>
<h4> Targeting a unit </h4>

You can designate a target by selecting a Commander and right-clicking a unit. This allows any attached units to have greater accuracy when firing on a targeted unit.</p><p>
<h4> Commander Unit Command Centre </h4>
A Commander Unit Command Centre is similar to a Unit Command Centre, but there are extra buttons.
</p>

<p>
<h4> Factory Assignment </h4>
<img src="pictures/commander-factory.jpg" alt="" /><br>
The Commander Factory assignment buttons
</p>
<p>
You can assign a factory to a Commander. This makes a factory manufacture units and automatically assign them to the Commanders group. To do so, bring up the Commanders menu by left-clicking the Commander and opening the Commanders menu, or right click the Commander, and click the factory NUMBER at the bottom of the Command Console. You can find a factory number by looking at the number on the factory in the Manufacture Fast Find bar. There are three rows of these numbers  the top is normal Factories, middle; Cyborg factories, bottom; VTOL factories.</p>

<p>
<h4> Going for repairs, BRB </h4>
A unit that retreats from the battle to go to a repair facility, will stay connected to its Commander group. When it is done repairing, it will return to the Commander.</p>
<p>
<h4> Indirect fire support </h4>
<img src="pictures/commander-firesupport.jpg" alt="" /><br>
The indirect fire support icon
</p>
<p>
You can assign all the indirect fire pits and emplacements to a Commanders designated target, also known as fire support. To do so, simply select a Commander, open the Commanders menu, and select the above icon. To cancel it, select the same button, or assign the fire support to another commander.</p>',
		'title' => 'Commanders',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Commanders</strong>',
		'cachedsb' => '<li><a href="#commanders">Commanders</a>'
	),
	'faq' => array(
		'autogen' => TRUE,
		'cachedsb' => ''
	),
	'campaignstrategy' => array(
		'autogen' => TRUE,
		'text' => '<p>

Before we begin our walkthrough, let\'s first go over some general strategy that will apply to all campaign missions.
</p>
<h3 id="time">1. Use all of the mission timer</h3>
<p>
All stages (save the first, the last, and the first half of Alpha 3) have a timer on them. In some stages, you\'ll find yourself wishing you had more time, and on others, you will think you had "too much". Trust me, there is never too much. Whether just letting your cash tick up, recycling-replacing your forces with new technologies, or setting up defenses at key locations (for base-missions anyway), you can use the extra time on one mission to make your life on further ones easier.
</p>
<p>
But mostly, the reason you want to prevent stages from ending is so that you can research all the techs you get in a given stage. Falling behind in this can lead to your finding out that you <em>really</em> wish you had access to something in the next stage, but you\'re still an hour\'s research away.
</p>

<h3 id="retreat">2. Retreat at X damage</h3>
<p>

Units in this game accrue experience as they shoot enemies (and commanders get it from anything their attached units shoot). <a href="experience">Experienced units</a> end up being quite a bit better than their inexperienced equivalents.
</p>
<p>
In a multiplayer game, this is usually not too useful, as most MP competitors know to specifically strike against high-experience units first; but against the AI in the campaign, having a force of heroic tanks is <em>amazing</em>.
</p>
<p>
One of the <a href="orderingunits#ordersmenu">orders you can give to your units</a> is for them to retreat if their health gets too low (50%/red, or 75%/yellow, specifically). The units with higher HP around them will protect them as they retreat. In most circumstances, Retreat at Medium Damage is the best setting.

</p>
<h3 id="save">3. Save often</h3>

<p>
Like many games, saving before doing something is a good way to make sure you don\'t do something... you regret. This game has a number of twists in it, twists that, even if you read this guide, you will find yourself wishing you had prepared for. I recommend no less than 3 save games; one you take right at the start of a stage, one that you keep saving over as the stage progresses, and one right when you start "milking" a stage\'s timer after completing the objectives. With these three handy, you should never be in a position where you find yourself saying "oh crap, I needed to start handling this half an hour ago!".
</p>
<p class="backforward"><a href="walkthrough">&laquo; Prev</a> | <a href="alpha1">Next &raquo;</a></p>',
		'title' => 'Campaign strategy',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Campaign strategy</strong>',
		'cachedsb' => '<li><a href="#time">1. Use all of the mission timer</a></li><li><a href="#retreat">2. Retreat at X damage</a></li><li><a href="#save">3. Save often</a>'
	),
	'orderingvtols' => array(
		'autogen' => TRUE,
		'text' => '<h3 id="ordering">Ordering VTOLs</h3>
<p>
VTOLs are used similarly to ground units. However, they do have a few differences. For one thing, they can fly...
</p>
<h4 id="design">Design and production</h4>
<p>
<img src="icon/bp/vtol.gif" alt="" />
</p>
<p>
To produce VTOL units, you\'ll need the <a href="r/vtolpropulsion">VTOL Propulsion</a> and <a href="r/vtolfactory">VTOL Factory</a> researched, and a <a href="b/vtolfactory">VTOL Factory</a> built. You should also research and build a few <a href="b/vtolrearmingpad">VTOL Rearming Pads</a>, otherwise, they won\'t be able to reload ammo.
</p>
<p>
Before you produce a VTOL unit, you must design it. VTOLs are designed the same way as regular units&mdash;simply select \'VTOL propulsion\'&mdash;but use slightly different weapons (more on that later). 
</p>
<p>
VTOLs can only be built at VTOL factories. VTOL factories can be upgraded with factory modules&mdash;there\'s no need to research a separate "VTOL factory module".
</p>
<h4 id="movement">Movement</h4>
<p>
After producing a VTOL from a VTOL Factory, it will fly and land on the rally point. VTOLs can be ordered to move and attack like any regular unit. Although they will fly over water and cliffs, they can\'t land on them.
</p>
<h4 id="attacking">Attacking</h4>
<p>
VTOL weapons differ drastically from the norm. 
</p>
<p>
To attack with a VTOL, select it and click an enemy like normal. However, you may have noticed the white ammo bar below its health bar as you start attacking. 
</p>
<p>
Unlike ground units, which reload automatically, VTOLs carry a limited amount of ammo. Once that ammo runs out, the VTOL can\'t attack until it refuels. A VTOL out of ammo will automatically find a VTOL rearming pad to rearm and repair itself (and will resume attacking once fully rearmed), or it can be manually rearmed by selecting it and clicking on a rearming pad. 
</p>
<p>
VTOLs will not attack anything automatically. However, by selecting a VTOL and alt+clicking on an area, a VTOL will patrol the area between its current location and the clicked location, and attack anything in the vicinity. Alternatively, they can be assigned to VTOL strike towers and VTOL CB towers, which will cause them to function similarly to <a href="sensors">artillery assigned to sensor towers</a>.
</p>
<h4 id="weapons">VTOL weapons</h4>
<p>
Most weapons have a VTOL equivalent, which does approximately twice as much damage, but has limited ammo. VTOL versions of regular weapons, like cyborgs, do not need to be researched separately.
</p>
<p>
<img src="icon/w/vtolheapbombbay.gif" alt="" /> <img src="icon/w/vtolplasmitebombbay.gif" alt="" />
</p>
<p>
In addition to VTOL versions of ground-based direct weapons, VTOLs can also use <a href="w/#vtolbombs">bomb weapons</a>. These weapons are the equivalent of artillery, and are very powerful.
</p>
<h4 id="defending">Defending against VTOLs</h4>
<p>
<img src="icon/w/vindicatorsam.gif" alt="" /> <img src="icon/w/pulselaser.gif" alt="" />
</p>
<p>
VTOLs are not ground-based units, so most ground weapons cannot hit them. They an only be hit by either anti-air (often abbreviated AA) (can only hit air) or versatile (can hit air or ground) weapons. 
</p>
<p>
There are only a few weapons that are versatile: machineguns, lasers, and Mini-Rocket Pod. Rockets and missiles are also versatile, but only when mounted on a cyborg or VTOL. In addition to being uncommon, versatile weapons do not do as much damage to VTOLs as dedicated anti-air, so having some AA is recommended. 
</p>
<p>
There are three types of dedicated AA. In order of powerfulness, they are: Flak (Hurricane, Cyclone, Whirlwind), SAM (Avenger, Vindicator), and Stormbringer.
</p>
<h4 id="other">Other orders</h4>
<ul>
<li class="p">
<em>Patrol</em>: In the Unit Orders box (right-click, remember?), there are a couple of new icons. Patrol will do the same thing as alt+clicking&mdash;move back and forth between its current location and the clicked location, and attack anything near its path, refueling when they need to before returning to defending. 
</li>
<li class="p">
<em>Circle</em>: In the Unit Orders box, next to Patrol, is the Circle button. Click it and then click an area of ground, and the selected VTOLs will take off and fly in a circle above the selected point. Like Patrol, they will attack anything that gets nearby, and refuel automatically.
</li>
</ul>

<p class="backforward"><a href="orderingunits">&laquo; Prev</a> | <a href="commandpanel">Next &raquo;</a></p>',
		'title' => 'Ordering VTOLs',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Ordering VTOLs</strong>',
		'cachedsb' => '<li><a href="#ordering">Ordering VTOLs</a><ul><li><a href="#design">Design and production</a></li><li><a href="#movement">Movement</a></li><li><a href="#attacking">Attacking</a></li><li><a href="#weapons">VTOL weapons</a></li><li><a href="#defending">Defending against VTOLs</a></li><li><a href="#other">Other orders</a></li>'
	),
	'search' => array(
		'autogen' => TRUE,
		'cachedsb' => ''
	),
	'gettingstarted' => array(
		'autogen' => TRUE,
		'text' => '<h3 id="installing">Installing</h3>

<p>
If you do not already have a copy of Warzone, download it now:
</p>
<ul class="nav">
<li><p><a href="http://wz2100.net/download" target="_blank"><em>Download</em> Warzone 2100</a></p></li>
</ul>
<h4 id="req">System requirements</h4>
<p>
Warzone officially supports Windows XP or newer, Mac OS X 10.4 or newer, or a reasonably recent distro of Linux or BSD. Warzone may work on other operating systems, but we cannot say for sure.
</p>
<h4 id="windows">Windows</h4>
<p>
To install Warzone 2100 on Windows, download the installer, run it, and click "Next" a bunch of times.
</p>
<p>
(You don\'t even need to click "I agree" anywhere - that\'s the beauty of open source.)
</p>
<h4 id="macosx">Mac OS X</h4>
<p>
Download the DMG from the download page, mount it, and drag the app to <code>/Applications/</code>.
</p>
<h4 id="linux">Linux</h4>
<p>
On most distributions of Linux, Warzone should be available in your repositories. However, these are often outdated, and you are encouraged to compile Warzone yourself, which is the usual.
</p>
<p>
If you\'re new to installing from source on Linux, "the usual" refers to the process of downloading the tarball (from the download page), extracting it, opening the Terminal, <code>cd</code>-ing to the extracted directory, and running:
</p>
<blockquote><p><code>./configure && make</code></p></blockquote>
<p>
For more detailed information, or if the above fails, see the <a href="http://developer.wz2100.net/wiki/CompileGuideLinux">Linux Compile Guide</a>.
</p>
<h4 id="other">Other OSes</h4>
<p>
Refer to the <a href="http://developer.wz2100.net/wiki/CompileGuide">Compile Guide</a>.
</p>
<h3 id="running">Running</h3>
<h4>Windows</h4>
<p>
On Windows, simply double-click the icon on your desktop. The game will run. To run the game with the included mods, go to "Start &raquo; Programs &raquo; Warzone 2100" and pick a mod.
</p>
<h4>Mac OS X</h4>
<p>
Double-click on the "Warzone" icon in <code>/Applications/</code> (or use Spotlight, or drag it onto the Dock for easy access).
</p>
<p>
<em>Notes:</em>
</p>
<ol>
<li class="p">If you\'re on 10.4, you need X11 installed. X11 can be found on the install DVD.</li>
<li class="p">If you have a Nvidia-based Mac with Mac OS X 10.5.5-1.5.9, there is an Apple/Nvidia driver bug that doesn\'t allow textures to be shown. To fix it, please upgrade to OS X 10.6 (Snow Leopard).</li>
</ol>
<h4>Linux</h4>
<p>
This really depends on your distribution and/or desktop environment, but it should be wherever you installed it to.
</p>
<h3 id="uninstalling">Uninstalling</h3>
<h4>Windows</h4>
<p>
Either use "Start &raquo; Programs &raquo; Warzone 2100 &raquo; Uninstall" or Add or Remove Programs in Control Panel.
</p>
<h4>Mac OS X</h4>
<p>
Drag the Warzone icon in <code>/Applications/</code> to Trash.
</p>
<h4>Linux</h4>
<p>
It really depends on how you installed it. Package manager? Use the package manager to uninstall it. Compiled it from source? Just delete the source directory.
</p>

<p class="backforward"><a href="basics">&laquo; Prev</a> | <a href="interface">Next &raquo;</a></p>',
		'title' => 'Getting started',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Getting Started</strong>',
		'cachedsb' => '<li><a href="#installing">Installing</a><ul><li><a href="#req">System requirements</a></li><li><a href="#windows">Windows</a></li><li><a href="#macosx">Mac OS X</a></li><li><a href="#linux">Linux</a></li><li><a href="#other">Other OSes</a></li></ul></li><li><a href="#running">Running</a></li><li><a href="#uninstalling">Uninstalling</a>'
	),
	'power' => array(
		'autogen' => TRUE,
		'text' => '<p>

<img src="pictures/interface-power.jpg" alt="" /><br />
<em>The power bar.</em>
</p>
<p>
<img src="pictures/oil.jpg" alt="" /><br />
<em>A spare oil resource, and a derrick hard at work.</em>
</p>
<h3 id="power">Power</h3>
<p>
In real life, money is power, but in Warzone, power is money. You spend power to build structures, manufacture units, and research upgrades/new technology.
</p>
<h3 id="gettingpower">Getting Power</h3>
<p>

So how do you get power? Power is generated by Oil Derricks. However, you must have at least one Power Generator for every four Oil Derricks.
</p>
<p>
Oil derricks must be built on oil resources, but the generator can be anywhere on the map. Keep in mind that additional generators beyond one for every four derricks will provide no benefit.
</p>
<h3 id="pricing">Pricing</h3>
<p>
Icons in the Manufacture, Build, and Research menus will have yellow bars in them representing their price:
</p>
<p>
<img src="icon/w/machinegun.gif" alt="Machinegun $10" style="vertical-align:middle" /> <em>Inexpensive weapon</em>
</p>
<p>
<img src="icon/w/plasmacannon.gif" alt="Plasma Cannon $800" style="vertical-align:middle" /> <em>Expensive weapon</em>

</p>

<p>
When you place your mouse over an icon, the power bar will have a green section, representing its price. If you cannot afford it, the power bar will instead turn red.
</p>
<p>
The amount of power you have is shown on the very left of the power bar. If you place your mouse over an icon, if you have enough power to get it, the number will show the amount of power it will cost. If you can\'t afford it, the number will show the amount of power you need to be able to afford it.
</p>
<p>
Power is drawn as soon as a the icon is clicked. Providing you have sufficient power for the activity, the initial progress bar fills quickly with green (slower with more costly actions) and the construction or research begins. A yellow progress bar then charts the progress achieved by the current activity.
</p>
<h3 id="upgrades">Upgrades</h3>
<p>
<img src="icon/b/powermodule.gif" alt="" />
</p>
<p>

Power Generators can have a Power Module built on top of them to squeeze out more power. Power Modules need to be researched before you can build them. There are also several researchable upgrades available which increase the amount of power you recieve.
</p>

<p class="backforward"><a href="radar">&laquo; Prev</a> | <a href="orderingunits">Next &raquo;</a></p>',
		'title' => 'Power',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Power</strong>',
		'cachedsb' => '<li><a href="#power">Power</a></li><li><a href="#gettingpower">Getting Power</a></li><li><a href="#pricing">Pricing</a></li><li><a href="#upgrades">Upgrades</a>'
	),
	'interface' => array(
		'autogen' => TRUE,
		'text' => '<div class="imagemap">

<p><img src="pictures/interface.jpg" alt="" /></p>
<div><a href="commandpanel" style="top:287px;left:18px;width:140px;height:173px;" id="interfacecommandpanel"><span>Command panel</span></a></div>
<div><a href="power" style="top:400px;left:157px;width:324px;height:62px;" id="interfacepower"><span>Power bar</span></a></div>
<div><a href="minimap" style="top:289px;left:482px;width:158px;height:183px;" id="interfacemap"><span>Map</span></a></div>
</div>
<p>
The interface can be turned on or off with <kbd>Tab</kbd>.
</p>
<p>
<h3>Key</h3>
<ul>

<li class="p">
<strong>Messages</strong> (top): The message bank. This keeps all the last few messages given to you by the game. To see more of your most recent messages, press the <kbd>`</kbd>/<kbd>~</kbd> key (This is the backtick/tilde key; usually found between Esc and Tab).
</li>
<li class="p">
<strong>Time remaining</strong> (top right): The time limit. This is only seen during Campaign. If this goes down to zero, you lose!
</li>
<li class="p">
<strong>Command panel</strong> (bottom left): The <a href="commandpanel">command panel</a>.

</li>
<li class="p">
<strong>Power</strong> (bottom): The <a href="power">power bar</a>.
</li>
<li class="p">
<strong>Map</strong> (bottom right): The <a href="minimap">minimap</a>.
</li>
</ul>

<p class="backforward"><a href="gettingstarted">&laquo; Prev</a> | <a href="camera">Next &raquo;</a></p>

<script type="text/javascript">
<!--
/* preload */
if (document.images)
{
new Image().src="pictures/interface-commandpanel.jpg";
new Image().src="pictures/interface-power.jpg";
new Image().src="pictures/interface-map.jpg";
}
//-->
</script>',
		'title' => 'Interface',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <strong> <span class="arrow">&raquo;</span> Interface </strong>',
		'cachedsb' => ''
	),
	'commandpanel' => array(
		'autogen' => TRUE,
		'text' => '<p><img src="pictures/commandpanel.gif" alt="" /></p>

<p>
There are six different command panel interfaces, plus a central button. You open up a command interface by pressing the appropriate button.
</p>
<ul class="nav p">
<li><a href="manufacture">F1: Manufacture</a></li>
<li><a href="research">F2: Research</a></li>
<li><a href="build">F3: Build</a></li>
<li><a href="design">F4: Design</a></li>
<li><a href="intelligence">F5: Intelligence Display</a></li>
<li><a href="commanders">F6: Commanders</a></li>
</ul>

<p>
The middle button closes any open command interface.
</p>

<p class="backforward"><a href="orderingvtols">&laquo; Prev</a> | <a href="manufacture">Next &raquo;</a></p>',
		'title' => 'Command panel',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Command panel</strong>',
		'cachedsb' => ''
	),
	'transports' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3> Transports </h3>
<p>Transports are used during the campaign to transport units from one sector to another (known as \'Away Missions\'). In multiplayer, they\'re used to transport cyborgs from one part of the current map to another.
</p>
<p><img src="pictures/transport.JPG" alt="" /></p>
A transport with some units loaded in. The transport menu is open.
</p>
<p>
<h3 id="campaign">Campaign</h3>
<h4> Loading Units </h4>

To load units into a transport, select the desired units and click the transport. Only 10 units can occupy a transport at one time. The number of units you have loaded can be seen in the top left of the screen, next to the launch button.
</p>
<p>
<h4> Opening the Menu </h4>
To open a transport\'s menu, click the transport itself. In the screenshot, the menu is open.
</p>
<p>

The units already in the transport are listed to the right.
</p>
<p>
<h4> Launching a Transport </h4>
To launch a transport, click the button in the top left corner of the screen. The transport will launch, and proceed to the destination.

</p>
<p>
<h3> Away Missions </h3>
<p><img src="pictures/transport-2.JPG" alt="" /></p>
<p>Hunkered down at the landing zone.</p>
<h4> Arrival </h4>
When you arrive at the destination, the transport will drop off the units you loaded into the transport and fly away.
<h4> Normal Base Operations </h4>
<p>During away missions, you can still research, manufacture and design units. Simply do it as you would normally, and it will happen back in the base area. You can only build with trucks you have under your control, though. Remember you\'re on an away mission, and in some missions, you won\'t get reinforcements, so stock well.
<h4> Requesting Reinforcements! </h4>

<p>On missions where you CAN request reinforcements, the transport button should be at the top left of the screen. Click it, and you\'ll see the transport menu, with one little twist - all the units you left at home alone are on the right side of the screen.</p>
<p>To load units into the transport, click them, and they\'ll be moved from the right side of the screen to the left. To launch, hit the launch button again. To close this screen, hit the middle button on the Command Panel.</p>
<p>Your units will be on their way. The timer next to the Transport button will have the time remaining until your units get to your location.</p>
<h4> Take Me Home </h4>
Once your units are on an away mission, they\'re not going home until the mission is completed, or you\'ve gotten them killed. I think they\'d prefer the earlier option.
<h3 id="multiplayer">Multiplayer</h3>
<p>
The use of transports in Multiplayer is much more limited in comparison to Singleplayer.
<h4> Cyborg Transport </h4>

The only type of transport available in Multiplayer is the Cyborg Transport. As you may or may not have guessed by the name, it can only hold Cyborgs, no normal units or VTOLs allowed. Cyborg Transports can only be built by VTOL Factories with 2 modules attached, and the technology needs to be researched.
<h4> Loading </h4>
To load a cyborg into the transport, select it and click the Cyborg Transport. The cyborg will load on.
<h4> Moving </h4>
The Cyborg Transport moves like a normal VTOL - select it and click on a piece of terrain to move it. It will take off and land at the place you selected.
<h4> Unloading </h4>
The interface used by the Cyborg Transport is a watered-down version of the Transport interface. To open it, right click the transport. The cyborgs loaded on will be displayed on the left. To boot out a cyborg, click it (while landed, we don\'t want them falling, do we? :) ).
<h4> Destruction </h4>
Cyborg Transports have no weapons, and so are sitting ducks for AA turrets and hardpoints. If a Cyborg Transport is destroyed and it has a few cyborgs on board, you\'ll lose them too. So be careful, OK?

</p>',
		'title' => 'Transports',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Transports</strong>',
		'cachedsb' => '<li><a href="#campaign">Campaign</a></li><li><a href="#multiplayer">Multiplayer</a>'
	),
	'walkthrough' => array(
		'autogen' => TRUE,
		'text' => '<p><strong style="color:red">The walkthrough is incomplete.</strong></p>
<p>
For a more complete walkthrough, see <a href="http://forums.wz2100.net/viewtopic.php?f=3&t=3051">New Walkthrough</a> by themousemaster1, which is the walkthrough which I will eventually adapt into the current Warzone Guide.

</p>

<ul class="nav"><li><a href="http://forums.wz2100.net/viewtopic.php?f=3&t=3051">New Walkthrough</a></li>
<li><a href="http://docs.wz2100.net/walk%20through/index.html">Old Walkthrough</a></a></ul>

<br /><br /><br /><br /><br /><br />

<hr />
Below is the unfinished, newer walkthrough:
<hr />

<br /><br /><br /><br /><br /><br />

<p class="backforward"><a href="campaignstrategy">Start walkthrough &raquo;</a></p>
<p>
Before we begin, we might want to brush up on some basic strategies first.
</p>
<ul class="nav">
<li><a href="campaignstrategy">Campaign strategy</a></li>
</ul>
<h3 id="cam1">Campaign 1 - Alpha</h3>
<p>
Your team is assigned to the Western Sector to locate and retrieve Pre-Collapse technology. Your main goal is to find the Synaptic Link Technology. The Western Sector is a barren wasteland with dry ground and little vegetation, broken up by ridges and plateaus. Because you\'re a new commander, you\'re assigned the easiest of the three sectors. 
</p>
<p>
As a part of this campaign, first build a base, then explore the surrounding area for new technologies. You\'ll run into Scavengers and other enemies, so be careful. Some missions require you to take an away team to a distant area of the sector by transport. Even though you\'re away from your base, you can still give manufacturing orders and research new technologies. 
</p>
<ul class="nav">
<li><a href="alpha1">Alpha 1: Scavenger raiders</a></li>
<li><a href="alpha2">Alpha 2: Power surge detected</a></li>
<li><a href="alpha3">Alpha 3: The power module artifact</a></li>
<li><a href="alpha4">Alpha 4: Investigate the research center</a></li>
<li><a href="alpha5">Alpha 5: Encoded signals detected</a></li>
<li><a href="alpha6">Alpha 6: Enemy attack</a></li>
<li><a href="alpha7">Alpha 7: Establish a forward base</a></li>
<li><a href="alpha8">Alpha 8: Enemy transmissions detected</a></li>
<li><a href="alpha9">Alpha 9: Synaptic Link location</a></li>
<li><a href="alpha10">Alpha 10: Counterattack</a></li>
<li><a href="alpha11">Alpha 11: Stop the removal of artifacts</a></li>
<li><a href="alpha12">Alpha 12: Incoming transmission</a></li>
</ul>
<h3 id="cam1">Campaign 2 - Beta</h3>
<p>
Beta Team has established a base in the sector, but has done very little expansion. The Collective has declared war on the project and is determined to drive your forces from the sector. Your objective is to defend the base and then begin to eliminate this new enemy. You also must search for the VTOL (Vertical Take Off and Landing) Technology.
</p>
<ul class="nav">
<li><a href="beta1">Beta 1: Defend and fortify</a></li>
<li><a href="beta2">Beta 2: Transport down</a></li>
<li><a href="beta3">Beta 3: Hold at all costs</a></li>
<li><a href="beta4">Beta 4: Intercept convoy</a></li>
<li><a href="beta5">Beta 5: Destroy enemy airbase</a></li>
<li><a href="beta6">Beta 6: Destroy reactor</a></li>
<li><a href="beta7">Beta 7: Capture NASDA Control</a></li>
<li><a href="beta8">Beta 8: Satellite Uplink site</a></li>
<li><a href="beta9">Beta 9: Destroy primary SAM sites</a></li>
<li><a href="beta10">Beta 10: Establish a safe haven</a></li>
<li><a href="beta11">Beta 11: Evacuate</a></li>
</ul>
<h3 id="cam1">Campaign 3 - Gamma</h3>
<p>
Nexus has fired nuclear missiles at and destroyed Beta Base. Therefore, you must transfer your command to the Gamma Sector, in the cold, snow-covered Rocky Mountains. The key is to use the terrain to hide your units from the enemy while not getting ambushed in the process.
</p>
<p>
Nexus has all the latest and most powerful technology. Until you can capture and research some of it, your units will be at a disadvantage. The Project is depending on you, however. Your failure means the end for it.
</p>
<ul class="nav">
<li><a href="gamma1">Gamma 1: Establish a forward base</a></li>
<li><a href="gamma2">Gamma 2: Destroy missile site</a></li>
<li><a href="gamma3">Gamma 3: Assist Team Gamma</a></li>
<li><a href="gamma4">Gamma 4: Rescue Team Alpha</a></li>
<li><a href="gamma5">Gamma 5: Defend your base</a></li>
<li><a href="gamma6">Gamma 6: Rescue the scout team</a></li>
<li><a href="gamma7">Gamma 7: The missile silo</a></li>
<li><a href="gamma8">Gamma 8: Missile codes</a></li>
<li><a href="gamma9">Gamma 9: Destroy Nexus Main Base</a></li>
</ul>
',
		'title' => 'Campaign walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Campaign walkthrough</strong>',
		'cachedsb' => '<li><a href="#cam1">Campaign 1 - Alpha</a></li><li><a href="#cam1">Campaign 2 - Beta</a></li><li><a href="#cam1">Campaign 3 - Gamma</a>'
	),
	'camera' => array(
		'autogen' => TRUE,
		'text' => '<h3 id="whatisit">What is the Camera?</h3>

<p>
When Warzone was released in 1999, it was one of the first real-time strategy game to be in 3D. Now, most real-time strategies are in 3D, but, if you\'re not used to the new trend, let us help you along.
</p>
<h3 id="camera">Basic Controls</h3>
<ul>
<li class="p">
<em>Moving</em>: To move where you\'re looking at, move the mouse to the edge of the window/screen, or use the arrow keys.
</li>
<li class="p">
<em>Rotating</em>: To rotate the view, hold down the right mouse button, and move the mouse in any direction. (The view can also be rotated using <span class="key">8</span> and <span class="key">2</span> (up/down), or <span class="key">4</span> and <span class="key">6</span> (left/right) on the numeric keypad.)

</li>
<li class="p">
<em>Zooming</em>: To zoom in or out, use the <span class="key">+</span> or <span class="key">&minus;</span> keys on the numeric keypad, or use the mouse wheel.
</li>
</ul>
<h3 id="camera">Advanced Controls</h3>
<ul>
<li class="p">
<em>Reset view to north</em>: If your camera angle feels unnatural, pressing <span class="key">Backspace</span> will reset your view to the north.
</li>
<li class="p">
<em>Set view to any direction</em>: If you want to align the camera to a different direction, pressing <kbd class="lkey">Ctrl</kbd>+<kbd><em>[arrow key]</em></kbd> will set your view to that direction.
</li>
<li class="p">
<em>Unit Tracking</em>: Press <span class="key">Spacebar</span> when units are selected, and the camera will follow them. Press <span class="key">Spacebar</span> again to stop Unit Tracking.
</li>
<li class="p">
<em>Jump to base</em>: Press <span class="key">B</span> to center the view at your Command Center. Useful if you need to get back to base quickly.
</li>
<li class="p">
<em>Jump to squad</em>: If you have a squad assigned with <kbd class="lkey">Ctrl</kbd>+<kbd><em>[number]</em></kbd>, you can quickly jump to that squad by pressing <kbd><em>[number]</em></kbd> twice.
</li>
</ul>

<p class="backforward"><a href="interface">&laquo; Prev</a> | <a href="radar">Next &raquo;</a></p>',
		'title' => 'Camera',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Controlling the camera</strong>',
		'cachedsb' => '<li><a href="#whatisit">What is the Camera?</a></li><li><a href="#camera">Basic Controls</a></li><li><a href="#camera">Advanced Controls</a>'
	),
	'minimap' => array(
		'autogen' => TRUE,
		'text' => '<h3 id="minimap">What is the minimap?</h3>

<p><img src="pictures/interface-map.jpg" alt="" /></p>
<p>
The minimap is a very useful tool on the Warzone battlefield. It helps you keep track of your units and structures, your opponents units and structures (within range), and the map itself. Orders can be issued over the minimap, and it can be used to jump to part of the map very quickly.
</p>
<p>
The minimap is given after you build a Command Center.
</p>
<h3>Key</h3>
<ul>
<li class="p">
<em>Faint-white trapezoid</em>: This is a visual representation of your camera on the radar. The large end points towards where you\'re looking. The small end is where the camera is.
</li>
<li class="p">
<em>Transparent areas</em>: Unexplored - will peel away as you send units into them. These areas are black on the screen.

</li>
<li class="p">
<em>Green area</em>: Units or structures that belong to the green player (in this case, us).
</li>
<li class="p">
<em>Yellow/gray/black/red/blue/cyan/magenta area</em>: Units or structures that belong to the yellow/gray/black/red/blue/cyan/magenta player (not pictured).
</li>
<li class="p">
<em>Red/white flashing area</em>: Units or structures belonging to you that are under attack.
</li>
<li class="p">
<em>Green pulse</em>: Artifact. Needed to research technologies in Campaign. In Skirmish/Multiplayer, can be found by destroying enemy base structures.
</li>

<li class="p">
<em>Red pulse</em>: An enemy base or other point of interest. Only used in Campaign.
</li>
<li class="p">
<em>Blue pulse</em>: A free <a href="power">oil resource</a>.
</li>
</ul>

<h3>Controls</h3>
<ul>
<li class="p">
<em>Moving the camera</em>: Right-click anywhere on the minimap to move the camera.

</li>
<li class="p">
<em>Giving orders</em>: If you have units selected, click anywhere on the radar, and the units will carry out that order.
</li>
<li class="p">
<em>Zooming in and out</em>: Hover your mouse over the minimap and move the mouse wheel up or down.
</li>
</ul>

<p class="backforward"><a href="camera">&laquo; Prev</a> | <a href="power">Next &raquo;</a></p>',
		'title' => 'Minimap',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <strong>Minimap</strong>',
		'cachedsb' => '<li><a href="#minimap">What is the minimap?</a>'
	),
	'manufacture' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3>Manufacturing</h3>
<p>
Manufacturing units is similar to building structures. The buildings that can build structures are Factories, Cyborg Factories and VTOL Factories.</p>
<p>
<h3>Screenshots</h3>
<img src="pictures/manufacture_1.jpg" alt="" /><br>
1: Selecting a unit to be manufactured
</p>
<p>
<img src="pictures/manufacture_2.jpg" alt="" /><br>
2: The unit being manufactured
</p>
<p>

<h3>Building a Unit</h3>
To manufacture a unit, you need to press the Manufacture button. A Fast Find bar will open at the bottom of the screen, between the radar and the Command Panel.</p><p>The bottom row of the two contains every Factory, Cyborg Factory and VTOL Factory built. Clicking it will zoom the camera to the structure.</p>

<p>
To manufacture a unit, click the space above a factory. If this factory is capable of building a unit, it will appear in a menu on the left side of the screen. </p> A factory can only build a unit if the body of a unit is a certain type (unit/cyborg/VTOL), and if the factory has enough modules applied.<p></p>
<p>
<h4>Queueing Units</h4>
You can build up to nine units by repeatedly clicking the unit. You can also right-click the unit to lower the amount of units to build  right-clicking on a unit with no units queued will set the queue to 9.</p>
<p>

<h4>Building Status</h4>
While a unit is building, the Fast Find bar above the factory building the unit will be displayed. If the bar is green, the unit is gathering power to build the unit. If the bar is yellow, the unit is building.</p>
<p>
<h4>Rally Points</h4>
When the unit is done building, it will spawn next to the factory, then proceed to a rally point. A rally point is created when a factory is made. Right-clicking on the factory in the bottom Fast Find row will centre the camera on a spawn point. Clicking a rally point will allow you to move it in a similar way to building a structure. Please note that moving a rally point while a unit is moving to one will not affect its path.</p>
<p>
<img src="pictures/deliverypoints.jpg" alt="" /><br>
</p>
<p>
Rally points (clockwise, from top left): Cyborg rally point, Factory rally point, Repair Facility, VTOL rally point</p>

<p>

<h4>Looped production</h4>
<p>
You can also set looped production by left and right clicking the loop button in the left column near the top. This repeats the build sequence you set the amount of times shown next to the button. This can be set to infinite by right-clicking when the number reads zero.</p>

<p class="backforward"><a href="commandpanel">&laquo; Prev</a> | <a href="research">Next &raquo;</a></p>',
		'title' => 'Manufacture',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Manufacture</strong>',
		'cachedsb' => ''
	),
	'research' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<p>
<h3>Research</h3>
Researching technologies is very simple. You can only research technologies with Research Facilities.</p>
<p>
<h3>Screenshots</h3>
<img src="pictures/research-1.jpg" alt="" /><br>
1: Selecting a topic to research
</p>
<p>
<img src="pictures/research-2.jpg" alt="" /><br>
2: The topic being researched
</p>
<p>

<h3>Researching</h3>
<h4>Single Player</h4>
In the single player game, you collect Artifacts from enemies and research them. Artifacts are small white boxes with a wrench above them, and can be collected by any unit by moving to it.
<h4>Multiplayer/Skirmish</h4>
In Multiplayer/Skirmish games, you progress along a tech tree - a couple of topics can be researched, which in turn will unlock more technologies - also referred to as progressing \'up the tech tree\'.</p>

<p>
<h4>Researching a topic </h4>
When you open the Research menu, a Fast Find menu with two rows will appear at the bottom of the screen. All your research facilities are shown on the second row. Clicking a research facility will zoom the camera to it.</p><br>
<p>
Clicking the blank icon above a facility will show a set of icons on the left. You can hold the mouse over an icon to see its name. Click an icon to start researching it. Only one center can research one technology at a time.</p>

<p>
While a facility is researching, it displays a bar in its Fast Find area. If the bar is green, the facility is gathering power. If it is yellow, the topic is being researched.</p>
<p>
<h4> Research Completion </h4>
When research is completed, the game will inform you by a message and playing a sound  Research Completed. If it was a major technology advancement, an entry will be made in the Intelligence Display. You can check the entry for more information about the research.</p>
<p>
<h4> Research Upgrades </h4>
You can research a Research Module during the course of the game. To apply it, select a truck and left click a non-upgraded Research Center, and the truck will build it. However, the topic you are researching will be stopped until the module is built - it\'s your choice to let it build or wait. </p> <p> Other upgrades are also available for Research Centers, but these don\'t make you wait to apply an upgrade to a building.</p>

<p class="backforward"><a href="manufacture">&laquo; Prev</a> | <a href="build">Next &raquo;</a></p>',
		'title' => 'Research',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Research</strong>',
		'cachedsb' => ''
	),
	'build' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3> Building </h3>
Building structures is absolutely vital in Warzone - from Factories to build units, to Research Centers for researching new technology.</p>
<p>
Building can be done with units with Trucks as turrets and Combat Engineers.</p>
<p>
<h3> Screenshots </h3>
<img src="pictures/build-1.jpg" alt="" /><br>
1: Selecting a structure to build
</p>
<p>

<img src="pictures/build-2.jpg" alt="" /><br>
2: Selecting an area to build the structure
</p>
<p>
<h3> Building </h3>
<h4> Building a Structure </h4>
To build, you need to select Build on the Command Panel, and this will bring up two rows of icons on the bottom of the screen, between the Command Panel and the Radar. These each represent one unit, either a truck or a Combat Engineer, that is able to build. Clicking the bottom row of icons will zoom the camera to the unit. The top row of icons will pull up a bar on the left side of the screen (diagram 1). The two columns of icons represent the structures you can build. Click a structure on the columns to select it for building. You can hold the mouse over an icon to see the structures name.</p>
<p>
<h4> Selecting a location </h4>
When you select a structure, it closes the two menus (like clicking the middle button). A white square will appear in the world. This is where your structure will be placed. Move the square by moving the mouse. Click to place the build site for the structure. If the square is red, the structure cannot be placed. To build walls (when building defenses) you can click and drag the box to draw a wall.</p>

<p>
<h4> Oil Derricks </h4>
Oil derricks can only be built on Oil Pools which arent on fire. Fires on Oil Pools will burn out over time. Oil derricks are built automatically if a truck is selected and you left-click an Oil Pool.</p>
<p>
The unit you selected to build the structure will move to build the structure.</p>
<p>
If you open the Build menu again, the units status will be shown in the Fast Find bar. If there is a structure without a bar in the Fast Find top row above a unit, the unit is moving to the build site. If there is a green bar, it is accumulating power for building. If there is a yellow bar, it is building the site.</p>
<p>
<h4> Repairing </h4>
You can assign a unit to repair a structure by selecting it and left-clicking a building.</p>

<p>
<h4> Demolishing </h4>
Demolishing a building is nearly as simple as building one. Select Demolish Structure in the Structure menu and click a building to demolish. The unit will move to the building and destroy it, giving you half the power used in building the structure. Demolish Structure will always be available, from start of game to end.</p>
<p>
<h4> Teamwork </h4>
You can assign extra trucks/cyborgs to a building to build it faster. Simply select a unit and left-click a structure, and the unit will move to the building and start helping construction.</p>
<h4> Hardcrete and Tank Traps </h4>
<p>

You may wonder what the Hardcrete and Tank Traps do. Well, they do nothing. They just sit there and keep your units and enemy units from passing through.
</p>

<p class="backforward"><a href="research">&laquo; <strong>Research</strong> &laquo; Prev</a> | <a href="design">Next &raquo; <strong>Design</strong> &raquo;</a></p>',
		'title' => 'Build',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Build</strong>',
		'cachedsb' => ''
	),
	'intelligence' => array(
		'autogen' => TRUE,
		'text' => '<p><em style="color:#BB0000;">Unfinished page</em></p>

<h3>Intelligence Display</h3>
While the Intelligence Display doesn\'t have a large purpose like the rest of the functions, it is still very useful indeed - it contains a record of all the technology you have researched.
<h3> Screenshots </h3>
<p>
<img src="pictures/intelligence.jpg" alt="" /><br>
Intelligence display with piece of intelligence selected
</p>
<p>
<h4> What\'s displayed </h4>
When you open the Intelligence Display, two rows of icons appear on the bottom of the screen. Selecting an icon will display information in the middle of the screen. This is helpful for looking at technologies you have researched. During Campaign, a piece of intelligence always displayed is your mission objective.</p>

<p>
<h4> We Brake For Nobody </h4>
Please note that while the Intelligence Display pauses the game in Campaign mode, it doesnt do so in Multiplayer and Skirmish!</p>',
		'title' => 'Intelligence',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="basics">Basics</a> <span class="arrow">&raquo;</span> <a href ="commandpanel">Panel</a>  <span class="arrow">&raquo;</span> <strong>Intelligence</strong>',
		'cachedsb' => ''
	),
	'alpha1' => array(
		'autogen' => TRUE,
		'text' => '<tr><td class="l" valign="middle"><h3 id="overview">Alpha 1: Scavenger Raiders</h3>
<h4 id="forwardbase">Build a forward base</h4>
<p class="timer"><span>Time limit: <strong>unlimited</strong></span></p>
<p>
As may be expected, the first stage of this game is fairly easy. Wouldn\'t want to get people to quit playing before they begin. ;)
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3801&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3801&t=1" alt="" /></a></p>
<p>
You should start with three Trucks and four Machinegun Viper Wheels tanks.
</p>
<p>
Not much of a base, eh? You\'ll have to build one yourself. Start by building a Command Center, a Factory, a Power Generator, and a Research Facility. As long as you don\'t go to far to the east, no one will attack you.
</p>
<p>
Once you move a truck to the east to build an oil derrick, however, small groups of Scavengers will begin to attack you. Your MG Vipers will have no trouble defeating them. Nonetheless, begin manufacturing some additional MG Vipers to assist them.
</p>
<h4 id="search">Search for scavenger outposts</h4>
<p>
Once you have dealt with the scavengers right outside your base, it\'s time to start exploring. Manufacture eight MG Viper Wheels, then send them north and east of your current position to attack the nearest scavenger settlement.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3802&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3802&t=1" alt="" /></a></p>
<p>
Once you have defeated this settlement (which shouldn\'t be very difficult), you\'ll find an artifact. Pick it up (click on it) and research it at your Research Facility. When the oil resource cools down, build an oil derrick there, too; it\'ll give you more money.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Hardened MG Bullets</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades machinegun damage to 130%</li></ul></td></tr>
</table></div><!--research table-->
<p>
You will want to recycle and rebuild any tanks that are in red or yellow health (don\'t worry, by the end of this stage, the option to repair vehicles will be available, so this whole repair-rebuild process isn\'t permanent).
</p>
<p>
Once your 8 tanks are battle ready again, head north.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3803&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3803&t=1" alt="" /></a></p>
<p>
Another small base; you should be able to destroy it easily. Upon demolition of this base, you will get the artifact for the <a href="w/flamer">Flamer turret</a>. Using it or not is your preference; it will work <em>very</em> well in upcoming stages against almost anything, but its short range means it will also get most of the enemy fire centered on it, and its low HP means it will die quickly. By the time you find heavier bodies and armor to supply it with, you will also have other weapons you might like more, so.... as I said, use it or don\'t.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Flamer</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/flamer">Flamer</a></li></ul></td></tr>
</table></div><!--research table-->
<p>
Again, recycle and rebuild your units, and get ready to move west.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3804&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3804&t=1" alt="" /></a></p>
<p>
This is the first time your units face a credible danger of being lost; be sure they are set to retreat at some level of damage (for now, Retreat at Low Damage is enough).
</p>
<p>
Once the base goes down, you will get a very useful artifact: the MG guard tower &ndash; your first defensive structure. Although it\'s called a Machinegun Guard Tower, it has a Heavy Machinegun on it, and will do more damage than your Machinegun tanks.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Machinegun Guard Tower</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Machinegun Guard Tower</li></ul></td></tr>
</table></div><!--research table-->
<p>
And now, it\'s time for the last base.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3805&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3805&t=1" alt="" /></a></p>
<p>
You\'ll want to avoid those flamer towers &ndash; they do high damage if you get close, but are harmless as long as you shoot them from far away.
</p>
<p>
You\'ll notice one of the buildings is circled. <strong>Don\'t shoot it.</strong> <a href="orderingunits#ordersmenu">Order your units</a> to Hold Fire so they only shoot things you explicitly tell them to attack, and destroy all the other buildings.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Engineering</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades construction speed to 110%</li></ul></td></tr>
<tr><td class="l" valign="middle">* Mobile Repair Turret</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/repairturret">Repair Turret</a></li></ul></td></tr>
<tr><td class="l" valign="middle">* Tank Traps</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Tank traps</li></ul></td></tr>
</table></div><!--research table-->
<p>
Since there\'s still one enemy building left, the game won\'t end, and you can use your free time to research all of this. Build a repair turret tank, and repair all of your damaged units (no need to recycle again!) Now\'s your time to relax, build oil derricks anywhere you need to, and maybe fortify the southern edge a bit.
</p>
<p>
Once you\'re ready, move all your units to the southern end, destroy the last structure with a tank or tower, and it\'s time for <a href="alpha2">Alpha 2</a>!
</p>

<p class="backforward"><a href="campaignstrategy">&laquo; Prev</a> </ul></td></tr>| <a href="alpha2">Next &raquo;</a></p>
',
		'title' => 'Alpha 1 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 1: Scavenger Raiders</strong>',
		'cachedsb' => '<li><a href="#overview">Alpha 1: Scavenger Raiders</a><ul><li><a href="#forwardbase">Build a forward base</a></li><li><a href="#search">Search for scavenger outposts</a></li>'
	),
	'artillerytactics' => array(
		'autogen' => TRUE,
		'cachedsb' => ''
	),
	'earlygamestrategy' => array(
		'autogen' => TRUE,
		'title' => 'Early-game multiplayer strategy',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Early-game multiplayer strategy</strong>',
		'text' => '<p>
Ah, the early-game. Most games start out with very few choices, only branching off into multiple choices later on. The upshot of this is that the early-game is very well analyzed.
</p>
<h3 id="tips">Tips</h3>
<p>
Before we begin, keep a few things in mind:
</p>
<ul class="p">
<li class="p">Use your power. If your power rises above 500 in the early or mid-game, spend more of it! Research something, build some more research facilities, build a bigger army, defend your oil derricks... <em>something!</em></li>
<li class="p">Never stop researching. If you stop, you will be more and more disadvantaged as time goes on, in every area.</li>
<li class="p">Get more derricks. Everything requires power! The more you have of it, the better. It\'s nearly impossible to win with only the four derricks in your base.</li>
</ul>

<h3 id="build">Building and exploring</h3>

<p>
Most players begin a multiplayer game in T1, No Bases. This starts them off with two trucks and nothing else. You can\'t win a game without having all four of the base structures, but what to build first?
</p>
<ul>
<li class="p">
Many players build a <strong>Factory</strong> first (or at least second). Factories produce additional trucks, which makes building the rest of the base much faster.
</li>
<li class="p">
<strong>Research Facilities</strong> are also important. Unlike other games, Warzone starts with zero weapons researched, so Machinegun must be researched before you have any offensive capability at all. Without a research facility, you can\'t do anything but make trucks and base structures.



</li>
<li class="p">

<strong>Command Centers</strong> are also required for most normal play - they are a prerequisite for any defensive structure research, and are required to design tanks.

</li>
<li class="p">
Without a <strong>Power Generator</strong>, your initial supply of power will quickly run out. Start on those oil derricks as well.
</li>
</ul>
<p>
As you are building up your base, you should send trucks out to capture oil resources around the map, as well as scouting for enemy activity. The four oil resources inside your base (on a standard map) will soon be insufficient, and you need to claim more to have a chance of staying in the game.
</p>
<p>

While you are exploring, you should start making Machinegun tanks or cyborgs to help defend your trucks.


</p>
<p>

Some possible orders to build your structures:
</p>
<p><img src="pictures/buildorders.png" alt="build orders" /></p>

<h3 id="research">Researching</h3>
<p>
<em>This section assumes that the reader has knowledge of Warzone\'s research system. If you do not, see:</em> <a href="research">Research</a>
</p>
<p>

In Warzone, without research, a player simply cannot survive in a game for very long. Every research is one more advantage you have against your opponent. It\'s an advantage that costs no money after it has been researched. It\'s an advantage that, unlike armies and structures, cannot be taken from you.
</p>

<p>

There\'s no need to worry about memorizing the research tree, of course. It may seem intimidating, but a player needs to know very little of it, and will quickly pick up what to research while playing the game.
</p>
<p>
Much of the research tree is completely optional. I\'ve won games without ever researching <a href="r/machinegun">Machinegun</a>. However, a few are completely necessary in competitive play. It\'s not that you can\'t win no matter what, but that if someone else has researched these, and you haven\'t, they have an insurmountable advantage.

</p>
<p>
But even within these "must-haves", there are different strategies about which to research first. Remember that the purpose of research is to gain an advantage on your opponent. But which advantage should you gain first? Offensive capability? Defensive capability? Economy?
</p>
<h4 id="weapons">Weapons</h4>

<p>
No matter if you choose to focus in offense, defense, or economy, you need to choose a few weapons to specialize in.
</p>

<p>

The first weapon you get in Warzone is the Machinegun. So if you want to tank rush as early as possible, the Machinegun is the only choice. However, if you have time to research a bit first, there are four viable early-game weapons:
</p>
<ul>
<li>Twin Machinegun</li>
<li>Light Cannon</li>

<li>Flamer</li>
<li>Mini-Rocket Pod</li>

</ul>

<p>
These all cost approximately $100 to research, total, and will take two to three minutes to research. The Mini-Rocket Pod costs slightly, but not noticeably, more than the others.

</p>
<p><img src="icon/w/twinmachinegun.gif" alt="Twin Machinegun" /></p>

<p>
Getting the <strong>Twin Machinegun</strong> and going down the machinegun route will give you an early-game advantage. It\'s a generalist weapon, and you\'ll soon get the Heavy Machinegun. Many games can be won simply by focusing on this weapon.
</p>
<p>
Some players like to neglect research after getting the Heavy Machinegun; simply amassing these tanks and rushing the enemy. Note, however, that even at this stage, massed Heavy Machineguns are still vulnerable to massed Mini-Rocket Pod tanks and towers, and that if the rush fails, you will be at a <em>very</em> significant research disadvantage.



</p>
<p><img src="icon/w/lightcannon.gif" alt="Light Cannon" /></p>
<p>

The <strong>Light Cannon</strong> is the start of the cannon tree. While the Medium and Heavy cannons don\'t show up as early as the Heavy Machinegun, they easily outclass it. Cannons are slower, heavier, more expensive, and have more HP than machineguns. They do more damage to armored tanks and armored structures, but less damage to cyborgs.

</p>
<p>
While Light Cannons can be used similarly to machineguns, the weight of the more powerful cannons slows them down enough that you must plan for this liability. Users of longer-ranged weapons, such as Lancers, can easily outrun you, and harass you from afar. In situations like this, seek to corner them where they cannot escape. If you are in open space, it may be best to ignore them, and continue on to your enemy\'s base, instead of wasting time chasing them, which will be a losing battle.
</p>
<p><img src="icon/w/minirocketpod.gif" alt="Mini-Rocket Pod" /></p>
<p>
The <strong>Mini-Rocket Pod</strong> is the start of the rocket tree. It is a highly specialized weapon designed to fight tanks. It also does a little damage to unarmored structures such as the Machinegun Tower and some base structures, but is nearly completely ineffective against more armored structures, as well as cyborgs.



</p>
<p>
Mini-Rocket Pods are the longest ranged T1 direct weapon, and are fairly light, and this should be used to your advantage. Through attrition, a few of these can wear down a sizable army. If you encounter any cyborgs, however, you have no choice but to run.

</p>
<p>
Upgrading mini-rockets will eventually lead to the Mini-Rocket Array, a weapon that can deal with the cyborgs and walls that the Mini-Rocket Pod has trouble with.
</p>

<p><img src="icon/w/flamer.gif" alt="Flamer" /></p>
<p>
Unlike the other weapons, the <strong>Flamer</strong> is traditionally used on cyborgs (and later, hovercraft). This makes them quite vulnerable to machineguns, but they are quite powerful against cannons and mini-rocket pods. Flamers do barely any damage to hardcrete walls and hardpoints, but significant damage to everything else, as long as you can get within range. Getting within range is a problem in the early game, as wheeled vehicles can match your speed, and slowly kill you with long-ranged weapons as they retreat.
</p>

<p>

Later on, as players start using the slower and heavier tracked and wheeled vehicles, and you start using hovers, flamers can catch up to and annihilate armies with their fire.
</p>

<p><img src="icon/w/mortar.gif" alt="Mortar" /></p>

<p>
In addition to these four weapons, there is also the <strong>mortar</strong>, available a bit later. Mortars are long-ranged siege weapons, best used against enemy structures. Used defensively, they can help soften attacking armies, but should not be relied upon. When <a href="sensors">assigned to sensors</a>, they have an extremely long range, but are vulnerable to enemy units, so they are best protected by other weapons that are more powerful at shorter ranges.

</p>
<p>
With these weapons, it is often to your advantage to go along multiple weapon paths, which will give you additional versatility. Mini-Rocket Pods and Heavy Machinegun form a popular combination, with the machineguns taking care of the cyborgs that the rockets would otherwise be helpless against. The flamers\' upgrade path is relatively inexpensive, and their ineffectiveness against early enemies makes them best paired with other weapons.
</p>
<p>

As the game goes on, you may want to start branching out into different weapon trees. Although the cannon and rocket trees are difficult to catch up on if you haven\'t been researching them since the early-game (and by corollary, you should be keeping up with at least one of those trees), most other weapons are fairly easy to get if necessary. In particular, lasers require no other weapon research, and are a good choice if you find yourself in T3 but falling behind in weapon research.
</p>
<h4 id="offense">Offense</h4>
<p>

When playing offensively, it\'s important to upgrade your weapons. Each damage upgrade adds 25% to damage, and each rate-of-fire upgrade decreases reload time by 10% or 15%, and these can really add up. Fully upgraded cannons, for instance, have ten times as much damage rate as un-upgraded cannons.
</p>
<p>
Unless they unlock more powerful weapons, weapon accuracy upgrades should generally be avoided until there are no other upgrades, since they grant a negligible 10% (of base accuracy) bonus to accuracy.
</p>
<p>
Researching a new weapon type will generally unlock its damage upgrade. <a href="r/automatedmanufacturing">Automated Manufacturing</a> (and its improved versions) is often needed to unlock rate-of-fire upgrades. <a href="r/synapticlinkdataanalysis">Synaptic Link Data Analysis</a> (and its improved versions) is often needed to unlock accuracy upgrades.
</p>
<p>
Unlocking stronger weapons usually requires researching damage upgrades. Exceptions include rockets (and later Scourge Missile), which require accuracy upgrades to unlock, and rotary weapons (such as Assault Gun or Pepperpot), which require rate-of-fire upgrades.


</p>
<p>
Armor upgrades are even more powerful, granting 30% more armor <em>and</em> 30% more HP. There are separate armor upgrades for tanks and cyborgs, so choose wisely.

</p>

<p>
Tank armor upgrades will unlock more powerful Project bodies, while engine upgrades will unlock more powerful New Paradigm bodies. New Paradigm bodies are faster and slightly less expensive, but Project bodies have more armor.
</p>
<p>
These upgrades will also unlock better propulsions, such as Tracks and Hover. Tracks offer increased health and armor in exchange for slower speed. Hovercrafts have only slightly more health, but are significantly faster than wheels.

</p>
<h4 id="defense">Defense</h4>
<p>

Your first defensive structure is the Machinegun Tower. Despite its name, the weapon mounted on top of it is a Heavy Machinegun, which is quite a bit more powerful than the Machinegun tanks that you will be defending against.
</p>
<p>
Machinegun towers can also be used offensively. In Warzone, structures can be built anywhere. A player with no tanks can build towers next to enemy oil resources, to seize them, and next to friendly oil resources, to defend them. Using structures offensively is usually only viable very early in the game.
</p>
<p>
Other defensive structures can be found by researching Hardcrete Walls. Walls and defensive structures can be upgraded with Hardcrete upgrades, which are unlocked by researching walls, and later Improved and Advanced Engineering. Although these do not unlock anything until fairly late in the game, they upgrade armor by 35% and HP by 30%, making them one of the most significant automatic upgrades in the game.
</p>
<p>
No matter how defensively you play, you still need to upgrade weapons as well as structure armor.
</p>
<h4 id="economy">Economy</h4>

<p>

While you are building and upgrading your structures and tanks, it\'s important to think long-term. While providing no direct benefit, every structure module available will give you an insurmountable long-term advantage:
</p>
<ul class="p">
<li>Engineering
<ul>
<li>Fuel Injection Engine
<ul>

<li>Power Module</li>
</ul></li>
<li>Cyborg Factory

<ul>
<li>Factory Module</li>

</ul></li>
</ul></li>

<li>Sensor Turret
<ul>
<li>Sensor Tower
<ul>
<li>Command Relay Post
<ul>
<li>Research Module</li>

</ul></li>
</ul></li>
</ul></li>
</ul>

<p>
The usual order in which these are researched are:

<ul>
<li class="p">

The <strong>Power Module</strong> provides an extremely large boost (1.5x) to power production, and unlike other modules, power modules are free. It is perhaps the most important upgrade, and many players get it well before any other module.
</li>
<li class="p">
The <strong>Factory Module</strong> allows for faster production, and production of medium (and heavy) bodies. It also unlocks vehicle and cyborg armor upgrades, and is vital if you don\'t want your tanks to stay Viper Wheels with no upgrades.

</li>
<li class="p">

While the Command Relay Post is unnecessary, it unlocks the <strong>Research Module</strong>, which provides a significant (nearly 2x) boost to research speed. In addition, it unlocks Synaptic Link Data Analysis (and its improved versions). Synaptic Link Data Analysis further improves research speed, but more importantly, it and its upgraded versions are required for the most powerful later-game technology, and nearly all T3 technology.


</li>
</ul>
',
		'cachedsb' => '<li><a href="#tips">Tips</a></li><li><a href="#build">Building and exploring</a></li><li><a href="#research">Researching</a><ul><li><a href="#weapons">Weapons</a></li><li><a href="#offense">Offense</a></li><li><a href="#defense">Defense</a></li><li><a href="#economy">Economy</a></li>'
	),
	'alpha2' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 2 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 2</strong>',
		'text' => '<h3 id="overview">Alpha 2: Power surge detected</h3>
<p class="timer"><span>Time limit: <strong>1 hour</strong></span></p>
<h4 id="back">Back to the base</h4>
<p>
Well, the game\'s starting to get more interesting now. You have <em>two</em> choices of weapons: <a href="w/machinegun">Machinegun</a> and <a href="w/flamer">Flamer</a>.
</p>
<p>
As soon as this level starts, move your army slightly south of the entrance to your base, where you will encounter two bunkers (they look like shacks) and some scavengers. Flamers are especially powerful against these bunkers, so if you have some, try it out.
</p>
<p>
If you\'re having trouble, retreat to the MG towers you built earlier (you <em>did</em> build those when we told you to, right?)
</p>
<p>
Once the two bunkers are down, press south to the first enemy base.
</p>
<h4 id="destroy">Destroy more outposts</h4>
<p><a href="http://forums.wz2100.net/download/file.php?id=3808&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3808&t=1" alt="" /></a></p>
<p>
If you have flame tanks leading the charge, then just head straight into the base. If not, then have your tanks skirt southeast from the small chokepoint, and then have them head west, shooting up the towers and base buildings with your whole force, rather than one tank at a time. The base holds upgrades for your flamers.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">High Temperature Flamer Gel</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades flamer damage to 130%</li></ul></td></tr>
<tr><td class="l" valign="middle">* High Temperature Flamer Gel Mk2</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades flamer damage to 160%</li></ul></td></tr>
<tr><td class="l" valign="middle">* High Temperature Flamer Gel Mk3</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades flamer damage to 190%</li></ul></td></tr>
</table></div><!--research table-->
<p>
You should be able to take out most of the structures you see in the picture before your force is depleted (read: retreated) enough to make it unusable. You may run into some units coming from the west, but you should be able to take care of them as well.
</p>
<p>
On your second pass, get on the hill in the bottom left of the above picture, and pick up the sensor research from it. Then, get your tanks back down.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Sensor Turret</td><td class="c price">$28</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/sensorturret">Sensor Turret</a></li></ul></td></tr>
<tr><td class="l" valign="middle">* Sensor Tower</td><td class="c price">$28</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Sensor Tower</li></ul></td></tr>
</table></div><!--research table-->
<p>
If you feel like it, have your trucks put a couple MG towers in the area at the bottom right of the screenshot as well. Have your MG tanks cover them as they do so; scavengers like to pop out of the houses in that vicinity.
</p>
<p>
When the sensor tech is retrieved, and the MG towers are up, (and your tanks are suitably repaired), head west and north to the next scavenger base.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3809&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3809&t=1" alt="" /></a></p>
<p>
This base is outright nasty. Flamers (including one on a fire truck), a number of units, guard towers, bunkers... The best way to handle all this is with an all-MG force, <a href="orderingunits">set to maximum-range firing</a>. Make sure to destroy the flamers before they get in range of you.
</p>
<p>
Once you\'ve managed to take out the flame tower and the fire truck (and the two bunkers) guarding the ramp, this assault gets much easier; yes, they have a lot of units and buildings, but you can use the same "overpowering" strategy you\'ve been using. Don\'t feel you need to produce a huge army; eight MG tanks are usually enough to get through all of Alpha 2 up to this point, with no losses.
</p>
<p>
Destroying this base yields the <a href="w/twinmachinegun">Twin Machinegun</a>. Though not absolutely necessary, now would be a good time to recycle your MG tanks for the new TMG.


</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Twin Machinegun</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/twinmachinegun">Twin Machinegun</a></li></ul></td></tr>
</table></div><!--research table-->
<p>
Regroup, and it\'s time to head south to the next base.
</p>
<p><a href="http://forums.wz2100.net/download/file.php?id=3811&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3811&t=1" alt="" /></a></p>
<p>
This base may look less nasty than the previous one, but they have a <em>lot</em> of units that will attack you as you approach it.
</p>
<p>
It may take two or three push-retreats, but taking this base is otherwise no different than taking the others. There will be a Power Module artifact here.
</p>
<p>
You may be tempted to leave the circled structure alive so that you can use your leftover time to rebuild, research, etc, but it is unnecessary - the first half of the next stage is untimed.
</p>
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Power Module</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades power production to 125%</li><li>Gives new structure: Power Module</li></ul></td></tr>
</table></div><!--research table-->

<p class="backforward"><a href="alpha1">&laquo; Prev</a> </ul></td></tr>| <a href="alpha3">Next &raquo;</a></p>

',
		'cachedsb' => '<li><a href="#overview">Alpha 2: Power surge detected</a><ul><li><a href="#back">Back to the base</a></li><li><a href="#destroy">Destroy more outposts</a></li>'
	),
	'alpha3' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 3 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 3</strong>',
		'text' => '<h3 id="overview">Alpha 3: The power module artifact</h3> 
<h4 id="power">More power</h4> 
<p class="timer"><span>Time limit: <strong>unlimited</strong></span></p> 
<p> 
Well, this is the last time you\'ll have a mission with no timer until the end of the game. This mission ends when you upgrade your Power Generator with a Power Module. So as long as you don\'t do that, you\'ll have all the time in the world.
</p> 
<p> 
First, if you haven\'t done so already, it\'s time to recycle any of your machinegun tanks and turn them into twin machinegun tanks.
</p> 
<p> 
Next, do you see that road at the lower right edge of the map? If you thought there might be an attack from there later, you\'d be right. You don\'t have very many good defenses at this point in the game, so just make a few MG towers for now.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3812&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3812&t=1" alt="" /></a></p> 
<p> 
Now, some players like to leave the game running for a while, to accumulate power. Personally, I don\'t think this is necessary - you rarely run out of power in the campaign, and if you\'re doing something as cheap as accumulating power in an unlimited-time stage, you might as well just cheat.
</p> 
<p> 
Now let\'s get ready for the second half of this stage. The second half of this stage is fairly easy, but it does have a short time limit.
</p> 
<p> 
This stage will be your first away stage. You will take ten tanks to a different map to fight. Ten Twin Machinegun Viper Wheels should be enough, but some players prefer 9 TMGs and a truck, or 8 TMGs and two repair turrets, etc.
</p> 
<p> 
Bring your chosen ten units to the LZ (Landing Zone). That\'s the place in the middle of your base where there are lights that form an "X". Now you\'re ready. It\'s time to build that Power Module.
</p> 
<h4 id="neworders">New orders</h4> 
<p class="timer"><span>Time limit: <strong>15 minutes</strong></span></p> 
<p> 
Right after the Power Module finishes building, you get your new orders. Select your ten units, enter the transport, and let\'s go.
</p> 
<p> 
You\'ll land in a new map. If you brought your truck, now\'s the time to set up defenses:
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3814&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3814&t=1" alt="" /></a></p> 
<p> 
If you didn\'t, just bring your whole army with you on your attack. Your LZ will get overrun, but you can reclaim it on your way back.
</p> 
<p> 
Now, just march your tanks straight up (and a little bit to the right) to the enemy base. Scavengers will pull interesting stunts like trying to flank you, but you have enough firepower to handle them.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3815&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3815&t=1" alt="" /></a></p> 
<p> 
Here we are. Make sure to destroy that flamer tower before getting too close.
</p> 
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Heavy Machinegun</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/heavymachinegun">Heavy Machinegun</a></li></ul></td></tr> 
</table></div><!--research table--> 
<p> 
Now, just head back to the LZ, and we\'re done.
</p> 
 
<p class="backforward"><a href="alpha2">&laquo; Prev</a> </ul></td></tr>| <a href="alpha4">Next &raquo;</a></p>',
		'cachedsb' => '<li><a href="#overview">Alpha 3: The power module artifact</a><ul><li><a href="#power">More power</a></li><li><a href="#neworders">New orders</a></li>'
	),
	'alpha4' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 4 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 4</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha5' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 5 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 5</strong>',
		'text' => '<h3 id="overview">Alpha 5: Encoded signals detected</h3> 
<h4 id="prep">To the LZ</h4> 
<p class="timer"><span>Time limit: <strong>1 hour</strong></span></p> 
<p> 
So far, it\'s been pretty easy. Well, this time, it won\'t be. You get an hour, but since this stage gives you a bunch of useful research artifacts, it\'s best to rush through it so you have time left over to research them (not that that\'s easy). You\'ll need them for the next stage.
</p> 
<h4 id="arrival">Secure the zone</h4> 
<p> 
Once you arrive, you\'ll get a message from New Paradigm. It boils down to "Leave, or die." Of course, it wouldn\'t be a very fun game if we did either, so we\'ll be doing neither.
</p> 
<p> 
As usual, have your truck start building defenses.
</p> 
<p> 
Project HQ tells you they\'re near the bottom, and helpfully mark their location for you. Don\'t go there directly; it\'s a trap. Instead, follow the arrows on the minimap here:
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3828&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3828&t=1" alt="" /></a></p> 
<p> 
Now, set all your units to "Hold Fire" (and save the game). This is important, since you\'ll soon meet a New Paradigm sensor, and if you shoot it, NP will send a pretty big army to attack yours.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3829&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3829&t=1" alt="" /></a></p> 
<p> 
While in Hold Fire mode, you\'ll have to click on enemy scavengers manually. And yes, you did just see a cannon on a school bus.
</p> 
<p> 
Once the New Paradigm sensor is gone, move north until you see a scavenger base. Project HQ will decide that\'s enough, and let you call reinforcements.
</p> 
<p class="reinforcements"><span>Reinforcement time: <strong>2 minutes</strong></span></p> 
<p> 
Do so immediately. Get some of those Mortar Viper Half-Tracks, some more HMGs, anything you have. As you wait, start building some more defenses:
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3830&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3830&t=1" alt="" /></a></p> 
<p> 
Start building a sensor tower near the scavenger base, as well:
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3831&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3831&t=1" alt="" /></a></p> 
<p> 
Reinforcing a sensor tank also works, but it will have slightly less range than a sensor tower.
</p> 
<p> 
When your mortars arrive, assign them to your sensor, and they\'ll start attacking the scavenger base from afar (if you\'re using a sensor tank, target the scavenger base manually). You might get attacked by scavenger units, but your MG tanks should be able to deal with them.
</p> 
<p> 
Either way, make sure not to destroy the whole base (but do destroy their factory, so they can\'t send anything more at you). Now send an MG tank (in hold fire mode) over to grab that artifact. It\'s Light Cannon:
</p> 
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Light Cannon</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/lightcannon">Light Cannon</a></li></ul></td></tr> 
<tr><td class="l" valign="middle">* HEAT Cannon Shells</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades cannon damage to 130%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* HEAT Cannon Shells Mk2</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades cannon damage to 160%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* HEAT Cannon Shells Mk3</td><td class="c price">$112</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades cannon damage to 190%</li></ul></td></tr> 
</table></div><!--research table--> 
<p> 
The Light Cannon is better against the New Paradigm\'s tanks and structures than any of your other weapons so far, and it\'s also better at soaking damage. Design some Light Cannon Viper Half-Tracks, and start manufacturing them. If the New Paradigm hasn\'t attacked you yet, you might want to save here, as well.
</p> 
<p> 
While waiting for your cannon tanks to arrive, you might want to build another sensor tower northwest of you. You should see some New Paradigm forces, but as long as you don\'t get too close (or start shooting them), they should leave you alone. You might want to build some more MG towers, too:
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3833&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3833&t=1" alt="" /></a></p> 
<p> 
Move your machineguns back to the LZ to meet your new cannons. Well, now you should have your army of mixed machineguns and cannons, as well as some mortars.
</p> 
<p> 
Before we begin our attack, let\'s see what we\'re up against.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3835&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3835&t=1" alt="" /></a></p> 
<p> 
...yeah. Now do you see why we did so much preparation? Now for our plan:
</p> 
<p> 
1. Attach your mortars to the new sensor tower.
</p> 
<p> 
2. Move your MG units due east, and set them to retreat at heavy damage. They will end up overlooking a valley where scav units are poised to make a surprise strike on you. Fortunately, from the ledge above them, you should be able to gun down 80-100% of their force before they leave the valley.
</p> 
<p> 
3. <em>As soon as</em> the New Paradigm announces hostile intentions via cutscene, move your cannon tanks due east of where they are currently sitting, to just outside the range of the NP cannon-tower at the base\'s corner. Make sure they are set to Do or Die.
</p> 
<p> 
NP will first attack with a wave of lighter tanks. Your earlier MG towers should be able to handle them. Keep them constantly repaired with a truck, and the truck constantly repaired with a repair turret.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3836&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3836&t=1" alt="" /></a></p> 
<p> 
NP\'s stronger units will stay in their base. You can lure them out by having your mortars hit one of their structures (hit, no need to destroy). Make sure to retreat your mortars behind your MG towers immediately; mortars are fragile and you don\'t want one to get killed.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3837&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3837&t=1" alt="" /></a></p> 
<p> 
Wait for the enemy commander to come out, then ambush him with your cannons. You\'ll notice the commander has a <em>ton</em> of HP.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3838&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3838&t=1" alt="" /></a></p> 
<p> 
Pay attention to your units\' HP, and retreat any that fall to red. If done right, you should be able to pull this off with no casualties.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3839&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3839&t=1" alt="" /></a></p> 
<p> 
Start repairing everything now, and attacking NP\'s base defenses with mortars from afar. Remember to defend them with your cannons and MGs, as NP may still send some tanks every now and then.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3842&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3842&t=1" alt="" /></a></p> 
<p> 
Once the defenses are down, move in with your cannons. Make sure to set them to Hold Fire, since you\'ll be wanting to keep their sensor tower alive so the mission doesn\'t end early.
</p> 
<p> 
If all this strategy seems too much to you, I\'ve also heard that spamming 20 to 30 HMG Viper Half-tracks will also work. Make sure none of them are experienced units, though, since you\'ll probably lose quite a few of them.
</p> 
<p><a href="http://forums.wz2100.net/download/file.php?id=3841&mode=view"><img src="http://forums.wz2100.net/download/file.php?id=3841&t=1" alt="" /></a></p> 
<p> 
As mentioned earlier, there\'s a lot of useful tech in this base.
</p> 
<!--research table--><div style="max-width:800px;"><table width="100%" border="0" cellspacing="0">
<tr valign="top"><th class="l nb" width="35%">&nbsp;</th><th class="c" width="9%">Price</th><th class="l" width="56%" style="padding-left:20px;">Effect</th></tr>
<tr><td class="l" valign="middle">Factory Module</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Factory Module</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Medium Body - Cobra</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Gives new body: Cobra</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Medium Cannon</td><td class="c price">$150</td><td class="l"><ul style="padding-top:5px;"><li>Gives new turret: <a href="w/mediumcannon">Medium Cannon</a></li></ul></td></tr> 
<tr><td class="l" valign="middle">* Repair Facility</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Repair Facility</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Automated Factory Production</td><td class="c price">$ ?</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades factory production speed to 130%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Automated Factory Production Mk2</td><td class="c price">$75</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades factory production speed to 160%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Automated Factory Production Mk3</td><td class="c price">$ ?</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades factory production speed to 190%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Chaingun Upgrade</td><td class="c price">$112</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades machinegun rate of fire to 118%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Rapid Fire Chaingun</td><td class="c price">$150</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades machinegun rate of fire to 143%</li></ul></td></tr> 
<tr><td class="l" valign="middle">* Hyper Fire Chaingun</td><td class="c price">$212</td><td class="l"><ul style="padding-top:5px;"><li>Upgrades machinegun rate of fire to 182%</li></ul></td></tr> 
<tr><td class="l" valign="middle">Command Relay Center</td><td class="c price">$37</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Command Relay Center</a></li></ul></td></tr> 
<tr><td class="l" valign="middle">Hardcrete</td><td class="c price">$18</td><td class="l"><ul style="padding-top:5px;"><li>Gives new structure: Hardcrete Wall</li></ul></td></tr> 
</table></div><!--research table-->
<p style="color:red">TODO: Finish this list</p> 
<p> 
All of this takes around 20 minutes to research. While you\'re waiting, start demolishing all those structures you don\'t need; you\'ll get half your money back. Also open up your design screen. Your new combat units should be Heavy Machinegun Cobra Half-Tracks, Medium Cannon Cobra Half-Tracks, and Mortar Cobra Half-Tracks. 
</p> 
<p> 
Don\'t recycle your units yet. Wait until Alpha 6.
</p> 
<p> 
When you\'re ready, destroy that last sensor tower, and end the stage.
</p> 
 
<p class="backforward"><a href="alpha4">&laquo; Prev</a> </ul></td></tr>| <a href="alpha6">Next &raquo;</a></p>',
		'cachedsb' => '<li><a href="#overview">Alpha 5: Encoded signals detected</a><ul><li><a href="#prep">To the LZ</a></li><li><a href="#arrival">Secure the zone</a></li>'
	),
	'alpha6' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 6 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 6</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha7' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 7 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 7</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha8' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 8 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 8</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha9' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 9 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 9</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha10' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 10 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 10</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha11' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 11 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 11</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'alpha12' => array(
		'autogen' => TRUE,
		'title' => 'Alpha 12 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Alpha 12</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta1' => array(
		'autogen' => TRUE,
		'title' => 'Beta 1 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 1</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta2' => array(
		'autogen' => TRUE,
		'title' => 'Beta 2 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 2</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta3' => array(
		'autogen' => TRUE,
		'title' => 'Beta 3 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 3</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta4' => array(
		'autogen' => TRUE,
		'title' => 'Beta 4 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 4</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta5' => array(
		'autogen' => TRUE,
		'title' => 'Beta 5 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 5</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta6' => array(
		'autogen' => TRUE,
		'title' => 'Beta 6 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 6</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta7' => array(
		'autogen' => TRUE,
		'title' => 'Beta 7 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 7</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta8' => array(
		'autogen' => TRUE,
		'title' => 'Beta 8 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 8</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta9' => array(
		'autogen' => TRUE,
		'title' => 'Beta 9 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 9</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta10' => array(
		'autogen' => TRUE,
		'title' => 'Beta 10 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 10</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'beta11' => array(
		'autogen' => TRUE,
		'title' => 'Beta 11 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Beta 11</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma1' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 1 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 1</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma2' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 2 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 2</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma3' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 3 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 3</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma4' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 4 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 4</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma5' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 5 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 5</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma6' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 6 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 6</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma7' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 7 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 7</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma8' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 8 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 8</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'gamma9' => array(
		'autogen' => TRUE,
		'title' => 'Gamma 9 - Walkthrough',
		'titlebar' => '<span class="arrow">&raquo;</span> <a href="walkthrough">Walkthrough</a> <span class="arrow">&raquo;</span> <strong>Gamma 9</strong>',
		'text' => '',
		'cachedsb' => ''
	),
	'researchstrategy' => array(
		'autogen' => TRUE,
		'cachedsb' => ''
	),
	'formulas' => array(
		'cachedsb' => ''
	),
	'latestcomments' => array(
		'autogen' => TRUE,
		'title' => 'Latest comments',
		'titlebar' => '<a>Secret</a> <span class="arrow">&raquo;</span> <strong>Latest comments</strong>',
		'text' => '<?php
$comments = array();
function processcomments($id = false)
{
	global $comments, $_PERSIST;
	if (empty($id))
		$array = &$_PERSIST;
	else
		$array = &$_PERSIST[$id][\'subdirs\'];
	foreach ($array as $cid => $entry)
	{
		if (isset($entry[\'subdirs\']))
			processcomments($cid);
		else
			foreach ($entry as $curcomment)
			{
				$curcomment[\'id\'] = ($id?$id.\'/\':\'\').$cid;
				$comments[] = $curcomment;
			}
	}
}
function datecmp($a, $b)
{
	return 0-$a[\'time\']+$b[\'time\'];
}
processcomments();
usort($comments, \'datecmp\');
foreach ($comments as $i => $comment)
{
	if ($i==50) break;
	echo \'<p><em><strong>\'.htmlspecialchars($comment[\'name\']).\'</strong>\'.($comment[\'admin\']?\' <span style="color:#556688;font-size:10pt;">[Admin]</span>\':\'\').\' wrote \'.onreldate($comment[\'time\']).\' in <a href="\'.$comment[\'id\'].\'">\'.$comment[\'id\'].\'</a>:</em></p><blockquote><p>\'.($comment[\'htmlcomment\']?$comment[\'msg\']:nl2br(htmlspecialchars($comment[\'msg\']))).\'</p></blockquote>\';
}
?>',
		'cachedsb' => ''
	),
	'cheats' => array(
		'autogen' => TRUE,
		'title' => 'Cheats',
		'titlebar' => '<span class="arrow">&raquo;</span> <strong>Cheats</strong>',
		'text' => '<strong style="color:red">These instructions only apply to 2.3 beta 6 and higher. For older versions, see <a href="http://developer.wz2100.net/wiki/cheats">wiki:cheats</a></strong>
<h3 id="enabling">Enabling cheats</h3>
<p>
Before you can use cheat codes, you must either use the cheat code "<tt>cheat on</tt>" or press Shift+Backspace. You should get a "Cheats enabled" message when you do this.
</p>
<h3 id="using">Using cheats</h3>
<p>
To use a cheat code, press <kbd>Enter</kbd>, type the code, and press <kbd>Enter</kbd> again.
</p>
<p>
Cheats marked with "&#10003;" can crash the game. Try to avoid using them.
</p>
<table> 
<tr><td> <strong>Cheat Code</strong> </td><td colspan="2"> <strong>Cheat Description</strong> 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Controls</strong> 
</td></tr><tr><td> <tt>mouseflip</tt> </td><td> Inverts the mouse vertical rotation direction </td><td> 
</td></tr><tr><td> <tt>shakey</tt> </td><td> Toggle screen shake when units die </td><td> 
</td></tr><tr><td> <tt>time toggle</tt> </td><td> Turns the mission timer on or off (campaign mode only) </td><td> &#10003; 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Difficulty Levels</strong> 
</td></tr><tr><td> <tt>hard</tt> </td><td> Sets difficulty to hard (replaces previous difficulty) </td><td> 
</td></tr><tr><td> <tt>normal</tt> </td><td> Sets difficulty to normal (replaces previous difficulty) </td><td> 
</td></tr><tr><td> <tt>easy</tt> </td><td> Sets difficulty to easy (replaces previous difficulty) </td><td> 
</td></tr><tr><td> <tt>let me win</tt> </td><td> Causes you to win the current mission (campaign mode only) </td><td> &#10003; 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Misc. &amp; Info.</strong> 
</td></tr><tr><td> <tt>build info</tt> </td><td> Tells you the date when the game was built </td><td> 
</td></tr><tr><td> <tt>count me</tt> </td><td> Prints the number of objects in the game </td><td> 
</td></tr><tr><td> <tt>demo</tt> </td><td> Starts demo mode - See "Additional Cheats" for description </td><td> 
</td></tr><tr><td> <tt>droidinfo</tt> </td><td> Shows unit info &amp; stats </td><td> 
</td></tr><tr><td> <tt>no faults</tt> </td><td> Audio Clip - "There are no faults in the renderer at the moment" </td><td> 
</td></tr><tr><td> <tt>sensors</tt> </td><td> Shows sensor ranges when sensors are selected </td><td> 
</td></tr><tr><td> <tt>timedemo</tt> </td><td> Shows game info &amp; stats </td><td> 
</td></tr><tr><td> <tt>showorders</tt> </td><td> Shows current order &amp; action for selected droid </td><td> 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Power</strong> 
</td></tr><tr><td> <tt>more power</tt> </td><td> Adds an additional 1000 power </td><td> 
</td></tr><tr><td> <tt>superpower</tt> </td><td> Maximum power </td><td> 
</td></tr><tr><td> <tt>whale fin</tt> </td><td> Toggles infinite power </td><td> 
</td></tr><tr><td> <strong>Research</strong> 
</td></tr><tr><td> <tt>give all</tt> </td><td> Allows you to build &amp; research everything </td><td> &#10003; 
</td></tr><tr><td> <tt>research all</tt> </td><td> Gives you everything researched </td><td> 
</td></tr><tr><td> <tt>work harder</tt> </td><td> Finishes all active research </td><td> 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Strength &amp; Damage</strong> 
</td></tr><tr><td> <tt>biffer baker</tt> </td><td> Your units are stronger &amp; deal more damage </td><td>
</td></tr><tr><td> <tt>double up</tt> </td><td> Your units are twice as strong </td><td>
</td></tr><tr><td> <tt>get off my land</tt> </td><td> Kills all visible enemy units &amp; structures on the map </td><td> 
</td></tr><tr><td> <tt>kill</tt> </td><td> Kills the selected units </td><td> 
</td></tr><tr><td colspan="3"> 
</td></tr><tr><td colspan="3"> <strong>Weather</strong> 
</td></tr><tr><td> <tt>deity</tt> </td><td> Lets you see everything on the map (equivalent of having Uplink Center) </td><td> 
</td></tr><tr><td> <tt>john kettley</tt> </td><td> Changes the weather to rain, snow, or clear. Keep entering code to cycle weather. </td><td> 
</td></tr></table> 
',
		'cachedsb' => '<li><a href="#enabling">Enabling cheats</a></li><li><a href="#using">Using cheats</a>'
	)
);
?>
