/*
 * Copyright 2023 KylinSoft Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <QString>

namespace Upm {

#define UPM_MODALIAS_PATH  QStringLiteral("/sys/class/dmi/id/modalias")
#define UPM_CPU_INFO_PATH  QStringLiteral("/proc/cpuinfo")
#define UPM_GLOBAL_CONFIG  QStringLiteral("/etc/ukui/ukui-power-manager/upm-global.conf")

#define UPM_POWER_MODE_BALANCE_SCHEMA  QStringLiteral("power-mode-default-balance")
#define UPM_LENOVO_BACKLIGHT   QStringLiteral("lenovo_backlight")
#define UPM_POWER_IIC_SCHEMA   QStringLiteral("iic-white-list")
#define UPM_POWER_PCI_SCHEMA   QStringLiteral("pci-white-list")
#define UPM_POWER_SATA_SCHEMA  QStringLiteral("sata-white-list")

#define UPM_POWER_MODE_BALANCE_KEY        QStringLiteral("boardName")
#define UPM_LENOVO_BOARD_NAME_KEY         QStringLiteral("boardName")

#define POWER_MANAGER_SETTINGS   ("org.ukui.power-manager")
#define POWER_POLICY_AC  QStringLiteral("powerPolicyAc")        //电源策略(0:性能 1:平衡 2:节能)
#define POWER_POLICY_BATTERY  QStringLiteral("powerPolicyBattery")      //电源策略(0:性能 1:平衡 2:节能)
#define PRE_POWER_MODE    QStringLiteral("preprocessPowerMode")


enum powerMode{
    Performance = 0,
    Balance,
    EnergySaving,
};

}
