#encoding: utf-8
#- Name: SiSU
#
#  - Description: documents, structuring, processing, publishing, search
#    utils
#
#  - Author: Ralph Amissah
#    <ralph.amissah@gmail.com>
#
#  - Copyright: (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006,
#    2007, 2008, 2009, 2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2019,
#    2020, 2021, Ralph Amissah,
#    All Rights Reserved.
#
#  - License: GPL 3 or later:
#
#    SiSU, a framework for document structuring, publishing and search
#
#    Copyright (C) Ralph Amissah
#
#    This program is free software: you can redistribute it and/or modify it
#    under the terms of the GNU General Public License as published by the Free
#    Software Foundation, either version 3 of the License, or (at your option)
#    any later version.
#
#    This program is distributed in the hope that it will be useful, but WITHOUT
#    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
#    FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
#    more details.
#
#    You should have received a copy of the GNU General Public License along with
#    this program. If not, see <http://www.gnu.org/licenses/>.
#
#    If you have Internet connection, the latest version of the GPL should be
#    available at these locations:
#    <http://www.fsf.org/licensing/licenses/gpl.html>
#    <http://www.gnu.org/licenses/gpl.html>
#
#    <http://www.sisudoc.org/sisu/en/manifest/gpl.fsf.html>
#
#  - SiSU uses:
#    - Standard SiSU markup syntax,
#    - Standard SiSU meta-markup syntax, and the
#    - Standard SiSU object citation numbering and system
#
#  - Homepages:
#    <http://www.sisudoc.org>
#
#  - Git
#    <https://git.sisudoc.org/projects/>
#    <https://git.sisudoc.org/projects/?p=software/sisu.git;a=summary>
#    <https://git.sisudoc.org/projects/?p=markup/sisu-markup-samples.git;a=summary>
module SiSU_SpellUtility
  class Spell
    def initialize(input,filesrc,flg)
      @flg=flg
      @filename, @filetype = /(.+?)(\.\w\w\w0$)/.match(filesrc)[1,2] #.gsub(/\.\w\w\w0$/, "")
      @input=input
      @allwords=[]
      puts @filename
      @speller='aspell' # 'ispell'
      @dictionary='british'
      @lang='en_GB'
    end
    def check
      @input.each do |data|
        data=data.gsub(/(https?|www|ftp|gopher|png|jpg|gif|html|htm)\S+/i,' ').
          gsub(/(&nbsp;|#{Mx[:nbsp]})/i,' ').
          gsub(/<\/?(table|tr|td|b|p|href).*?>/i,' ').
          gsub(/(<==.+|<:\S+>|<!.+?!>|^@\S+?:.+|\{\{\{|~)/,' ').
          gsub(/(["|<>)(\n'`.;&_-]|\=)/,' ').
          gsub(/\b(altExternal|
            target|externalimg|
            srcimagebext|
            img|src|toc|pdf|
            cd|org|
            helvetica|roman
            )\b/i,' ').
          gsub(/EOF/,'')
        @words=data.scan(/\S+/)
        @words.each { |y| @allwords << y }
      end
      @allwords=@allwords.uniq
      if @flg =~ /S/
        File.open('/home/ralph/spell_error','a+') do |file| #fix
          file.puts %{\n\n[ #{@filename} ]}
        end
        @allwords.each { |y| puts y.inspect; system(%{cat #{y} | /usr/bin/#{@speller} -l -d #{@dictionary} >> ~/spell_error })}
      else
        @allwords.each { |y| sp=%x{echo #{y}|#{@speller} -l }; puts sp unless sp.empty?}
      end
    end
  end
end
__END__
