# 2021-12-28 Triage Log

Relatively quiet week, mostly rustdoc improvements.

Triage done by **@simulacrum**.
Revision range: [3d57c61a9e04dcd3df633f41142009d6dcad4399..e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4](https://perf.rust-lang.org/?start=3d57c61a9e04dcd3df633f41142009d6dcad4399&end=e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4&absolute=false&stat=instructions%3Au)

2 Regressions, 1 Improvements, 6 Mixed; 0 of them in rollups
26 comparisons made in total

#### Regressions

Fix bad caching of `~const Drop` bounds [#92149](https://github.com/rust-lang/rust/issues/92149)
- Moderate regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=3d57c61a9e04dcd3df633f41142009d6dcad4399&end=8ad3c1dd1d47f9ce7dfdf4a14c70c67e1790b0f5&stat=instructions:u) (up to 2.6% on `incr-patched: println` builds of `regression-31157`)
- Necessary fix for correctness.

Add `#[inline]` modifier to `TypeId::of` [#92135](https://github.com/rust-lang/rust/issues/92135)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=aad4f1039fd5d6bf961ed08eebc6eb69b577f1be&end=475b00aa4037461b506539a06d15ca6091b461a7&stat=instructions:u) (up to 4.4% on `full` builds of `keccak`)
- Reverted in a later pull request, unclear what the exact cause of the
  regression is.

#### Improvements

:arrow_up: rust-analyzer [#92247](https://github.com/rust-lang/rust/issues/92247)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=83bde52116c704fa2a5244e035c6f61a1fea8a85&end=67491a22dbafc275b1549c31876c1fd356bd51cc&stat=instructions:u) (up to -1.2% on `incr-unchanged` builds of `deeply-nested-async`)
- Likely spurious change, rust-analyzer performance is not directly related.

Remove `PartialOrd`, `Ord` from `LocalDefId` [#90408](https://github.com/rust-lang/rust/issues/90408)
- Large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=34926f0a1681458588a2d4240c0715ef9eff7d35&end=e98309298d927307c5184f4869604bd068d26183&stat=instructions:u) (up to -3.7% on `full` builds of `deeply-nested-async`)
- Overall an improvement; largely a correctness change as relative ordering of
  DefId's isn't tracked by incremental compilation.

Do not display `~const Drop` in rustdoc [#92229](https://github.com/rust-lang/rust/issues/92229)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=475b00aa4037461b506539a06d15ca6091b461a7&end=83bde52116c704fa2a5244e035c6f61a1fea8a85&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)
- Likely to be just noise, no clear explanation for changes to rustc performance
  from rustdoc changes.

Rustdoc: use `is_doc_hidden` method on more places [#92227](https://github.com/rust-lang/rust/issues/92227)
- Very large improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=67491a22dbafc275b1549c31876c1fd356bd51cc&end=c096176fb411c90a8b0226901c11e7edd131192f&stat=instructions:u) (up to -9.3% on `full` builds of `helloworld`)

intra-doc: Use an enum to represent URL fragments [#92088](https://github.com/rust-lang/rust/issues/92088)
- Small improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=41ce641a407965ca0709f9f2d60faae3a56755c2&end=cc65bf3ded93352fd4693a9c58b84a60721637a6&stat=instructions:u) (up to -0.8% on `incr-unchanged` builds of `externs`)

rustc_metadata: Switch crate data iteration from a callback to iterator [#92159](https://github.com/rust-lang/rust/issues/92159)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=cc65bf3ded93352fd4693a9c58b84a60721637a6&end=e91ad5fc62bdee4a29c18baa5fad2ca42fc91bf4&stat=instructions:u) (up to -1.3% on `incr-unchanged` builds of `deeply-nested-async`)

#### Mixed

Backport LLVM changes to disable deferred inlining [#92110](https://github.com/rust-lang/rust/issues/92110)
- Moderate improvement in [instruction counts](https://perf.rust-lang.org/compare.html?start=489296d82561f596c278e90edc10eb56168ab623&end=77497c74f9268ccf91d7b4c17f23bf07117d7433&stat=instructions:u) (up to -8.3% on `incr-patched: println` builds of `regression-31157`)
- Large regression in [instruction counts](https://perf.rust-lang.org/compare.html?start=489296d82561f596c278e90edc10eb56168ab623&end=77497c74f9268ccf91d7b4c17f23bf07117d7433&stat=instructions:u) (up to 2.8% on `full` builds of `deeply-nested`)
- Avoids an extreme regression in LLVM, which was blocking migration onto the
  new pass manager (and so newer rustc versions) for some crates.
