An unstable feature in `const` contexts was used.

Erroneous code example:

```compile_fail,E0723
const fn foo<T: Copy>(_: T) { // error!
   // ...
}
```

To enable this feature on a nightly version of rustc, add the `const_fn`
feature flag:

```
#![feature(const_fn)]

const fn foo<T: Copy>(_: T) { // ok!
   // ...
}
```
