A feature name is missing.

Erroneous code example:

```compile_fail,E0546
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(issue = "none")] // invalid
fn unstable_fn() {}

#[stable(since = "1.0.0")] // invalid
fn stable_fn() {}
```

To fix the issue you need to provide a feature name.

```
#![feature(staged_api)]
#![stable(since = "1.0.0", feature = "test")]

#[unstable(feature = "unstable_fn", issue = "none")] // ok!
fn unstable_fn() {}

#[stable(feature = "stable_fn", since = "1.0.0")] // ok!
fn stable_fn() {}
```
