Welcome, we are a kind, open-minded, simple community. All help welcome, in any way you can think of.

## Coding
**Remmina** uses the [fork and pull](https://stackoverflow.com/questions/11582995/what-is-the-fork-pull-model-in-github) model.
If you&#8217;d like to make changes to this project, the following steps will get you there!

  1. Fork [this repo](https://gitlab.com/Remmina/Remmina/forks/new)
  2. Make your changes
  3. [Submit a merge request](https://gitlab.com/Remmina/Remmina/merge_requests/new)

The [wiki](https://gitlab.com/Remmina/Remmina/wikis/home) has details on how to compile Remmina and FreeRDP.
Look for issues labeled [&#8220;help wanted&#8221;](https://gitlab.com/Remmina/Remmina/issues?label_name%5B%5D=help+wanted). There are also paid bounties available.
Know how to fix a bug or implement anything requested or completely new, but lack the time? Get in touch, **We can pay for some hours of your time. Don't be shy.**

### Fix existing bugs
In general, this is the most important task.
To see all the issues already labeled as bugs, you can use [this query](https://gitlab.com/Remmina/Remmina/issues?label_name%5B%5D=bug)

### Implement most wanted features and fixes (_bounty $305_)
Similarly, we have a quite important list of feature requests, that are labeled as [enhancement](https://gitlab.com/Remmina/Remmina/issues?label_name%5B%5D=enhancement&sort=created_date&state=opened), of which some that have a [bounty](https://gitlab.com/Remmina/Remmina/issues?scope=all&utf8=%E2%9C%93&state=opened&label_name[]=enhancement&label_name[]=bounty) for those that will be able to implement them.
  * [#476](https://gitlab.com/Remmina/Remmina/issues/476) : Favorite and recent connections [$5]
  * [#376](https://gitlab.com/Remmina/Remmina/issues/376) : RDP: Multi monitor support [$15]

### Internal projects
  * Refactoring [remmina\_connection\_window.c](https://gitlab.com/Remmina/Remmina/blob/master/src/remmina_connection_window.c) as it is big, complicated and hard to extend.
  * Simplify the user interface.
  * Separate plugin processes from the main process to improve stability.
  * Write an additional plugin system to write plugins also in Python and eventually Ruby.

## Documentation
Submit user and developer guides in any (accessible) format you want (screencasts, PDF, HTML, Open Document, .gs, .ps, LaTeX, GitLab wiki , etc).
* [Wiki](https://gitlab.com/Remmina/Remmina/wikis/home)
* [Dev documentation](https://remmina.gitlab.io/remminadoc.gitlab.io)
Commenting the source code and writing checks is also an ongoing process.

## Donating
Financial contributions help make Remmina a lot.
More info to be found on the [Remmina website donation page](/donations/).
[List of all the great supporters](https://remmina.org/donations/#donors).

## Merchandise
From our store on [TEEPUBLIC](http://tee.pub/lic/CfbUoWiygXM) you can get [mugged](http://tee.pub/lic/fgVKOyGjHgc), your ThinkPad [covered](http://tee.pub/lic/fgVKOyGjHgc) and clad in this most compelling [T-shirt](http://tee.pub/lic/fgVKOyGjHgc).

## Report bugs, ideas, issues
Install it, use it and report What doesn&#8217;t work, is missing, or ugly. Don&#8217;t hesitate to let us know.
For bug and feature requests, use [GitLab issues](https://gitlab.com/Remmina/Remmina/issues) or ask on IRC. #remmina on freenode.

## Screenshots
Send in pictures or screengrabs of your setup.

## Translation
Help translate Remmina to your language.
* [Weblate](https://hosted.weblate.org/projects/remmina/)

## Videos
- As short as you can. Around 2 minutes to maximum 4 minutes.
- Avoid showing copyrighted and distracting content, even custom/other desktop icons should not be shown.

Videos demonstrating different ways to use Remmina, the more the merrier!
The original video is needed, as it will be uploaded to video streaming services, if you need support let us know.
These would make good topics for videos:

- Configuration and use of a basic RDP profile, quickly showing the most common controls (resizes, toolbar placement, screenshots, …).
- Creation of a default profile.
- Cration of and connection to a VNC server.
- Using a basic SSH tunnel.

### Disclaimer
Your video will be uploaded to video streaming services, under the respective Remmina account at each site.
You can add a watermark with the details you want to share, and a caption will be added in the linked video.
Pick a suitable license, like CC-BY-SA 4.0-intl.
Sending an unedited video is fine too.

### Desktop/screen video recorder
- [SimpleScreenRecorder](https://www.maartenbaert.be/simplescreenrecorder/)
- [OBS Studio](https://obsproject.com/)

### Video editors
There are many video editors for Linux|GNU. [OpenShot](https://www.openshot.org/) is good.
To produce good looking videos choose a 1080p profile.

### Share your videos with us
If you don't want to use reep.io, get in contact at admin@remmina.org.
[reep.io](https://reep.io/) is a P2P file-sharing system, meaning there are no servers in the middle.