% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notin.R
\name{\%nin\%}
\alias{\%nin\%}
\title{Value matching}
\usage{
x \%nin\% y
}
\arguments{
\item{x}{Vector with values to be matched.}

\item{y}{Vector with values to be matched against.}
}
\value{
A logical vector, indicating if a match was \emph{not} located for each element
        of \code{x}, thus the values are \code{TRUE} or \code{FALSE} and
        never \code{NA}.
}
\description{
\%nin\% is the complement to \%in\%. It looks which values
             in \code{x} do \emph{not} match (hence, are \emph{not in})
             values in \code{y}.
}
\details{
See 'Details' in \code{\link{match}}.
}
\examples{
c("a", "B", "c") \%in\% letters
c("a", "B", "c") \%nin\% letters

c(1, 2, 3, 4) \%in\% c(3, 4, 5, 6)
c(1, 2, 3, 4) \%nin\% c(3, 4, 5, 6)

}
