% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/popify.R
\name{popify}
\alias{popify}
\title{popify}
\usage{
popify(el, title, content, placement = "bottom", trigger = "hover",
  options = NULL)
}
\arguments{
\item{el}{A shiny UI element.}

\item{title}{The title of the popover.}

\item{content}{The main content of the popover.}

\item{placement}{Where the popover should appear relative to its target
(\code{top}, \code{bottom}, \code{left}, or \code{right}). Defaults to \code{"bottom"}.}

\item{trigger}{What action should cause the popover to appear? (\code{hover},
\code{focus}, \code{click}, or \code{manual}). Defaults to \code{"hover"}.}

\item{options}{A named list of additional options to be set on the popover.}
}
\description{
\code{popify} can be wrapped around any shiny UI element to add a popover to the
wrapped element. This should be a safer way to add popovers to elements created with
\code{\link{renderUI}}.
}
\details{
See \link{Tooltips_and_Popovers} for more information about how to use \code{popify} with the
rest of the Tooltips_and_Popovers family.
}
\note{
Run \code{bsExample("Tooltips_and_Popovers")} for an example
of \code{popify} functionality.
}
\seealso{
\href{http://getbootstrap.com}{Twitter Bootstrap 3}

Other Tooltips_and_Popovers: \code{\link{Tooltips_and_Popovers}};
  \code{\link{addPopover}}; \code{\link{addTooltip}};
  \code{\link{bsPopover}}; \code{\link{bsTooltip}};
  \code{\link{removePopover}}; \code{\link{removeTooltip}};
  \code{\link{tipify}}
}

