% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R, R/preprocessing.R
\name{LoadXenium}
\alias{LoadXenium}
\alias{ReadXenium}
\title{Read and Load 10x Genomics Xenium in-situ data}
\usage{
LoadXenium(
  data.dir,
  fov = "fov",
  assay = "Xenium",
  mols.qv.threshold = 20,
  cell.centroids = TRUE,
  molecule.coordinates = TRUE,
  segmentations = NULL,
  flip.xy = FALSE
)

ReadXenium(
  data.dir,
  outs = c("segmentation_method", "matrix", "microns"),
  type = "centroids",
  mols.qv.threshold = 20,
  flip.xy = F
)
}
\arguments{
\item{data.dir}{Directory containing all Xenium output files with
default filenames}

\item{fov}{FOV name}

\item{assay}{Assay name}

\item{mols.qv.threshold}{Remove transcript molecules with
a QV less than this threshold. QV >= 20 is the standard threshold
used to construct the cell x gene count matrix.}

\item{cell.centroids}{Whether or not to load cell centroids}

\item{molecule.coordinates}{Whether or not to load molecule pixel coordinates}

\item{segmentations}{One of "cell", "nucleus" or NULL (to load either cell
segmentations, nucleus segmentations or neither)}

\item{flip.xy}{Whether or not to flip the x/y coordinates of the Xenium outputs
to match what is displayed in Xenium Explorer, or fit on your screen better.}

\item{outs}{Types of molecular outputs to read; choose one or more of:
\itemize{
 \item \dQuote{matrix}: the counts matrix
 \item \dQuote{microns}: molecule coordinates
 \item \dQuote{segmentation_method}: cell segmentation method (for runs which
 use multi-modal segmentation)
}}

\item{type}{Type of cell spatial coordinate matrices to read; choose one
or more of:
\itemize{
 \item \dQuote{centroids}: cell centroids in pixel coordinate space
 \item \dQuote{segmentations}: cell segmentations in pixel coordinate space
 \item \dQuote{nucleus_segmentations}: nucleus segmentations in pixel coordinate space
}}
}
\value{
\code{LoadXenium}: A \code{\link[SeuratObject]{Seurat}} object

\code{ReadXenium}: A list with some combination of the
following values:
\itemize{
 \item \dQuote{\code{matrix}}: a
 \link[Matrix:dgCMatrix-class]{sparse matrix} with expression data; cells
  are columns and features are rows
 \item \dQuote{\code{centroids}}: a data frame with cell centroid
  coordinates in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{cell}
 \item \dQuote{\code{pixels}}: a data frame with molecule pixel coordinates
  in three columns: \dQuote{x}, \dQuote{y}, and \dQuote{gene}
}
}
\description{
Read and Load 10x Genomics Xenium in-situ data
}
\concept{preprocessing}
