% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eta_squared.R
\name{eta_squared}
\alias{eta_squared}
\alias{partial_eta_squared}
\title{Effect Size for ANOVA}
\usage{
eta_squared(model)

partial_eta_squared(model)
}
\arguments{
\item{model}{an object of class aov or anova.}
}
\value{
a numeric vector with the effect size statistics
}
\description{
Compute eta-squared and partial eta-squared for all terms in an
  ANOVA model.
}
\section{Functions}{
\itemize{
\item \code{eta_squared}: compute eta squared

\item \code{partial_eta_squared}: compute partial eta squared.
}}

\examples{
# Data preparation
df <- ToothGrowth
df$dose <- as.factor(df$dose)

# Compute ANOVA
res.aov <- aov(len ~ supp*dose, data = df)
summary(res.aov)

# Effect size
eta_squared(res.aov)
partial_eta_squared(res.aov)
}
