% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lst.R
\name{lst}
\alias{lst}
\title{Build a list}
\usage{
lst(...)
}
\arguments{
\item{...}{Named or unnamed elements of a list. If the element is unnamed, its
expression will be used as its name.}
}
\value{
A named list.
}
\description{
\code{lst()} constructs a list, similar to \code{\link[base:list]{base::list()}}, but where components
are built sequentially. When defining a component, you can refer to components
created earlier in the call. \code{lst()} also generates missing names
automatically.
}
\examples{
# the value of n can be used immediately in the definition of x
lst(n = 5, x = runif(n))

# missing names are constructed from user's input
lst(1:3, z = letters[4:6], runif(3))

a <- 1:3
b <- letters[4:6]
lst(a, b)
}
