% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_gmm.R
\name{mtest}
\alias{mtest}
\title{Arellano--Bond Test of Serial Correlation}
\usage{
mtest(object, order = 1, vcov = NULL)
}
\arguments{
\item{object}{an object of class \code{"pgmm"},}

\item{order}{the order of the serial correlation (1 or 2),}

\item{vcov}{a matrix of covariance for the coefficients or a function to
compute it.}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of serial correlation for models estimated by GMM
}
\details{
The Arellano--Bond test is a test of correlation based on the residuals of
the estimation. By default, the computation is done with the standard
covariance matrix of the coefficients.  A robust estimator of this
covariance matrix can be supplied with the \code{vcov} argument.
}
\examples{

data("EmplUK", package = "plm")
ar <- pgmm(log(emp) ~ lag(log(emp), 1:2) + lag(log(wage), 0:1) +
           lag(log(capital), 0:2) + lag(log(output), 0:2) | lag(log(emp), 2:99),
           data = EmplUK, effect = "twoways", model = "twosteps")
mtest(ar, order = 1)
mtest(ar, order = 2, vcov = vcovHC)

}
\references{
\insertCite{AREL:BOND:91}{plm}
}
\seealso{
\code{\link[=pgmm]{pgmm()}}
}
\author{
Yves Croissant
}
\keyword{htest}
