% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{with_log_threshold}
\alias{with_log_threshold}
\title{Evaluate R expression with a temporarily updated log level threshold}
\usage{
with_log_threshold(
  expression,
  threshold = ERROR,
  namespace = "global",
  index = 1
)
}
\arguments{
\item{expression}{R command}

\item{threshold}{\code{\link[=log_levels]{log_levels()}}}

\item{namespace}{logger namespace}

\item{index}{index of the logger within the namespace}
}
\description{
Evaluate R expression with a temporarily updated log level threshold
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
log_threshold(TRACE)
log_trace("Logging everything!")
x <- with_log_threshold(
  {
    log_info("Now we are temporarily suppressing eg INFO messages")
    log_warn("WARN")
    log_debug("Debug messages are suppressed as well")
    log_error("ERROR")
    invisible(42)
  },
  threshold = WARN
)
x
log_trace("DONE")
\dontshow{logger:::namespaces_set(old)}
}
