% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{log_appender}
\alias{log_appender}
\title{Get or set log record appender function}
\usage{
log_appender(appender = NULL, namespace = "global", index = 1)
}
\arguments{
\item{appender}{function delivering a log record to the
destination, eg \code{\link[=appender_console]{appender_console()}}, \code{\link[=appender_file]{appender_file()}} or
\code{\link[=appender_tee]{appender_tee()}}, default NULL}

\item{namespace}{logger namespace}

\item{index}{index of the logger within the namespace}
}
\description{
Get or set log record appender function
}
\examples{
\dontshow{old <- logger:::namespaces_set()}
## change appender to "tee" that writes to the console and a file as well
t <- tempfile()
log_appender(appender_tee(t))
log_info(42)
log_info(43)
log_info(44)
readLines(t)

## poor man's tee by stacking loggers in the namespace
t <- tempfile()
log_appender(appender_stdout)
log_appender(appender_file(t), index = 2)
log_info(42)
readLines(t)
\dontshow{logger:::namespaces_set(old)}
}
\seealso{
Other log configutation functions: 
\code{\link{log_formatter}()},
\code{\link{log_layout}()},
\code{\link{log_threshold}()}
}
\concept{log configutation functions}
