% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.r
\name{theme_article}
\alias{theme_article}
\title{Theme with minimalistic (and opinionated) defaults suitable for publication}
\usage{
theme_article(base_size = 11, base_family = "")
}
\arguments{
\item{base_size}{base font size}

\item{base_family}{base font family}
}
\description{
Theme with minimalistic (and opinionated) defaults suitable for publication
}
\examples{
library(ggplot2)

d = data.frame(
  x = 1:90,
  y = rnorm(90),
  red = rep(letters[1:3], 30),
  blue = c(rep(1, 30), rep(2, 30), rep(3, 30)))

p <- ggplot(d) +
  geom_point(aes(x = x, y = y)) +
  facet_grid(red ~ blue)
tag_facet(p + theme_article())
p + theme_presentation()

# example of use with cairo device
# ggsave("fig_talk.pdf", p + theme_presentation("Source Sans Pro"), 
#          width=14, height=7, device = cairo_pdf, bg='transparent')
}
