% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockData.R
\name{.mockRefData}
\alias{.mockRefData}
\alias{.mockTestData}
\title{Mock data for examples}
\usage{
.mockRefData(ngroups = 5, nreps = 4, ngenes = 1000, prop = 0.5)

.mockTestData(mock.ref, ncells = 100)
}
\arguments{
\item{ngroups}{Integer scalar specifying the number of groups.}

\item{nreps}{Integer scalar specifying the number of replicates per group.}

\item{ngenes}{Integer scalar specifying the number of genes in the dataset.}

\item{prop}{Numeric scalar specifying the proportion of genes that are DE between groups.}

\item{mock.ref}{A \linkS4class{SummarizedExperiment} object produced by \code{.mockRefData}.}

\item{ncells}{Integer scalar specifying the number of cells to simulate.}
}
\value{
Both functions return a \linkS4class{SummarizedExperiment} object containing simulated counts in the \code{counts} assay,
with the group assignment of each sample in the \code{"label"} field of the \code{\link{colData}}.
}
\description{
Make up some test and reference data for the various examples in the \pkg{SingleR} package.
}
\details{
This functions are simply provided to simulate some data in the Examples of the documentation.
The simulations are very simple and should not be used for performance comparisons.
}
\examples{
ref <- .mockRefData()
test <- .mockTestData(ref)

}
\author{
Aaron Lun
}
