% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addPerCellQC.R
\name{addPerCellQC}
\alias{addPerCellQC}
\alias{addPerFeatureQC}
\title{Add QC metrics to a SummarizedExperiment}
\usage{
addPerCellQC(x, ...)

addPerFeatureQC(x, ...)
}
\arguments{
\item{x}{A \linkS4class{SummarizedExperiment} object or one of its subclasses.}

\item{...}{For \code{addPerCellQC}, further arguments to pass to \code{\link{perCellQCMetrics}}.

For \code{addPerFeatureQC}, further arguments to pass to \code{\link{perFeatureQCMetrics}}.}
}
\value{
\code{x} is returned with the QC metrics added to the row or column metadata.
}
\description{
Convenient utilities to compute QC metrics and add them to a \linkS4class{SummarizedExperiment}'s row or column metadata.
}
\details{
These functions are simply wrappers around \code{\link{perCellQCMetrics}} and \code{\link{perFeatureQCMetrics}}, respectively.
The computed QC metrics are automatically appended onto the existing \code{\link{colData}} or \code{\link{rowData}}.
No protection is provided against duplicated column names.
}
\examples{
example_sce <- mockSCE()
example_sce <- addPerCellQC(example_sce)
colData(example_sce)

example_sce <- addPerFeatureQC(example_sce)
rowData(example_sce)

}
\seealso{
\code{\link{perCellQCMetrics}} and \code{\link{perFeatureQCMetrics}}, which do the actual work.
}
\author{
Aaron Lun
}
