% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setMappingBiasVcf.R
\name{setMappingBiasVcf}
\alias{setMappingBiasVcf}
\title{Set Mapping Bias VCF}
\usage{
setMappingBiasVcf(
  vcf,
  tumor.id.in.vcf = NULL,
  mapping.bias.file = NULL,
  smooth = TRUE,
  smooth.n = 5
)
}
\arguments{
\item{vcf}{\code{CollapsedVCF} object, read in with the \code{readVcf}
function from the VariantAnnotation package.}

\item{tumor.id.in.vcf}{Id of tumor in case multiple samples are stored in
VCF.}

\item{mapping.bias.file}{A precomputed mapping bias database 
obtained by \code{\link{calculateMappingBiasVcf}}.
instead.
reference and alt counts as AD genotype field. Should be compressed and}

\item{smooth}{Impute mapping bias of variants not found in the panel by
smoothing of neighboring SNPs. Requires \code{mapping.bias.file}.}

\item{smooth.n}{Number of neighboring variants used for smoothing.}
}
\value{
Adds elements to the \code{vcf} \code{INFO} field
\item{bias}{A \code{numeric(nrow(vcf))} 
vector with the mapping bias of for each
variant in the \code{CollapsedVCF}. Mapping bias is expected as scaling
factor. Adjusted allelic fraction is (observed allelic fraction)/(mapping
bias). Maximum scaling factor is 1 and means no bias.}
\item{pon.count}{A \code{numeric(nrow(vcf))} vector with the number
of hits in the \code{mapping.bias.file}.}
\item{shape1, shape2}{Fit of a beta distribution.}
}
\description{
Function to set mapping bias for each variant in the provided
\code{CollapsedVCF} object. By default, it returns the same value for all
variants, but a mapping bias file can be provided for position-specific
mapping bias calculation.
}
\examples{

# This function is typically only called by runAbsoluteCN via 
# fun.setMappingBiasVcf and args.setMappingBiasVcf.
vcf.file <- system.file("extdata", "example.vcf.gz", package="PureCN")
vcf <- readVcf(vcf.file, "hg19")
vcf.bias <- setMappingBiasVcf(vcf)        

}
\author{
Markus Riester
}
