% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringConvenience.R
\docType{methods}
\name{posCtrlNorm,RccSet-method}
\alias{posCtrlNorm,RccSet-method}
\alias{posCtrlNorm}
\title{Positive control normalization}
\usage{
\S4method{posCtrlNorm}{RccSet}(rccSet, summaryFunction = "sum",
  quietly = FALSE)
}
\arguments{
\item{rccSet}{An RccSet object.}

\item{summaryFunction}{Function to be used for the normalization (e.g. "mean", "median", or
"sum"). User-defined functions similar to these can be specified here as
well.}

\item{quietly}{Logical. If TRUE, messages and warnings will not be shown.}
}
\value{
A copy of the input RccSet that has count data adjusted by positive control
counts. The positive control scaling factor is recorded in PosFactor in the
output's phenoData (if this column already exists in the input, it will
be overwritten in the output copy).
}
\description{
Applies positive control normalization to the data in an RccSet object.
}
\examples{
data(example_rccSet)
pcnorm_example_rccSet <- posCtrlNorm(example_rccSet)

}
\author{
Dorothee Nickles
}
