% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expr_models.R
\name{fitModel}
\alias{fitModel}
\title{Fits a model for each gene in a CellDataSet object.}
\usage{
fitModel(cds, modelFormulaStr = "~sm.ns(Pseudotime, df=3)",
  relative_expr = TRUE, cores = 1)
}
\arguments{
\item{cds}{the CellDataSet upon which to perform this operation}

\item{modelFormulaStr}{a formula string specifying the model to fit for the genes.}

\item{relative_expr}{Whether to fit a model to relative or absolute expression. Only meaningful for count-based expression data. If TRUE, counts are normalized by Size_Factor prior to fitting.}

\item{cores}{the number of processor cores to be used during fitting.}
}
\value{
a list of VGAM model objects
}
\description{
This function fits a vector generalized additive model (VGAM) from the VGAM package for each gene in a CellDataSet.
By default, expression levels are modeled as smooth functions of the Pseudotime value of each
cell. That is, expression is a function of progress through the biological process.  More complicated formulae can be provided to account for
additional covariates (e.g. day collected, genotype of cells, media conditions, etc).
}
\details{
This function fits a vector generalized additive model (VGAM) from the VGAM package for each gene in a CellDataSet.
By default, expression levels are modeled as smooth functions of the Pseudotime value of each
cell. That is, expression is a function of progress through the biological process.  More complicated formulae can be provided to account for
additional covariates (e.g. day collected, genotype of cells, media conditions, etc).
}
