% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMethods.R
\name{getTrainData}
\alias{getTrainData}
\title{getTrainData}
\usage{
getTrainData(object, views = "all", features = "all",
  as.data.frame = FALSE)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}

\item{views}{character vector with the view name(s), or numeric vector with the view index(es). 
Default is "all".}

\item{features}{list of character vectors with the feature names or
 list of numeric vectors with the feature indices. 
Default is "all"}

\item{as.data.frame}{logical indicating whether to return a long data frame instead of a list of matrices.
Default is \code{FALSE}.}
}
\value{
A list with one numeric matrix per view, containing the parsed data used to fit the MOFA model.
}
\description{
Fetch the training data
}
\details{
By default this function returns a list where each element
 is a data matrix with dimensionality (D,N) 
where D is the number of features and N is the number of samples. \cr
Alternatively, if \code{as.data.frame} is \code{TRUE}, the function
 returns a long-formatted data frame with columns (view,feature,sample,value).
}
\examples{
data("scMT_data", package = "MOFAdata")
MOFAobject <- createMOFAobject(scMT_data)
trainData_scMT <- getTrainData(MOFAobject, as.data.frame = FALSE)
(trainData_scMT[["RNA expression"]])[1:10,1:10]

data("CLL_data", package = "MOFAdata")
MOFAobject <- createMOFAobject(CLL_data)
trainData_CLL <- getTrainData(MOFAobject, as.data.frame = TRUE)
head(trainData_CLL)
}
