% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rejectProbation.R
\name{rejectProbation}
\alias{rejectProbation}
\title{Reject a probational upload}
\usage{
rejectProbation(
  project,
  asset,
  version,
  url = restUrl(),
  token = accessToken()
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{token}{String containing a GitHub access token to authenticate to the gypsum REST API.
The token must refer to an owner of \code{project}.}
}
\value{
\code{NULL} is invisibly returned upon successful rejection.
}
\description{
Pretty much as it says: reject a probational upload of a version of a project's asset.
This removes all files associated with that version.
}
\examples{
if (interactive()) {
    # Mocking up a versioned asset.
    init <- startUpload(
        project="test-R", 
        asset="probation-reject", 
        version="v1", 
        files=character(0),
        probation=TRUE
    )
    completeUpload(init) 

    # Rejecting the probation:
    rejectProbation("test-R", "probation-reject", "v1")
}

}
\seealso{
\code{\link{approveProbation}}, to approve the probational upload.

\code{\link{startUpload}}, to specify probational uploads.
}
\author{
Aaron Lun
}
