% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper.R
\name{getTrace}
\alias{getTrace}
\title{Obtain a trace of inferential replicates for a sample}
\usage{
getTrace(y, idx, samp_idx)
}
\arguments{
\item{y}{a SummarizedExperiment with inferential replicates
as assays \code{infRep1} etc.}

\item{idx}{the names or row numbers
of the gene or transcript to plot}

\item{samp_idx}{the names or column numbers
of the samples to plot}
}
\value{
a data.frame with the counts along the interential
replicates, possible with additional columns specifying
feature or sample
}
\description{
Simple helper function to obtain a trace (e.g. MCMC trace)
of the ordered inferential replicates for one samples.
Supports either multiple features, \code{idx}, or multiple
samples, \code{samp_idx} (not both). Returns a tidy
data.frame for easy plotting.
}
\examples{

y <- makeSimSwishData()
getTrace(y, "gene-1", "s1")

}
