% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeMixT_Preprocessing.R
\name{subset_sd_gene_remaining}
\alias{subset_sd_gene_remaining}
\title{subset_sd_gene_remaining}
\usage{
subset_sd_gene_remaining(
  count.matrix,
  normal.id,
  tumor.id,
  cutoff_normal_range = c(0.2, 0.6),
  cutoff_tumor_range = c(0.2, 0.8),
  cutoff_step = 0.2
)
}
\arguments{
\item{count.matrix}{A matrix of raw expression count with \eqn{G} by \eqn{(My + M1)}, where \eqn{G} is the number
of genes, \eqn{My} is the number of mixed samples and \eqn{M1} is the number of normal samples. Row names are genes
 column names are sample ids.}

\item{normal.id}{A vector of normal sample ids}

\item{tumor.id}{A vector of tumor sample ids}

\item{cutoff_normal_range}{A vector of two numeric values, indicating the lower and upper bounds of standard deviation of 
log2 count matrix from the normal samples to subset. Default is c(0.2, 0.6)}

\item{cutoff_tumor_range}{A vector of two numeric values, indicating the lower and upper bounds to search standard deviation of 
log2 count matrix from the normal samples to subset. Default is c(0.2, 0.6)}

\item{cutoff_step}{A scatter value indicating the step size of changing cutoff_normal_range and cutoff_tumor_range to find a 
suitable subset of count matrix for downstream analysis}
}
\description{
Find the cutoffs to filter out genes with large standard deviations of log2 expressions in both normal and tumor samples
}
