/**
* @license Apache-2.0
*
* Copyright (c) 2018 The Stdlib Authors.
*
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
*    http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

'use strict';

/**
* Square root of the mathematical constant `π` divided by `2`.
*
* @module @stdlib/constants/float64/sqrt-half-pi
* @type {number}
*
* @example
* var SQRT_HALF_PI = require( '@stdlib/constants/float64/sqrt-half-pi' );
* // returns 1.2533141373155003
*/


// MAIN //

/**
* Square root of the mathematical constant `π` divided by `2`.
*
* @constant
* @type {number}
* @default 1.2533141373155003
* @see [Wikipedia]{@link https://en.wikipedia.org/wiki/Pi}
*/
var SQRT_HALF_PI = 1.253314137315500251207882642405522626503493370304969158314;


// EXPORTS //

module.exports = SQRT_HALF_PI;
