#!/bin/sed -f
# GMPAda, binding to the Ada Language for the GNU MultiPrecision library.
# Script transforming gmp_h.ads generated by g++ --dump-ada-specs.

# Copyright (C) 2007-2022 Nicolas Boulenguez <nicolas.boulenguez@free.fr>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

1i\
--  This source is generated, and may be different on your system.\

# Avoid depending on the C header path.
# Allow depending units to be declared Pure.
s/^package .*_gmp_h is$/package GMP.H with Pure is/
s/^end .*_gmp_h;$/end GMP.H;/

# Remove noisy comments.
# (most of them depend on the architecture)
/ *--.*/ {
  s///
  # If the modified line is empty, remove it.
  /^$/ d }

# Remove named access types (so that the package is Pure).
/^   type .* is access / d

# gmp-h.ads:6:01: warning: no warning suppressed by this pragma [-gnatw.w]
/^pragma Warnings (\(Off\|On\), "-gnatwu");$/ d

# If each binding embeds cpp_12_iosfwd.ads,
# it will be impossible to use them at the same time.
/^limited with cpp_12_iosfwd;/ d
/^   function operator_s[lr] (arg1 : access cpp_12_iosfwd.basic_[io]stream; / {N;N;N;d}
