# LoggedFS - Filesystem monitoring with Fuse

[![Build Status](https://travis-ci.org/rflament/loggedfs.svg?branch=feature%2Feasylogging%2B%2B)](https://travis-ci.org/rflament/loggedfs)

Donate Ethereum: 0x83FBC94FBca4e2f10Bede63e16C5b0Bb31a1Fed1

## Description

LoggedFS is a fuse-based filesystem which can log every operations that happens in it. 

How does it work ?

Fuse does almost everything. LoggedFS only sends a message to syslog when called by fuse and then let the real filesystem do the rest of the job.

## Installation

If loggedfs is included in your distribution you can just install with your package manager :

    sudo apt-get install loggedfs   

## Simplest usage

To record access to /tmp/TEST into ~/log.txt, just do:

    loggedfs -l ~/log.txt /tmp/TEST 

To stop recording, just unmount as usual:

    sudo umount /tmp/TEST
    
~/log.txt will need to be changed to readable by setting permissions:
    
    chmod 0666 ~/log.txt
    
## Installation from source

First you have to make sure that fuse is installed on your computer. 
If you have a recent distribution it should be. Fuse can be downloaded here : https://github.com/libfuse/libfuse.

Then you should download the loggedfs archive and install it with the make command :

    sudo apt-get install libfuse-dev libxml2-dev libpcre3-dev
    tar xfj loggedfs-X.Y.tar.bz2
    cd loggedfs-X.Y
    make
    make install
    
LoggedFS has the following dependencies :

    fuse
    pcre
    libxml2

## Configuration

LoggedFS can use an XML configuration file if you want it to log operations only for certain files, for certain users, or for certain operations.

Here is a sample configuration file :

    <?xml version="1.0" encoding="UTF-8"?>
    
    <loggedFS logEnabled="true" printProcessName="true">
      <includes>
        <include extension=".*" uid="*" action=".*" retname=".*"/>
      </includes>
      <excludes>
        <exclude extension=".*\.bak$" uid="*" action=".*" retname="SUCCESS"/>
        <exclude extension=".*" uid="1000" action=".*" retname="FAILURE"/>
        <exclude extension=".*" uid="*" action="getattr" retname=".*"/>
      </excludes>
    </loggedFS>

This configuration can be used to log everything except it if concerns a *.bak file, or if the uid is 1000, or if the operation is getattr.

## Launching LoggedFS

If you just want to test LoggedFS you don't need any configuration file.
 
Just use that command :

    loggedfs -f -p /var

You should see logs like these :

    tail -f /var/log/syslog
    2018-03-21 15:32:14,095 INFO [default] LoggedFS not running as a daemon
    2018-03-21 15:32:14,095 INFO [default] LoggedFS running as a public filesystem
    2018-03-21 15:32:14,095 INFO [default] LoggedFS starting at /var.
    2018-03-21 15:32:14,095 INFO [default] chdir to /var
    2018-03-21 15:32:15,375 INFO [default] getattr /var/ {SUCCESS} [ pid = 934 /usr/sbin/VBoxService uid = 0 ]
    2018-03-21 15:32:15,375 INFO [default] getattr /var/run {SUCCESS} [ pid = 934 /usr/sbin/VBoxService uid = 0 ]
    2018-03-21 15:32:15,376 INFO [default] readlink /var/run {SUCCESS} [ pid = 934 /usr/sbin/VBoxService uid = 0 ]
    2018-03-21 15:32:15,376 INFO [default] readlink /var/run {SUCCESS} [ pid = 934 /usr/sbin/VBoxService uid = 0 ]
    2018-03-21 15:32:15,890 INFO [default] getattr /var/cache {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,891 INFO [default] getattr /var/cache/apt {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,891 INFO [default] getattr /var/cache/apt/archives {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,891 INFO [default] getattr /var/cache/apt/archives/partial {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,891 INFO [default] getattr /var/cache/apt/archives/partial {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,892 INFO [default] getattr /var/lib {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,892 INFO [default] getattr /var/lib/apt {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,892 INFO [default] getattr /var/lib/apt/lists {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,892 INFO [default] getattr /var/lib/apt/lists/partial {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:15,892 INFO [default] getattr /var/lib/apt/lists/partial {SUCCESS} [ pid = 1539 update-notifier uid = 1000 ]
    2018-03-21 15:32:17,873 INFO [default] LoggedFS closing.

If you have a configuration file to use you should use this command :

    ./loggedfs -c loggedfs.xml -p /var

If you want to log what other users do on your filesystem, you should use the -p option to allow them to see your mounted files. For a complete documentation see the manual page

Rémi Flament - remipouak at gmail.com