#!/bin/sh
# Example for use of GNU gettext.
# This file is in the public domain.
#
# Script for regenerating all autogenerated files.

if test "$1" = fromscratch; then

  kdedir=
  for d in /usr/lib/kde /usr/local/kde /usr/local /usr/kde /usr /opt/kde3 /opt/kde /suse/opt/kde3 $KDEDIR; do
    if test -f $d/share/apps/kdelibs/admin/cvs.sh; then
      kdedir=$d
      break
    fi
  done
  if test -z "$kdedir"; then
    echo "*** KDE directory not found. Try setting KDEDIR." 1>&2
    exit 1
  fi

  cp -a $kdedir/share/apps/kdelibs/admin .
  sed -e s/AC_FOREACH/INCOMPATIBLE_FOREACH/g < $kdedir/share/apps/kdelibs/admin/acinclude.m4.in > admin/acinclude.m4.in
  sed -e 's/automake\*1.6/automake\*1.[678] | automake\*1.[678]/' < admin/cvs.sh > admin/cvs.sh.new
  mv admin/cvs.sh.new admin/cvs.sh

fi

autopoint -f # was: gettextize -f -c
mv config.rpath admin/config.rpath
rm -f mkinstalldirs
rm po/Makevars.template
rm po/Rules-quot
rm po/boldquot.sed
rm po/en@boldquot.header
rm po/en@quot.header
rm po/insert-header.sin
rm po/quot.sed

sh admin/cvs.sh cvs

cd po
for f in *.po; do
  if test -r "$f"; then
    lang=`echo $f | sed -e 's,\.po$,,'`
    msgfmt -c -o $lang.gmo $lang.po
  fi
done
cd ..
