// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file annotationsTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen.
 */

#include "annotationsTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>

#include "annotations.hpp"

#include "helpers/basic_inner_types.hpp"

using namespace eprosima::fastdds::dds::xtypes;


namespace AnnotationTest {
    void register_InnerEnumHelper_type_identifier(
            TypeIdentifierPair& type_ids_InnerEnumHelper)
    {
        ReturnCode_t return_code_InnerEnumHelper {eprosima::fastdds::dds::RETCODE_OK};
        return_code_InnerEnumHelper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AnnotationTest::InnerEnumHelper", type_ids_InnerEnumHelper);
        if (eprosima::fastdds::dds::RETCODE_OK != return_code_InnerEnumHelper)
        {
            EnumTypeFlag enum_flags_InnerEnumHelper = 0;
            BitBound bit_bound_InnerEnumHelper = 32;
            CommonEnumeratedHeader common_InnerEnumHelper = TypeObjectUtils::build_common_enumerated_header(bit_bound_InnerEnumHelper);
            QualifiedTypeName type_name_InnerEnumHelper = "AnnotationTest::InnerEnumHelper";
            eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_InnerEnumHelper;
            eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_InnerEnumHelper;
            CompleteTypeDetail detail_InnerEnumHelper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_InnerEnumHelper, ann_custom_InnerEnumHelper, type_name_InnerEnumHelper.to_string());
            CompleteEnumeratedHeader header_InnerEnumHelper = TypeObjectUtils::build_complete_enumerated_header(common_InnerEnumHelper, detail_InnerEnumHelper);
            CompleteEnumeratedLiteralSeq literal_seq_InnerEnumHelper;
            {
                EnumeratedLiteralFlag flags_ONE = TypeObjectUtils::build_enumerated_literal_flag(false);
                CommonEnumeratedLiteral common_ONE = TypeObjectUtils::build_common_enumerated_literal(0, flags_ONE);
                eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_ONE;
                ann_custom_InnerEnumHelper.reset();
                MemberName name_ONE = "ONE";
                CompleteMemberDetail detail_ONE = TypeObjectUtils::build_complete_member_detail(name_ONE, member_ann_builtin_ONE, ann_custom_InnerEnumHelper);
                CompleteEnumeratedLiteral literal_ONE = TypeObjectUtils::build_complete_enumerated_literal(common_ONE, detail_ONE);
                TypeObjectUtils::add_complete_enumerated_literal(literal_seq_InnerEnumHelper, literal_ONE);
            }
            {
                EnumeratedLiteralFlag flags_TWO = TypeObjectUtils::build_enumerated_literal_flag(false);
                CommonEnumeratedLiteral common_TWO = TypeObjectUtils::build_common_enumerated_literal(1, flags_TWO);
                eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_TWO;
                ann_custom_InnerEnumHelper.reset();
                MemberName name_TWO = "TWO";
                CompleteMemberDetail detail_TWO = TypeObjectUtils::build_complete_member_detail(name_TWO, member_ann_builtin_TWO, ann_custom_InnerEnumHelper);
                CompleteEnumeratedLiteral literal_TWO = TypeObjectUtils::build_complete_enumerated_literal(common_TWO, detail_TWO);
                TypeObjectUtils::add_complete_enumerated_literal(literal_seq_InnerEnumHelper, literal_TWO);
            }
            CompleteEnumeratedType enumerated_type_InnerEnumHelper = TypeObjectUtils::build_complete_enumerated_type(enum_flags_InnerEnumHelper, header_InnerEnumHelper,
                    literal_seq_InnerEnumHelper);
            if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                    TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_InnerEnumHelper, type_name_InnerEnumHelper.to_string(), type_ids_InnerEnumHelper))
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AnnotationTest::InnerEnumHelper already registered in TypeObjectRegistry for a different type.");
            }
        }
    }

    void register_Inner_alias_bounded_string_helper_type_identifier(
            TypeIdentifierPair& type_ids_Inner_alias_bounded_string_helper)
    {
        ReturnCode_t return_code_Inner_alias_bounded_string_helper {eprosima::fastdds::dds::RETCODE_OK};
        return_code_Inner_alias_bounded_string_helper =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "AnnotationTest::Inner_alias_bounded_string_helper", type_ids_Inner_alias_bounded_string_helper);
        if (eprosima::fastdds::dds::RETCODE_OK != return_code_Inner_alias_bounded_string_helper)
        {
            AliasTypeFlag alias_flags_Inner_alias_bounded_string_helper = 0;
            QualifiedTypeName type_name_Inner_alias_bounded_string_helper = "AnnotationTest::Inner_alias_bounded_string_helper";
            eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_Inner_alias_bounded_string_helper;
            eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_Inner_alias_bounded_string_helper;
            CompleteTypeDetail detail_Inner_alias_bounded_string_helper = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_Inner_alias_bounded_string_helper, ann_custom_Inner_alias_bounded_string_helper, type_name_Inner_alias_bounded_string_helper.to_string());
            CompleteAliasHeader header_Inner_alias_bounded_string_helper = TypeObjectUtils::build_complete_alias_header(detail_Inner_alias_bounded_string_helper);
            AliasMemberFlag related_flags_Inner_alias_bounded_string_helper = 0;
            return_code_Inner_alias_bounded_string_helper =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_1", type_ids_Inner_alias_bounded_string_helper);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_Inner_alias_bounded_string_helper)
            {
                {
                    SBound bound = static_cast<SBound>(1);
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_1", type_ids_Inner_alias_bounded_string_helper))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_1 already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            bool common_Inner_alias_bounded_string_helper_ec {false};
            CommonAliasBody common_Inner_alias_bounded_string_helper {TypeObjectUtils::build_common_alias_body(related_flags_Inner_alias_bounded_string_helper,
                    TypeObjectUtils::retrieve_complete_type_identifier(type_ids_Inner_alias_bounded_string_helper, common_Inner_alias_bounded_string_helper_ec))};
            if (!common_Inner_alias_bounded_string_helper_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "AnnotationTest::Inner_alias_bounded_string_helper related TypeIdentifier inconsistent.");
                return;
            }
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_Inner_alias_bounded_string_helper;
            ann_custom_Inner_alias_bounded_string_helper.reset();
            CompleteAliasBody body_Inner_alias_bounded_string_helper = TypeObjectUtils::build_complete_alias_body(common_Inner_alias_bounded_string_helper,
                    member_ann_builtin_Inner_alias_bounded_string_helper, ann_custom_Inner_alias_bounded_string_helper);
            CompleteAliasType alias_type_Inner_alias_bounded_string_helper = TypeObjectUtils::build_complete_alias_type(alias_flags_Inner_alias_bounded_string_helper,
                    header_Inner_alias_bounded_string_helper, body_Inner_alias_bounded_string_helper);
            if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                    TypeObjectUtils::build_and_register_alias_type_object(alias_type_Inner_alias_bounded_string_helper,
                        type_name_Inner_alias_bounded_string_helper.to_string(), type_ids_Inner_alias_bounded_string_helper))
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AnnotationTest::Inner_alias_bounded_string_helper already registered in TypeObjectRegistry for a different type.");
            }
        }
    }




} // namespace AnnotationTest

void register_AnnotationTest_type_identifier(
        TypeIdentifierPair& type_ids_AnnotationTest)
{
    ReturnCode_t return_code_AnnotationTest {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AnnotationTest =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AnnotationTest", type_ids_AnnotationTest);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AnnotationTest)
    {
        AnnotationTypeFlag annotation_flag_AnnotationTest = 0;
        QualifiedTypeName annotation_name_AnnotationTest = "AnnotationTest";
        CompleteAnnotationHeader header_AnnotationTest = TypeObjectUtils::build_complete_annotation_header(annotation_name_AnnotationTest);
        CompleteAnnotationParameterSeq member_seq_AnnotationTest;
        {
            ReturnCode_t return_code_var_short;
            TypeIdentifierPair type_ids_var_short;
            AnnotationParameterFlag member_flags_var_short = 0;
            return_code_var_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_short);

            if (return_code_var_short != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_short;
            if (EK_COMPLETE == type_ids_var_short.type_identifier1()._d() || TK_NONE == type_ids_var_short.type_identifier2()._d())
            {
                common_var_short = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_short, type_ids_var_short.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_short.type_identifier2()._d())
            {
                common_var_short = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_short, type_ids_var_short.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_short annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_short = "var_short";
            AnnotationParameterValue param_value_var_short = TypeObjectUtils::build_annotation_parameter_value(static_cast<int16_t>(0));

            CompleteAnnotationParameter param_var_short = TypeObjectUtils::build_complete_annotation_parameter(common_var_short, name_var_short, param_value_var_short);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_short);
        }
        {
            ReturnCode_t return_code_var_char16;
            TypeIdentifierPair type_ids_var_char16;
            AnnotationParameterFlag member_flags_var_char16 = 0;
            return_code_var_char16 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_wchar_t", type_ids_var_char16);

            if (return_code_var_char16 != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_char16;
            if (EK_COMPLETE == type_ids_var_char16.type_identifier1()._d() || TK_NONE == type_ids_var_char16.type_identifier2()._d())
            {
                common_var_char16 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_char16, type_ids_var_char16.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_char16.type_identifier2()._d())
            {
                common_var_char16 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_char16, type_ids_var_char16.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char16 annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char16 = "var_char16";
            AnnotationParameterValue param_value_var_char16 = TypeObjectUtils::build_annotation_parameter_value(static_cast<wchar_t>(0));

            CompleteAnnotationParameter param_var_char16 = TypeObjectUtils::build_complete_annotation_parameter(common_var_char16, name_var_char16, param_value_var_char16);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_char16);
        }
        {
            ReturnCode_t return_code_enum_value;
            TypeIdentifierPair type_ids_enum_value;
            AnnotationParameterFlag member_flags_enum_value = 0;
            return_code_enum_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AnnotationTest::InnerEnumHelper", type_ids_enum_value);

            if (return_code_enum_value != eprosima::fastdds::dds::RETCODE_OK)
            {
                AnnotationTest::register_InnerEnumHelper_type_identifier(type_ids_enum_value);
            }
            CommonAnnotationParameter common_enum_value;
            if (EK_COMPLETE == type_ids_enum_value.type_identifier1()._d() || TK_NONE == type_ids_enum_value.type_identifier2()._d())
            {
                common_enum_value = TypeObjectUtils::build_common_annotation_parameter(member_flags_enum_value, type_ids_enum_value.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_enum_value.type_identifier2()._d())
            {
                common_enum_value = TypeObjectUtils::build_common_annotation_parameter(member_flags_enum_value, type_ids_enum_value.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "enum_value annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_value = "enum_value";
            AnnotationParameterValue param_value_enum_value = TypeObjectUtils::build_annotation_parameter_value_enum(0);

            CompleteAnnotationParameter param_enum_value = TypeObjectUtils::build_complete_annotation_parameter(common_enum_value, name_enum_value, param_value_enum_value);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_enum_value);
        }
        {
            ReturnCode_t return_code_var_long;
            TypeIdentifierPair type_ids_var_long;
            AnnotationParameterFlag member_flags_var_long = 0;
            return_code_var_long =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_var_long);

            if (return_code_var_long != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_long;
            if (EK_COMPLETE == type_ids_var_long.type_identifier1()._d() || TK_NONE == type_ids_var_long.type_identifier2()._d())
            {
                common_var_long = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_long, type_ids_var_long.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_long.type_identifier2()._d())
            {
                common_var_long = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_long, type_ids_var_long.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_long annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_long = "var_long";
            AnnotationParameterValue param_value_var_long = TypeObjectUtils::build_annotation_parameter_value(static_cast<int32_t>(0));

            CompleteAnnotationParameter param_var_long = TypeObjectUtils::build_complete_annotation_parameter(common_var_long, name_var_long, param_value_var_long);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_long);
        }
        {
            ReturnCode_t return_code_var_char8;
            TypeIdentifierPair type_ids_var_char8;
            AnnotationParameterFlag member_flags_var_char8 = 0;
            return_code_var_char8 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_char", type_ids_var_char8);

            if (return_code_var_char8 != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_char8;
            if (EK_COMPLETE == type_ids_var_char8.type_identifier1()._d() || TK_NONE == type_ids_var_char8.type_identifier2()._d())
            {
                common_var_char8 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_char8, type_ids_var_char8.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_char8.type_identifier2()._d())
            {
                common_var_char8 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_char8, type_ids_var_char8.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_char8 annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_char8 = "var_char8";
            AnnotationParameterValue param_value_var_char8 = TypeObjectUtils::build_annotation_parameter_value(static_cast<char>(0));

            CompleteAnnotationParameter param_var_char8 = TypeObjectUtils::build_complete_annotation_parameter(common_var_char8, name_var_char8, param_value_var_char8);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_char8);
        }
        {
            ReturnCode_t return_code_var_ulonglong;
            TypeIdentifierPair type_ids_var_ulonglong;
            AnnotationParameterFlag member_flags_var_ulonglong = 0;
            return_code_var_ulonglong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint64_t", type_ids_var_ulonglong);

            if (return_code_var_ulonglong != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_ulonglong;
            if (EK_COMPLETE == type_ids_var_ulonglong.type_identifier1()._d() || TK_NONE == type_ids_var_ulonglong.type_identifier2()._d())
            {
                common_var_ulonglong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ulonglong, type_ids_var_ulonglong.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_ulonglong.type_identifier2()._d())
            {
                common_var_ulonglong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ulonglong, type_ids_var_ulonglong.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulonglong annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulonglong = "var_ulonglong";
            AnnotationParameterValue param_value_var_ulonglong = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint64_t>(0));

            CompleteAnnotationParameter param_var_ulonglong = TypeObjectUtils::build_complete_annotation_parameter(common_var_ulonglong, name_var_ulonglong, param_value_var_ulonglong);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_ulonglong);
        }
        {
            ReturnCode_t return_code_var_string_10;
            TypeIdentifierPair type_ids_var_string_10;
            AnnotationParameterFlag member_flags_var_string_10 = 0;
            return_code_var_string_10 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AnnotationTest::Inner_alias_bounded_string_helper", type_ids_var_string_10);

            if (return_code_var_string_10 != eprosima::fastdds::dds::RETCODE_OK)
            {
                AnnotationTest::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_string_10);
            }
            CommonAnnotationParameter common_var_string_10;
            if (EK_COMPLETE == type_ids_var_string_10.type_identifier1()._d() || TK_NONE == type_ids_var_string_10.type_identifier2()._d())
            {
                common_var_string_10 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_string_10, type_ids_var_string_10.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_string_10.type_identifier2()._d())
            {
                common_var_string_10 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_string_10, type_ids_var_string_10.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_string_10 annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_string_10 = "var_string_10";
            AnnotationParameterValue param_value_var_string_10 = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>(""));


            CompleteAnnotationParameter param_var_string_10 = TypeObjectUtils::build_complete_annotation_parameter(common_var_string_10, name_var_string_10, param_value_var_string_10);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_string_10);
        }
        {
            ReturnCode_t return_code_var_boolean;
            TypeIdentifierPair type_ids_var_boolean;
            AnnotationParameterFlag member_flags_var_boolean = 0;
            return_code_var_boolean =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_bool", type_ids_var_boolean);

            if (return_code_var_boolean != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_boolean;
            if (EK_COMPLETE == type_ids_var_boolean.type_identifier1()._d() || TK_NONE == type_ids_var_boolean.type_identifier2()._d())
            {
                common_var_boolean = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_boolean, type_ids_var_boolean.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_boolean.type_identifier2()._d())
            {
                common_var_boolean = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_boolean, type_ids_var_boolean.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_boolean annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_boolean = "var_boolean";
            AnnotationParameterValue param_value_var_boolean = TypeObjectUtils::build_annotation_parameter_value(static_cast<bool>(false));

            CompleteAnnotationParameter param_var_boolean = TypeObjectUtils::build_complete_annotation_parameter(common_var_boolean, name_var_boolean, param_value_var_boolean);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_boolean);
        }
        {
            ReturnCode_t return_code_var_wstring;
            TypeIdentifierPair type_ids_var_wstring;
            AnnotationParameterFlag member_flags_var_wstring = 0;
            return_code_var_wstring =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_wstring_unbounded", type_ids_var_wstring);

            if (return_code_var_wstring != eprosima::fastdds::dds::RETCODE_OK)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_wstring_unbounded", type_ids_var_wstring, true))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_wstring_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            CommonAnnotationParameter common_var_wstring;
            if (EK_COMPLETE == type_ids_var_wstring.type_identifier1()._d() || TK_NONE == type_ids_var_wstring.type_identifier2()._d())
            {
                common_var_wstring = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_wstring, type_ids_var_wstring.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_wstring.type_identifier2()._d())
            {
                common_var_wstring = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_wstring, type_ids_var_wstring.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_wstring annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_wstring = "var_wstring";
            AnnotationParameterValue param_value_var_wstring = TypeObjectUtils::build_annotation_parameter_value(static_cast<std::wstring>(L""));

            CompleteAnnotationParameter param_var_wstring = TypeObjectUtils::build_complete_annotation_parameter(common_var_wstring, name_var_wstring, param_value_var_wstring);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_wstring);
        }
        {
            ReturnCode_t return_code_var_float;
            TypeIdentifierPair type_ids_var_float;
            AnnotationParameterFlag member_flags_var_float = 0;
            return_code_var_float =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_var_float);

            if (return_code_var_float != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_float;
            if (EK_COMPLETE == type_ids_var_float.type_identifier1()._d() || TK_NONE == type_ids_var_float.type_identifier2()._d())
            {
                common_var_float = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_float, type_ids_var_float.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_float.type_identifier2()._d())
            {
                common_var_float = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_float, type_ids_var_float.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_float annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_float = "var_float";
            AnnotationParameterValue param_value_var_float = TypeObjectUtils::build_annotation_parameter_value(static_cast<float>(0.0));

            CompleteAnnotationParameter param_var_float = TypeObjectUtils::build_complete_annotation_parameter(common_var_float, name_var_float, param_value_var_float);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_float);
        }
        {
            ReturnCode_t return_code_var_ushort;
            TypeIdentifierPair type_ids_var_ushort;
            AnnotationParameterFlag member_flags_var_ushort = 0;
            return_code_var_ushort =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint16_t", type_ids_var_ushort);

            if (return_code_var_ushort != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_ushort;
            if (EK_COMPLETE == type_ids_var_ushort.type_identifier1()._d() || TK_NONE == type_ids_var_ushort.type_identifier2()._d())
            {
                common_var_ushort = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ushort, type_ids_var_ushort.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_ushort.type_identifier2()._d())
            {
                common_var_ushort = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ushort, type_ids_var_ushort.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ushort annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ushort = "var_ushort";
            AnnotationParameterValue param_value_var_ushort = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint16_t>(0));

            CompleteAnnotationParameter param_var_ushort = TypeObjectUtils::build_complete_annotation_parameter(common_var_ushort, name_var_ushort, param_value_var_ushort);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_ushort);
        }
        {
            ReturnCode_t return_code_var_default_string_10;
            TypeIdentifierPair type_ids_var_default_string_10;
            AnnotationParameterFlag member_flags_var_default_string_10 = 0;
            return_code_var_default_string_10 =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AnnotationTest::Inner_alias_bounded_string_helper", type_ids_var_default_string_10);

            if (return_code_var_default_string_10 != eprosima::fastdds::dds::RETCODE_OK)
            {
                AnnotationTest::register_Inner_alias_bounded_string_helper_type_identifier(type_ids_var_default_string_10);
            }
            CommonAnnotationParameter common_var_default_string_10;
            if (EK_COMPLETE == type_ids_var_default_string_10.type_identifier1()._d() || TK_NONE == type_ids_var_default_string_10.type_identifier2()._d())
            {
                common_var_default_string_10 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_default_string_10, type_ids_var_default_string_10.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_default_string_10.type_identifier2()._d())
            {
                common_var_default_string_10 = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_default_string_10, type_ids_var_default_string_10.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_default_string_10 annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_default_string_10 = "var_default_string_10";
            AnnotationParameterValue param_value_var_default_string_10 = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>("Hello"));


            CompleteAnnotationParameter param_var_default_string_10 = TypeObjectUtils::build_complete_annotation_parameter(common_var_default_string_10, name_var_default_string_10, param_value_var_default_string_10);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_default_string_10);
        }
        {
            ReturnCode_t return_code_var_wstring_alias;
            TypeIdentifierPair type_ids_var_wstring_alias;
            AnnotationParameterFlag member_flags_var_wstring_alias = 0;
            return_code_var_wstring_alias =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "Inner_alias_bounded_wstring_helper", type_ids_var_wstring_alias);

            if (return_code_var_wstring_alias != eprosima::fastdds::dds::RETCODE_OK)
            {
        ::register_Inner_alias_bounded_wstring_helper_type_identifier(type_ids_var_wstring_alias);
            }
            CommonAnnotationParameter common_var_wstring_alias;
            if (EK_COMPLETE == type_ids_var_wstring_alias.type_identifier1()._d() || TK_NONE == type_ids_var_wstring_alias.type_identifier2()._d())
            {
                common_var_wstring_alias = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_wstring_alias, type_ids_var_wstring_alias.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_wstring_alias.type_identifier2()._d())
            {
                common_var_wstring_alias = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_wstring_alias, type_ids_var_wstring_alias.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_wstring_alias annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_wstring_alias = "var_wstring_alias";
            AnnotationParameterValue param_value_var_wstring_alias = TypeObjectUtils::build_annotation_parameter_value(static_cast<std::wstring>(L""));


            CompleteAnnotationParameter param_var_wstring_alias = TypeObjectUtils::build_complete_annotation_parameter(common_var_wstring_alias, name_var_wstring_alias, param_value_var_wstring_alias);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_wstring_alias);
        }
        {
            ReturnCode_t return_code_var_longlong;
            TypeIdentifierPair type_ids_var_longlong;
            AnnotationParameterFlag member_flags_var_longlong = 0;
            return_code_var_longlong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int64_t", type_ids_var_longlong);

            if (return_code_var_longlong != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_longlong;
            if (EK_COMPLETE == type_ids_var_longlong.type_identifier1()._d() || TK_NONE == type_ids_var_longlong.type_identifier2()._d())
            {
                common_var_longlong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_longlong, type_ids_var_longlong.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_longlong.type_identifier2()._d())
            {
                common_var_longlong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_longlong, type_ids_var_longlong.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_longlong annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_longlong = "var_longlong";
            AnnotationParameterValue param_value_var_longlong = TypeObjectUtils::build_annotation_parameter_value(static_cast<int64_t>(0));

            CompleteAnnotationParameter param_var_longlong = TypeObjectUtils::build_complete_annotation_parameter(common_var_longlong, name_var_longlong, param_value_var_longlong);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_longlong);
        }
        {
            ReturnCode_t return_code_var_ulong;
            TypeIdentifierPair type_ids_var_ulong;
            AnnotationParameterFlag member_flags_var_ulong = 0;
            return_code_var_ulong =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_uint32_t", type_ids_var_ulong);

            if (return_code_var_ulong != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_ulong;
            if (EK_COMPLETE == type_ids_var_ulong.type_identifier1()._d() || TK_NONE == type_ids_var_ulong.type_identifier2()._d())
            {
                common_var_ulong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ulong, type_ids_var_ulong.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_ulong.type_identifier2()._d())
            {
                common_var_ulong = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_ulong, type_ids_var_ulong.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_ulong annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_ulong = "var_ulong";
            AnnotationParameterValue param_value_var_ulong = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint32_t>(0));

            CompleteAnnotationParameter param_var_ulong = TypeObjectUtils::build_complete_annotation_parameter(common_var_ulong, name_var_ulong, param_value_var_ulong);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_ulong);
        }
        {
            ReturnCode_t return_code_var_string;
            TypeIdentifierPair type_ids_var_string;
            AnnotationParameterFlag member_flags_var_string = 0;
            return_code_var_string =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_var_string);

            if (return_code_var_string != eprosima::fastdds::dds::RETCODE_OK)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_var_string))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            CommonAnnotationParameter common_var_string;
            if (EK_COMPLETE == type_ids_var_string.type_identifier1()._d() || TK_NONE == type_ids_var_string.type_identifier2()._d())
            {
                common_var_string = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_string, type_ids_var_string.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_string.type_identifier2()._d())
            {
                common_var_string = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_string, type_ids_var_string.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_string annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_string = "var_string";
            AnnotationParameterValue param_value_var_string = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>(""));

            CompleteAnnotationParameter param_var_string = TypeObjectUtils::build_complete_annotation_parameter(common_var_string, name_var_string, param_value_var_string);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_string);
        }
        {
            ReturnCode_t return_code_var_double;
            TypeIdentifierPair type_ids_var_double;
            AnnotationParameterFlag member_flags_var_double = 0;
            return_code_var_double =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_double", type_ids_var_double);

            if (return_code_var_double != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_double;
            if (EK_COMPLETE == type_ids_var_double.type_identifier1()._d() || TK_NONE == type_ids_var_double.type_identifier2()._d())
            {
                common_var_double = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_double, type_ids_var_double.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_double.type_identifier2()._d())
            {
                common_var_double = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_double, type_ids_var_double.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_double annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_double = "var_double";
            AnnotationParameterValue param_value_var_double = TypeObjectUtils::build_annotation_parameter_value(static_cast<double>(0.0));

            CompleteAnnotationParameter param_var_double = TypeObjectUtils::build_complete_annotation_parameter(common_var_double, name_var_double, param_value_var_double);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_double);
        }
        {
            ReturnCode_t return_code_enum_default_value;
            TypeIdentifierPair type_ids_enum_default_value;
            AnnotationParameterFlag member_flags_enum_default_value = 0;
            return_code_enum_default_value =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "AnnotationTest::InnerEnumHelper", type_ids_enum_default_value);

            if (return_code_enum_default_value != eprosima::fastdds::dds::RETCODE_OK)
            {
                AnnotationTest::register_InnerEnumHelper_type_identifier(type_ids_enum_default_value);
            }
            CommonAnnotationParameter common_enum_default_value;
            if (EK_COMPLETE == type_ids_enum_default_value.type_identifier1()._d() || TK_NONE == type_ids_enum_default_value.type_identifier2()._d())
            {
                common_enum_default_value = TypeObjectUtils::build_common_annotation_parameter(member_flags_enum_default_value, type_ids_enum_default_value.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_enum_default_value.type_identifier2()._d())
            {
                common_enum_default_value = TypeObjectUtils::build_common_annotation_parameter(member_flags_enum_default_value, type_ids_enum_default_value.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "enum_default_value annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_default_value = "enum_default_value";
            AnnotationParameterValue param_value_enum_default_value = TypeObjectUtils::build_annotation_parameter_value_enum(1);

            CompleteAnnotationParameter param_enum_default_value = TypeObjectUtils::build_complete_annotation_parameter(common_enum_default_value, name_enum_default_value, param_value_enum_default_value);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_enum_default_value);
        }
        {
            ReturnCode_t return_code_var_octet;
            TypeIdentifierPair type_ids_var_octet;
            AnnotationParameterFlag member_flags_var_octet = 0;
            return_code_var_octet =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_byte", type_ids_var_octet);

            if (return_code_var_octet != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_octet;
            if (EK_COMPLETE == type_ids_var_octet.type_identifier1()._d() || TK_NONE == type_ids_var_octet.type_identifier2()._d())
            {
                common_var_octet = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_octet, type_ids_var_octet.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_octet.type_identifier2()._d())
            {
                common_var_octet = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_octet, type_ids_var_octet.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_octet annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_octet = "var_octet";
            AnnotationParameterValue param_value_var_octet = TypeObjectUtils::build_annotation_parameter_value_byte(0);

            CompleteAnnotationParameter param_var_octet = TypeObjectUtils::build_complete_annotation_parameter(common_var_octet, name_var_octet, param_value_var_octet);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_AnnotationTest, param_var_octet);
        }
        CompleteAnnotationType annotation_type_AnnotationTest = TypeObjectUtils::build_complete_annotation_type(annotation_flag_AnnotationTest, header_AnnotationTest,
                member_seq_AnnotationTest);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_annotation_type_object(annotation_type_AnnotationTest,
                    annotation_name_AnnotationTest.to_string(), type_ids_AnnotationTest))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "AnnotationTest already registered in TypeObjectRegistry for a different type.");
        }
    }
}

namespace EmptyAnnotationTest {



} // namespace EmptyAnnotationTest

void register_EmptyAnnotationTest_type_identifier(
        TypeIdentifierPair& type_ids_EmptyAnnotationTest)
{
    ReturnCode_t return_code_EmptyAnnotationTest {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EmptyAnnotationTest =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "EmptyAnnotationTest", type_ids_EmptyAnnotationTest);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EmptyAnnotationTest)
    {
        AnnotationTypeFlag annotation_flag_EmptyAnnotationTest = 0;
        QualifiedTypeName annotation_name_EmptyAnnotationTest = "EmptyAnnotationTest";
        CompleteAnnotationHeader header_EmptyAnnotationTest = TypeObjectUtils::build_complete_annotation_header(annotation_name_EmptyAnnotationTest);
        CompleteAnnotationParameterSeq member_seq_EmptyAnnotationTest;
        CompleteAnnotationType annotation_type_EmptyAnnotationTest = TypeObjectUtils::build_complete_annotation_type(annotation_flag_EmptyAnnotationTest, header_EmptyAnnotationTest,
                member_seq_EmptyAnnotationTest);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_annotation_type_object(annotation_type_EmptyAnnotationTest,
                    annotation_name_EmptyAnnotationTest.to_string(), type_ids_EmptyAnnotationTest))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "EmptyAnnotationTest already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_AnnotatedStruct_type_identifier(
        TypeIdentifierPair& type_ids_AnnotatedStruct)
{

    ReturnCode_t return_code_AnnotatedStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AnnotatedStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "AnnotatedStruct", type_ids_AnnotatedStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AnnotatedStruct)
    {
        StructTypeFlag struct_flags_AnnotatedStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_AnnotatedStruct = "AnnotatedStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AnnotatedStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AnnotatedStruct;
        AppliedAnnotationSeq tmp_ann_custom_AnnotatedStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_AnnotatedStruct;
        {
            eprosima::fastcdr::optional<AppliedAnnotationParameterSeq> applied_annotation_parameter_seq_AnnotatedStruct;
            AppliedAnnotationParameterSeq tmp_applied_annotation_parameter_seq_AnnotatedStruct;
        {
            NameHash paramname_hash_var_short = TypeObjectUtils::name_hash("var_short");
            AnnotationParameterValue param_value_var_short = TypeObjectUtils::build_annotation_parameter_value(static_cast<int16_t>(1));

            AppliedAnnotationParameter applied_param_var_short = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_short,
                    param_value_var_short);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_short);
        }

        {
            NameHash paramname_hash_var_char16 = TypeObjectUtils::name_hash("var_char16");
            AnnotationParameterValue param_value_var_char16 = TypeObjectUtils::build_annotation_parameter_value(static_cast<wchar_t>(L'a'));

            AppliedAnnotationParameter applied_param_var_char16 = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_char16,
                    param_value_var_char16);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_char16);
        }

        {
            NameHash paramname_hash_enum_value = TypeObjectUtils::name_hash("enum_value");
            AnnotationParameterValue param_value_enum_value = TypeObjectUtils::build_annotation_parameter_value_enum(0);

            AppliedAnnotationParameter applied_param_enum_value = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_enum_value,
                    param_value_enum_value);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_enum_value);
        }

        {
            NameHash paramname_hash_var_long = TypeObjectUtils::name_hash("var_long");
            AnnotationParameterValue param_value_var_long = TypeObjectUtils::build_annotation_parameter_value(static_cast<int32_t>(1));

            AppliedAnnotationParameter applied_param_var_long = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_long,
                    param_value_var_long);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_long);
        }

        {
            NameHash paramname_hash_var_char8 = TypeObjectUtils::name_hash("var_char8");
            AnnotationParameterValue param_value_var_char8 = TypeObjectUtils::build_annotation_parameter_value(static_cast<char>('a'));

            AppliedAnnotationParameter applied_param_var_char8 = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_char8,
                    param_value_var_char8);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_char8);
        }

        {
            NameHash paramname_hash_var_ulonglong = TypeObjectUtils::name_hash("var_ulonglong");
            AnnotationParameterValue param_value_var_ulonglong = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint64_t>(1));

            AppliedAnnotationParameter applied_param_var_ulonglong = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_ulonglong,
                    param_value_var_ulonglong);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_ulonglong);
        }

        {
            NameHash paramname_hash_var_string_10 = TypeObjectUtils::name_hash("var_string_10");
            AnnotationParameterValue param_value_var_string_10 = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>(""));


            AppliedAnnotationParameter applied_param_var_string_10 = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_string_10,
                    param_value_var_string_10);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_string_10);
        }

        {
            NameHash paramname_hash_var_boolean = TypeObjectUtils::name_hash("var_boolean");
            AnnotationParameterValue param_value_var_boolean = TypeObjectUtils::build_annotation_parameter_value(static_cast<bool>(true));

            AppliedAnnotationParameter applied_param_var_boolean = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_boolean,
                    param_value_var_boolean);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_boolean);
        }

        {
            NameHash paramname_hash_var_wstring = TypeObjectUtils::name_hash("var_wstring");
            AnnotationParameterValue param_value_var_wstring = TypeObjectUtils::build_annotation_parameter_value(static_cast<std::wstring>(L""));

            AppliedAnnotationParameter applied_param_var_wstring = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_wstring,
                    param_value_var_wstring);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_wstring);
        }

        {
            NameHash paramname_hash_var_float = TypeObjectUtils::name_hash("var_float");
            AnnotationParameterValue param_value_var_float = TypeObjectUtils::build_annotation_parameter_value(static_cast<float>(1));

            AppliedAnnotationParameter applied_param_var_float = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_float,
                    param_value_var_float);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_float);
        }

        {
            NameHash paramname_hash_var_ushort = TypeObjectUtils::name_hash("var_ushort");
            AnnotationParameterValue param_value_var_ushort = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint16_t>(1));

            AppliedAnnotationParameter applied_param_var_ushort = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_ushort,
                    param_value_var_ushort);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_ushort);
        }

        {
            NameHash paramname_hash_var_default_string_10 = TypeObjectUtils::name_hash("var_default_string_10");
            AnnotationParameterValue param_value_var_default_string_10 = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>("Hello"));


            AppliedAnnotationParameter applied_param_var_default_string_10 = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_default_string_10,
                    param_value_var_default_string_10);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_default_string_10);
        }

        {
            NameHash paramname_hash_var_wstring_alias = TypeObjectUtils::name_hash("var_wstring_alias");
            AnnotationParameterValue param_value_var_wstring_alias = TypeObjectUtils::build_annotation_parameter_value(static_cast<std::wstring>(L""));


            AppliedAnnotationParameter applied_param_var_wstring_alias = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_wstring_alias,
                    param_value_var_wstring_alias);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_wstring_alias);
        }

        {
            NameHash paramname_hash_var_longlong = TypeObjectUtils::name_hash("var_longlong");
            AnnotationParameterValue param_value_var_longlong = TypeObjectUtils::build_annotation_parameter_value(static_cast<int64_t>(1));

            AppliedAnnotationParameter applied_param_var_longlong = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_longlong,
                    param_value_var_longlong);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_longlong);
        }

        {
            NameHash paramname_hash_var_ulong = TypeObjectUtils::name_hash("var_ulong");
            AnnotationParameterValue param_value_var_ulong = TypeObjectUtils::build_annotation_parameter_value(static_cast<uint32_t>(1));

            AppliedAnnotationParameter applied_param_var_ulong = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_ulong,
                    param_value_var_ulong);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_ulong);
        }

        {
            NameHash paramname_hash_var_string = TypeObjectUtils::name_hash("var_string");
            AnnotationParameterValue param_value_var_string = TypeObjectUtils::build_annotation_parameter_value(eprosima::fastcdr::fixed_string<128>("a"));

            AppliedAnnotationParameter applied_param_var_string = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_string,
                    param_value_var_string);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_string);
        }

        {
            NameHash paramname_hash_var_double = TypeObjectUtils::name_hash("var_double");
            AnnotationParameterValue param_value_var_double = TypeObjectUtils::build_annotation_parameter_value(static_cast<double>(1));

            AppliedAnnotationParameter applied_param_var_double = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_double,
                    param_value_var_double);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_double);
        }

        {
            NameHash paramname_hash_enum_default_value = TypeObjectUtils::name_hash("enum_default_value");
            AnnotationParameterValue param_value_enum_default_value = TypeObjectUtils::build_annotation_parameter_value_enum(1);

            AppliedAnnotationParameter applied_param_enum_default_value = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_enum_default_value,
                    param_value_enum_default_value);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_enum_default_value);
        }

        {
            NameHash paramname_hash_var_octet = TypeObjectUtils::name_hash("var_octet");
            AnnotationParameterValue param_value_var_octet = TypeObjectUtils::build_annotation_parameter_value_byte(0);

            AppliedAnnotationParameter applied_param_var_octet = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_octet,
                    param_value_var_octet);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_AnnotatedStruct, applied_param_var_octet);
        }

            {
                AppliedAnnotation applied_annotation_AnnotatedStruct;
                ReturnCode_t return_code_AnnotationTest {eprosima::fastdds::dds::RETCODE_OK};
                TypeIdentifierPair type_ids_AnnotationTest;
                return_code_AnnotationTest =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "AnnotationTest", type_ids_AnnotationTest);
                if (return_code_AnnotationTest != eprosima::fastdds::dds::RETCODE_OK)
                {
        ::register_AnnotationTest_type_identifier(type_ids_AnnotationTest);
                }
                if (!tmp_applied_annotation_parameter_seq_AnnotatedStruct.empty())
                {
                    applied_annotation_parameter_seq_AnnotatedStruct = tmp_applied_annotation_parameter_seq_AnnotatedStruct;
                }
                if (EK_COMPLETE == type_ids_AnnotationTest.type_identifier1()._d())
                {
                    applied_annotation_AnnotatedStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_AnnotationTest.type_identifier1(), applied_annotation_parameter_seq_AnnotatedStruct);
                }
                else if (EK_COMPLETE == type_ids_AnnotationTest.type_identifier2()._d())
                {
                    applied_annotation_AnnotatedStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_AnnotationTest.type_identifier2(), applied_annotation_parameter_seq_AnnotatedStruct);
                }
                else
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "AnnotatedStruct Structure: Given Annotation TypeIdentifier is inconsistent.");
                    return;
                }
                TypeObjectUtils::add_applied_annotation(tmp_ann_custom_AnnotatedStruct, applied_annotation_AnnotatedStruct);
            }
        }

        if (!tmp_ann_custom_AnnotatedStruct.empty())
        {
            ann_custom_AnnotatedStruct = tmp_ann_custom_AnnotatedStruct;
        }

        CompleteTypeDetail detail_AnnotatedStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AnnotatedStruct, ann_custom_AnnotatedStruct, type_name_AnnotatedStruct.to_string());
        CompleteStructHeader header_AnnotatedStruct;
        header_AnnotatedStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_AnnotatedStruct);
        CompleteStructMemberSeq member_seq_AnnotatedStruct;
        CompleteStructType struct_type_AnnotatedStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_AnnotatedStruct, header_AnnotatedStruct, member_seq_AnnotatedStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_AnnotatedStruct, type_name_AnnotatedStruct.to_string(), type_ids_AnnotatedStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "AnnotatedStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_EmptyAnnotatedStruct_type_identifier(
        TypeIdentifierPair& type_ids_EmptyAnnotatedStruct)
{

    ReturnCode_t return_code_EmptyAnnotatedStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EmptyAnnotatedStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "EmptyAnnotatedStruct", type_ids_EmptyAnnotatedStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EmptyAnnotatedStruct)
    {
        StructTypeFlag struct_flags_EmptyAnnotatedStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_EmptyAnnotatedStruct = "EmptyAnnotatedStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EmptyAnnotatedStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EmptyAnnotatedStruct;
        AppliedAnnotationSeq tmp_ann_custom_EmptyAnnotatedStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_EmptyAnnotatedStruct;
        {
            eprosima::fastcdr::optional<AppliedAnnotationParameterSeq> applied_annotation_parameter_seq_EmptyAnnotatedStruct;
            AppliedAnnotationParameterSeq tmp_applied_annotation_parameter_seq_EmptyAnnotatedStruct;
            {
                AppliedAnnotation applied_annotation_EmptyAnnotatedStruct;
                ReturnCode_t return_code_EmptyAnnotationTest {eprosima::fastdds::dds::RETCODE_OK};
                TypeIdentifierPair type_ids_EmptyAnnotationTest;
                return_code_EmptyAnnotationTest =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "EmptyAnnotationTest", type_ids_EmptyAnnotationTest);
                if (return_code_EmptyAnnotationTest != eprosima::fastdds::dds::RETCODE_OK)
                {
        ::register_EmptyAnnotationTest_type_identifier(type_ids_EmptyAnnotationTest);
                }
                if (!tmp_applied_annotation_parameter_seq_EmptyAnnotatedStruct.empty())
                {
                    applied_annotation_parameter_seq_EmptyAnnotatedStruct = tmp_applied_annotation_parameter_seq_EmptyAnnotatedStruct;
                }
                if (EK_COMPLETE == type_ids_EmptyAnnotationTest.type_identifier1()._d())
                {
                    applied_annotation_EmptyAnnotatedStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_EmptyAnnotationTest.type_identifier1(), applied_annotation_parameter_seq_EmptyAnnotatedStruct);
                }
                else if (EK_COMPLETE == type_ids_EmptyAnnotationTest.type_identifier2()._d())
                {
                    applied_annotation_EmptyAnnotatedStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_EmptyAnnotationTest.type_identifier2(), applied_annotation_parameter_seq_EmptyAnnotatedStruct);
                }
                else
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "EmptyAnnotatedStruct Structure: Given Annotation TypeIdentifier is inconsistent.");
                    return;
                }
                TypeObjectUtils::add_applied_annotation(tmp_ann_custom_EmptyAnnotatedStruct, applied_annotation_EmptyAnnotatedStruct);
            }
        }

        if (!tmp_ann_custom_EmptyAnnotatedStruct.empty())
        {
            ann_custom_EmptyAnnotatedStruct = tmp_ann_custom_EmptyAnnotatedStruct;
        }

        CompleteTypeDetail detail_EmptyAnnotatedStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EmptyAnnotatedStruct, ann_custom_EmptyAnnotatedStruct, type_name_EmptyAnnotatedStruct.to_string());
        CompleteStructHeader header_EmptyAnnotatedStruct;
        header_EmptyAnnotatedStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_EmptyAnnotatedStruct);
        CompleteStructMemberSeq member_seq_EmptyAnnotatedStruct;
        CompleteStructType struct_type_EmptyAnnotatedStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_EmptyAnnotatedStruct, header_EmptyAnnotatedStruct, member_seq_EmptyAnnotatedStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_EmptyAnnotatedStruct, type_name_EmptyAnnotatedStruct.to_string(), type_ids_EmptyAnnotatedStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "EmptyAnnotatedStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

namespace BasicAnnotationsTest {



} // namespace BasicAnnotationsTest

void register_BasicAnnotationsTest_type_identifier(
        TypeIdentifierPair& type_ids_BasicAnnotationsTest)
{
    ReturnCode_t return_code_BasicAnnotationsTest {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BasicAnnotationsTest =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BasicAnnotationsTest", type_ids_BasicAnnotationsTest);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BasicAnnotationsTest)
    {
        AnnotationTypeFlag annotation_flag_BasicAnnotationsTest = 0;
        QualifiedTypeName annotation_name_BasicAnnotationsTest = "BasicAnnotationsTest";
        CompleteAnnotationHeader header_BasicAnnotationsTest = TypeObjectUtils::build_complete_annotation_header(annotation_name_BasicAnnotationsTest);
        CompleteAnnotationParameterSeq member_seq_BasicAnnotationsTest;
        {
            ReturnCode_t return_code_var_basic_short;
            TypeIdentifierPair type_ids_var_basic_short;
            AnnotationParameterFlag member_flags_var_basic_short = 0;
            return_code_var_basic_short =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_var_basic_short);

            if (return_code_var_basic_short != eprosima::fastdds::dds::RETCODE_OK)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_basic_short annotation parameter TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            CommonAnnotationParameter common_var_basic_short;
            if (EK_COMPLETE == type_ids_var_basic_short.type_identifier1()._d() || TK_NONE == type_ids_var_basic_short.type_identifier2()._d())
            {
                common_var_basic_short = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_basic_short, type_ids_var_basic_short.type_identifier1());
            }
            else if (EK_COMPLETE == type_ids_var_basic_short.type_identifier2()._d())
            {
                common_var_basic_short = TypeObjectUtils::build_common_annotation_parameter(member_flags_var_basic_short, type_ids_var_basic_short.type_identifier2());
            }
            else
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "var_basic_short annotation parameter TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_var_basic_short = "var_basic_short";
            AnnotationParameterValue param_value_var_basic_short = TypeObjectUtils::build_annotation_parameter_value(static_cast<int16_t>(0));

            CompleteAnnotationParameter param_var_basic_short = TypeObjectUtils::build_complete_annotation_parameter(common_var_basic_short, name_var_basic_short, param_value_var_basic_short);
            TypeObjectUtils::add_complete_annotation_parameter(member_seq_BasicAnnotationsTest, param_var_basic_short);
        }
        CompleteAnnotationType annotation_type_BasicAnnotationsTest = TypeObjectUtils::build_complete_annotation_type(annotation_flag_BasicAnnotationsTest, header_BasicAnnotationsTest,
                member_seq_BasicAnnotationsTest);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_annotation_type_object(annotation_type_BasicAnnotationsTest,
                    annotation_name_BasicAnnotationsTest.to_string(), type_ids_BasicAnnotationsTest))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "BasicAnnotationsTest already registered in TypeObjectRegistry for a different type.");
        }
    }
}
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_BasicAnnotationsStruct_type_identifier(
        TypeIdentifierPair& type_ids_BasicAnnotationsStruct)
{

    ReturnCode_t return_code_BasicAnnotationsStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BasicAnnotationsStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "BasicAnnotationsStruct", type_ids_BasicAnnotationsStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BasicAnnotationsStruct)
    {
        StructTypeFlag struct_flags_BasicAnnotationsStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_BasicAnnotationsStruct = "BasicAnnotationsStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BasicAnnotationsStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BasicAnnotationsStruct;
        AppliedAnnotationSeq tmp_ann_custom_BasicAnnotationsStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_BasicAnnotationsStruct;
        {
            eprosima::fastcdr::optional<AppliedAnnotationParameterSeq> applied_annotation_parameter_seq_BasicAnnotationsStruct;
            AppliedAnnotationParameterSeq tmp_applied_annotation_parameter_seq_BasicAnnotationsStruct;
        {
            NameHash paramname_hash_var_basic_short = TypeObjectUtils::name_hash("var_basic_short");
            AnnotationParameterValue param_value_var_basic_short = TypeObjectUtils::build_annotation_parameter_value(static_cast<int16_t>(1));

            AppliedAnnotationParameter applied_param_var_basic_short = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_basic_short,
                    param_value_var_basic_short);
            TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_BasicAnnotationsStruct, applied_param_var_basic_short);
        }

            {
                AppliedAnnotation applied_annotation_BasicAnnotationsStruct;
                ReturnCode_t return_code_BasicAnnotationsTest {eprosima::fastdds::dds::RETCODE_OK};
                TypeIdentifierPair type_ids_BasicAnnotationsTest;
                return_code_BasicAnnotationsTest =
                    eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                    "BasicAnnotationsTest", type_ids_BasicAnnotationsTest);
                if (return_code_BasicAnnotationsTest != eprosima::fastdds::dds::RETCODE_OK)
                {
        ::register_BasicAnnotationsTest_type_identifier(type_ids_BasicAnnotationsTest);
                }
                if (!tmp_applied_annotation_parameter_seq_BasicAnnotationsStruct.empty())
                {
                    applied_annotation_parameter_seq_BasicAnnotationsStruct = tmp_applied_annotation_parameter_seq_BasicAnnotationsStruct;
                }
                if (EK_COMPLETE == type_ids_BasicAnnotationsTest.type_identifier1()._d())
                {
                    applied_annotation_BasicAnnotationsStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_BasicAnnotationsTest.type_identifier1(), applied_annotation_parameter_seq_BasicAnnotationsStruct);
                }
                else if (EK_COMPLETE == type_ids_BasicAnnotationsTest.type_identifier2()._d())
                {
                    applied_annotation_BasicAnnotationsStruct =
                        TypeObjectUtils::build_applied_annotation(type_ids_BasicAnnotationsTest.type_identifier2(), applied_annotation_parameter_seq_BasicAnnotationsStruct);
                }
                else
                {
                    EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "BasicAnnotationsStruct Structure: Given Annotation TypeIdentifier is inconsistent.");
                    return;
                }
                TypeObjectUtils::add_applied_annotation(tmp_ann_custom_BasicAnnotationsStruct, applied_annotation_BasicAnnotationsStruct);
            }
        }

        if (!tmp_ann_custom_BasicAnnotationsStruct.empty())
        {
            ann_custom_BasicAnnotationsStruct = tmp_ann_custom_BasicAnnotationsStruct;
        }

        CompleteTypeDetail detail_BasicAnnotationsStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BasicAnnotationsStruct, ann_custom_BasicAnnotationsStruct, type_name_BasicAnnotationsStruct.to_string());
        CompleteStructHeader header_BasicAnnotationsStruct;
        header_BasicAnnotationsStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_BasicAnnotationsStruct);
        CompleteStructMemberSeq member_seq_BasicAnnotationsStruct;
        {
            TypeIdentifierPair type_ids_basic_annotations_member;
            ReturnCode_t return_code_basic_annotations_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_basic_annotations_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int16_t", type_ids_basic_annotations_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_basic_annotations_member)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "basic_annotations_member Structure member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            StructMemberFlag member_flags_basic_annotations_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_basic_annotations_member = 0x00000000;
            bool common_basic_annotations_member_ec {false};
            CommonStructMember common_basic_annotations_member {TypeObjectUtils::build_common_struct_member(member_id_basic_annotations_member, member_flags_basic_annotations_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_basic_annotations_member, common_basic_annotations_member_ec))};
            if (!common_basic_annotations_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure basic_annotations_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_basic_annotations_member = "basic_annotations_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_basic_annotations_member;
            ann_custom_BasicAnnotationsStruct.reset();
            AppliedAnnotationSeq tmp_ann_custom_basic_annotations_member;
            eprosima::fastcdr::optional<std::string> unit_basic_annotations_member;
            eprosima::fastcdr::optional<AnnotationParameterValue> min_basic_annotations_member;
            eprosima::fastcdr::optional<AnnotationParameterValue> max_basic_annotations_member;
            eprosima::fastcdr::optional<std::string> hash_id_basic_annotations_member;
            {
                eprosima::fastcdr::optional<AppliedAnnotationParameterSeq> applied_annotation_parameter_seq_basic_annotations_member;
                AppliedAnnotationParameterSeq tmp_applied_annotation_parameter_seq_basic_annotations_member;
            {
                NameHash paramname_hash_var_basic_short = TypeObjectUtils::name_hash("var_basic_short");
                AnnotationParameterValue param_value_var_basic_short = TypeObjectUtils::build_annotation_parameter_value(static_cast<int16_t>(1));

                AppliedAnnotationParameter applied_param_var_basic_short = TypeObjectUtils::build_applied_annotation_parameter(paramname_hash_var_basic_short,
                        param_value_var_basic_short);
                TypeObjectUtils::add_applied_annotation_parameter(tmp_applied_annotation_parameter_seq_basic_annotations_member, applied_param_var_basic_short);
            }

                {
                    AppliedAnnotation applied_annotation_basic_annotations_member;
                    ReturnCode_t return_code_BasicAnnotationsTest {eprosima::fastdds::dds::RETCODE_OK};
                    TypeIdentifierPair type_ids_BasicAnnotationsTest;
                    return_code_BasicAnnotationsTest =
                        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                        "BasicAnnotationsTest", type_ids_BasicAnnotationsTest);
                    if (return_code_BasicAnnotationsTest != eprosima::fastdds::dds::RETCODE_OK)
                    {
            ::register_BasicAnnotationsTest_type_identifier(type_ids_BasicAnnotationsTest);
                    }
                    if (!tmp_applied_annotation_parameter_seq_basic_annotations_member.empty())
                    {
                        applied_annotation_parameter_seq_basic_annotations_member = tmp_applied_annotation_parameter_seq_basic_annotations_member;
                    }
                    if (EK_COMPLETE == type_ids_BasicAnnotationsTest.type_identifier1()._d())
                    {
                        applied_annotation_basic_annotations_member =
                            TypeObjectUtils::build_applied_annotation(type_ids_BasicAnnotationsTest.type_identifier1(), applied_annotation_parameter_seq_basic_annotations_member);
                    }
                    else if (EK_COMPLETE == type_ids_BasicAnnotationsTest.type_identifier2()._d())
                    {
                        applied_annotation_basic_annotations_member =
                            TypeObjectUtils::build_applied_annotation(type_ids_BasicAnnotationsTest.type_identifier2(), applied_annotation_parameter_seq_basic_annotations_member);
                    }
                    else
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                                "BasicAnnotationsStruct basic_annotations_member member: Given Annotation TypeIdentifier is inconsistent.");
                        return;
                    }
                    TypeObjectUtils::add_applied_annotation(tmp_ann_custom_basic_annotations_member, applied_annotation_basic_annotations_member);
                }
            }

            if (unit_basic_annotations_member.has_value() || min_basic_annotations_member.has_value() || max_basic_annotations_member.has_value() || hash_id_basic_annotations_member.has_value())
            {
                member_ann_builtin_basic_annotations_member = TypeObjectUtils::build_applied_builtin_member_annotations(unit_basic_annotations_member, min_basic_annotations_member, max_basic_annotations_member, hash_id_basic_annotations_member);
            }
            if (!tmp_ann_custom_basic_annotations_member.empty())
            {
                ann_custom_BasicAnnotationsStruct = tmp_ann_custom_basic_annotations_member;
            }
            CompleteMemberDetail detail_basic_annotations_member = TypeObjectUtils::build_complete_member_detail(name_basic_annotations_member, member_ann_builtin_basic_annotations_member, ann_custom_BasicAnnotationsStruct);
            CompleteStructMember member_basic_annotations_member = TypeObjectUtils::build_complete_struct_member(common_basic_annotations_member, detail_basic_annotations_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_BasicAnnotationsStruct, member_basic_annotations_member);
        }
        CompleteStructType struct_type_BasicAnnotationsStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_BasicAnnotationsStruct, header_BasicAnnotationsStruct, member_seq_BasicAnnotationsStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_BasicAnnotationsStruct, type_name_BasicAnnotationsStruct.to_string(), type_ids_BasicAnnotationsStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "BasicAnnotationsStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}

